/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client.domain;

import io.dapr.client.domain.HttpExtension;
import io.dapr.client.domain.InvokeMethodRequest;

public class InvokeMethodRequestBuilder {
    private final String appId;
    private final String method;
    private String contentType;
    private Object body;
    private HttpExtension httpExtension = HttpExtension.NONE;

    public InvokeMethodRequestBuilder(String appId, String method) {
        this.appId = appId;
        this.method = method;
    }

    public InvokeMethodRequestBuilder withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public InvokeMethodRequestBuilder withBody(Object body) {
        this.body = body;
        return this;
    }

    public InvokeMethodRequestBuilder withHttpExtension(HttpExtension httpExtension) {
        this.httpExtension = httpExtension;
        return this;
    }

    public InvokeMethodRequest build() {
        InvokeMethodRequest request = new InvokeMethodRequest();
        request.setAppId(this.appId);
        request.setContentType(this.contentType);
        request.setMethod(this.method);
        request.setBody(this.body);
        request.setHttpExtension(this.httpExtension);
        return request;
    }
}

