/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.config;

import io.dapr.client.DaprApiProtocol;
import io.dapr.config.GenericProperty;
import io.dapr.config.IntegerProperty;
import io.dapr.config.Property;
import io.dapr.config.StringProperty;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class Properties {
    private static final String DEFAULT_SIDECAR_IP = "127.0.0.1";
    private static final Integer DEFAULT_HTTP_PORT = 3500;
    private static final Integer DEFAULT_GRPC_PORT = 50001;
    private static final DaprApiProtocol DEFAULT_API_PROTOCOL = DaprApiProtocol.GRPC;
    private static final DaprApiProtocol DEFAULT_API_METHOD_INVOCATION_PROTOCOL = DaprApiProtocol.HTTP;
    private static final Charset DEFAULT_STRING_CHARSET = StandardCharsets.UTF_8;
    private static final Integer DEFAULT_HTTP_CLIENT_READTIMEOUTSECONDS = 60;
    public static final Property<String> SIDECAR_IP = new StringProperty("dapr.sidecar.ip", "DAPR_SIDECAR_IP", "127.0.0.1");
    public static final Property<Integer> HTTP_PORT = new IntegerProperty("dapr.http.port", "DAPR_HTTP_PORT", DEFAULT_HTTP_PORT);
    public static final Property<Integer> GRPC_PORT = new IntegerProperty("dapr.grpc.port", "DAPR_GRPC_PORT", DEFAULT_GRPC_PORT);
    public static final Property<DaprApiProtocol> API_PROTOCOL = new GenericProperty<DaprApiProtocol>("dapr.api.protocol", "DAPR_API_PROTOCOL", DEFAULT_API_PROTOCOL, s -> DaprApiProtocol.valueOf(s.toUpperCase()));
    public static final Property<DaprApiProtocol> API_METHOD_INVOCATION_PROTOCOL = new GenericProperty<DaprApiProtocol>("dapr.api.methodInvocation.protocol", "DAPR_API_METHOD_INVOCATION_PROTOCOL", DEFAULT_API_METHOD_INVOCATION_PROTOCOL, s -> DaprApiProtocol.valueOf(s.toUpperCase()));
    public static final Property<String> API_TOKEN = new StringProperty("dapr.api.token", "DAPR_API_TOKEN", null);
    public static final Property<Charset> STRING_CHARSET = new GenericProperty<Charset>("dapr.string.charset", "DAPR_STRING_CHARSET", DEFAULT_STRING_CHARSET, s -> Charset.forName(s));
    public static final Property<Integer> HTTP_CLIENT_READ_TIMEOUT_SECONDS = new IntegerProperty("dapr.http.client.readTimeoutSeconds", "DAPR_HTTP_CLIENT_READ_TIMEOUT_SECONDS", DEFAULT_HTTP_CLIENT_READTIMEOUTSECONDS);
}

