/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import reactor.core.publisher.Mono;

class GrpcChannelFacade
implements Closeable {
    private final ManagedChannel channel;

    GrpcChannelFacade(ManagedChannel channel) {
        this.channel = channel;
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null && !this.channel.isShutdown()) {
            this.channel.shutdown();
        }
    }

    public Mono<Void> waitForChannelReady(int timeoutInMilliseconds) {
        return Mono.fromRunnable(() -> {
            boolean isReady = false;
            long startTime = System.currentTimeMillis();
            while (!isReady && System.currentTimeMillis() - startTime < (long)timeoutInMilliseconds) {
                isReady = this.channel.getState(true) == ConnectivityState.READY;
                if (isReady) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Waiting for gRPC channel ready interrupted.", e);
                }
            }
            if (!isReady) {
                throw new RuntimeException("Timeout waiting for gRPC channel to be ready.");
            }
        });
    }
}

