/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.dapr.client.domain.query.Query;
import java.util.Collections;
import java.util.Map;

public class QueryStateRequest {
    @JsonIgnore
    private final String storeName;
    private Query query;
    private String queryString;
    @JsonIgnore
    private Map<String, String> metadata;

    public QueryStateRequest(String storeName) {
        this.storeName = storeName;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public Query getQuery() {
        return this.query;
    }

    public QueryStateRequest setQuery(Query query) {
        if (this.queryString != null) {
            throw new IllegalArgumentException("queryString filed is already set in the request. query field cannot be set.");
        }
        if (query == null || query.getFilter() == null) {
            throw new IllegalArgumentException("query cannot be null or with null filter");
        }
        this.query = query;
        return this;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public QueryStateRequest setQueryString(String queryString) {
        if (this.query != null) {
            throw new IllegalArgumentException("query filed is already set in the request. queryString field cannot be set.");
        }
        if (queryString == null || queryString.isEmpty()) {
            throw new IllegalArgumentException("queryString cannot be null or blank");
        }
        this.queryString = queryString;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public QueryStateRequest setMetadata(Map<String, String> metadata) {
        this.metadata = metadata == null ? null : Collections.unmodifiableMap(metadata);
        return this;
    }
}

