/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.internal.opencensus;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import io.dapr.internal.opencensus.SpanContext;
import io.dapr.internal.opencensus.SpanId;
import io.dapr.internal.opencensus.TraceId;
import io.dapr.internal.opencensus.TraceOptions;
import io.dapr.internal.opencensus.Tracestate;
import io.grpc.Metadata;
import java.util.List;
import java.util.regex.Pattern;

class TraceContextFormat {
    private static final Tracestate TRACESTATE_DEFAULT = Tracestate.builder().build();
    private static final String TRACEPARENT = "traceparent";
    private static final String TRACESTATE = "tracestate";
    private static final Metadata.Key<String> TRACEPARENT_KEY = Metadata.Key.of((String)"traceparent", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> TRACESTATE_KEY = Metadata.Key.of((String)"tracestate", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final int VERSION_SIZE = 2;
    private static final char TRACEPARENT_DELIMITER = '-';
    private static final int TRACEPARENT_DELIMITER_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE = 32;
    private static final int SPAN_ID_HEX_SIZE = 16;
    private static final int TRACE_OPTION_HEX_SIZE = 2;
    private static final int TRACE_ID_OFFSET = 3;
    private static final int SPAN_ID_OFFSET = 36;
    private static final int TRACE_OPTION_OFFSET = 53;
    private static final int TRACEPARENT_HEADER_SIZE = 55;
    private static final int TRACESTATE_MAX_MEMBERS = 32;
    private static final char TRACESTATE_KEY_VALUE_DELIMITER = '=';
    private static final char TRACESTATE_ENTRY_DELIMITER = ',';
    private static final Splitter TRACESTATE_ENTRY_DELIMITER_SPLITTER = Splitter.on((Pattern)Pattern.compile("[ \t]*,[ \t]*"));

    TraceContextFormat() {
    }

    static SpanContext extract(Metadata metadata) {
        String traceparent = (String)metadata.get(TRACEPARENT_KEY);
        if (traceparent == null) {
            throw new RuntimeException("Traceparent not present");
        }
        Preconditions.checkArgument((traceparent.charAt(52) == '-' && (traceparent.length() == 55 || traceparent.length() > 55 && traceparent.charAt(55) == '-') && traceparent.charAt(35) == '-' && traceparent.charAt(52) == '-' ? 1 : 0) != 0, (Object)"Missing or malformed TRACEPARENT.");
        TraceId traceId = TraceId.fromLowerBase16(traceparent, 3);
        SpanId spanId = SpanId.fromLowerBase16(traceparent, 36);
        TraceOptions traceOptions = TraceOptions.fromLowerBase16(traceparent, 53);
        String tracestate = (String)metadata.get(TRACESTATE_KEY);
        if (tracestate == null || tracestate.isEmpty()) {
            return SpanContext.create(traceId, spanId, traceOptions, TRACESTATE_DEFAULT);
        }
        Tracestate.Builder tracestateBuilder = Tracestate.builder();
        List listMembers = TRACESTATE_ENTRY_DELIMITER_SPLITTER.splitToList((CharSequence)tracestate);
        Preconditions.checkArgument((listMembers.size() <= 32 ? 1 : 0) != 0, (Object)"Tracestate has too many elements.");
        for (int i = listMembers.size() - 1; i >= 0; --i) {
            String listMember = (String)listMembers.get(i);
            int index = listMember.indexOf(61);
            Preconditions.checkArgument((index != -1 ? 1 : 0) != 0, (Object)"Invalid tracestate list-member format.");
            tracestateBuilder.set(listMember.substring(0, index), listMember.substring(index + 1, listMember.length()));
        }
        return SpanContext.create(traceId, spanId, traceOptions, tracestateBuilder.build());
    }
}

