/*
 * Copyright 2021 The Dapr Authors
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
limitations under the License.
*/

package io.dapr.config;

import java.util.function.Function;

/**
 * Configuration property for any type.
 */
public class GenericProperty<T> extends Property<T> {

  private final Function<String, T> parser;

  /**
   * {@inheritDoc}
   */
  GenericProperty(String name, String envName, T defaultValue, Function<String, T> parser) {
    super(name, envName, defaultValue);
    this.parser = parser;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected T parse(String value) {
    return parser.apply(value);
  }

}
