/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.exceptions;

import com.google.rpc.Status;
import io.dapr.exceptions.DaprError;
import io.dapr.exceptions.DaprErrorDetails;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.StatusProto;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DaprException
extends RuntimeException {
    private String errorCode;
    private DaprErrorDetails errorDetails;
    private byte[] payload;

    public DaprException(DaprError daprError, byte[] payload) {
        this(daprError.getErrorCode(), daprError.getMessage(), daprError.getDetails(), payload);
    }

    public DaprException(DaprError daprError, Throwable cause) {
        this(daprError.getErrorCode(), daprError.getMessage(), cause);
    }

    public DaprException(Throwable exception) {
        this("UNKNOWN", exception.getMessage(), exception);
    }

    public DaprException(String errorCode, String message, byte[] payload) {
        this(errorCode, message, DaprErrorDetails.EMPTY_INSTANCE, payload);
    }

    public DaprException(String errorCode, String message, List<Map<String, Object>> errorDetails, byte[] payload) {
        this(errorCode, message, new DaprErrorDetails(errorDetails), payload);
    }

    public DaprException(String errorCode, String message, DaprErrorDetails errorDetails, byte[] payload) {
        super(String.format("%s: %s", errorCode, message));
        this.errorCode = errorCode;
        this.errorDetails = errorDetails;
        this.payload = payload;
    }

    public DaprException(String errorCode, String message, Throwable cause) {
        super(String.format("%s: %s", errorCode, DaprException.emptyIfNull(message)), cause);
        this.errorCode = errorCode;
    }

    public DaprException(String errorCode, String message, Throwable cause, DaprErrorDetails errorDetails, byte[] payload) {
        super(String.format("%s: %s", errorCode, DaprException.emptyIfNull(message)), cause);
        this.errorCode = errorCode;
        this.errorDetails = errorDetails == null ? DaprErrorDetails.EMPTY_INSTANCE : errorDetails;
        this.payload = payload;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public DaprErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public byte[] getPayload() {
        return this.payload == null ? null : (byte[])this.payload.clone();
    }

    public static void wrap(Throwable exception) {
        if (exception == null) {
            return;
        }
        throw DaprException.propagate(exception);
    }

    public static <T> Callable<T> wrap(Callable<T> callable) {
        return () -> {
            try {
                return callable.call();
            }
            catch (Exception e) {
                DaprException.wrap(e);
                return null;
            }
        };
    }

    public static Runnable wrap(Runnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                DaprException.wrap(e);
            }
        };
    }

    public static <T> Mono<T> wrapMono(Exception exception) {
        try {
            DaprException.wrap(exception);
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        return Mono.empty();
    }

    public static <T> Flux<T> wrapFlux(Exception exception) {
        try {
            DaprException.wrap(exception);
        }
        catch (Exception e) {
            return Flux.error((Throwable)e);
        }
        return Flux.empty();
    }

    public static RuntimeException propagate(Throwable exception) {
        Exceptions.throwIfFatal((Throwable)exception);
        if (exception instanceof DaprException) {
            return (DaprException)exception;
        }
        for (Throwable e = exception; e != null; e = e.getCause()) {
            if (!(e instanceof StatusRuntimeException)) continue;
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)e;
            Status status = StatusProto.fromThrowable((Throwable)statusRuntimeException);
            DaprErrorDetails errorDetails = new DaprErrorDetails(status);
            return new DaprException(statusRuntimeException.getStatus().getCode().toString(), statusRuntimeException.getStatus().getDescription(), exception, errorDetails, status.toByteArray());
        }
        if (exception instanceof IllegalArgumentException) {
            return (IllegalArgumentException)exception;
        }
        return new DaprException(exception);
    }

    private static String emptyIfNull(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }
}

