/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client.domain.query.filters;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import io.dapr.client.domain.query.filters.Filter;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class InFilter<T>
extends Filter<T> {
    @JsonValue
    private Map.Entry<String, List<T>> in;

    public InFilter() {
        super("IN");
    }

    public InFilter(String key, List<T> value) {
        super("IN");
        this.in = new AbstractMap.SimpleEntry<String, List<T>>(key, value);
    }

    @JsonCreator
    InFilter(Map.Entry<String, List<T>> in) {
        super("IN");
        this.in = in;
    }

    public InFilter(String key, T ... values) {
        super("IN");
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("list of values must be at least 1");
        }
        this.in = new AbstractMap.SimpleImmutableEntry<String, List<T>>(key, Collections.unmodifiableList(Arrays.asList(values)));
    }

    @JsonIgnore
    public String getKey() {
        return this.in != null ? this.in.getKey() : null;
    }

    @JsonIgnore
    public List<T> getValues() {
        return this.in != null ? this.in.getValue() : null;
    }

    @Override
    public String getRepresentation() {
        return this.getKey() + " IN [" + this.getValues().stream().map(Object::toString).collect(Collectors.joining(",")) + "]";
    }

    @Override
    public Boolean isValid() {
        return this.in != null && this.in.getKey() != null && !this.in.getKey().isEmpty() && !this.in.getKey().trim().isEmpty() && this.in.getValue() != null && this.in.getValue().size() > 0;
    }
}

