/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.utils;

import io.dapr.config.Properties;
import io.dapr.utils.Version;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;

public final class NetworkUtils {
    private static final long RETRY_WAIT_MILLISECONDS = 1000L;

    private NetworkUtils() {
    }

    public static void waitForSocket(String host, int port, int timeoutInMilliseconds) throws InterruptedException {
        long started = System.currentTimeMillis();
        NetworkUtils.callWithRetry(() -> {
            try (Socket socket = new Socket();){
                int remainingTimeout = (int)Math.max(1L, (long)timeoutInMilliseconds - (System.currentTimeMillis() - started));
                socket.connect(new InetSocketAddress(host, port), remainingTimeout);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, timeoutInMilliseconds);
    }

    public static ManagedChannel buildGrpcManagedChannel(ClientInterceptor ... interceptors) {
        Object address = Properties.SIDECAR_IP.get();
        int port = Properties.GRPC_PORT.get();
        boolean insecure = true;
        String grpcEndpoint = Properties.GRPC_ENDPOINT.get();
        if (grpcEndpoint != null && !grpcEndpoint.isEmpty()) {
            URI uri = URI.create(grpcEndpoint);
            insecure = uri.getScheme().equalsIgnoreCase("http");
            port = uri.getPort() > 0 ? uri.getPort() : (insecure ? 80 : 443);
            address = uri.getHost();
            if (uri.getPath() != null && !uri.getPath().isEmpty()) {
                address = (String)address + uri.getPath();
            }
        }
        ManagedChannelBuilder builder = ManagedChannelBuilder.forAddress((String)address, (int)port).userAgent(Version.getSdkVersion());
        if (insecure) {
            builder = builder.usePlaintext();
        }
        if (interceptors != null && interceptors.length > 0) {
            builder = builder.intercept(interceptors);
        }
        return builder.build();
    }

    private static void callWithRetry(Runnable function, long retryTimeoutMilliseconds) throws InterruptedException {
        long started = System.currentTimeMillis();
        while (true) {
            Object exception;
            try {
                function.run();
                return;
            }
            catch (Exception e) {
                exception = e;
            }
            catch (AssertionError e) {
                exception = e;
            }
            long elapsed = System.currentTimeMillis() - started;
            if (elapsed >= retryTimeoutMilliseconds) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException((Throwable)exception);
            }
            long remaining = retryTimeoutMilliseconds - elapsed;
            Thread.sleep(Math.min(remaining, 1000L));
        }
    }
}

