/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import io.dapr.client.DaprClient;
import io.dapr.client.DaprClientImpl;
import io.dapr.client.DaprHttp;
import io.dapr.client.DaprHttpBuilder;
import io.dapr.client.DaprPreviewClient;
import io.dapr.client.GrpcChannelFacade;
import io.dapr.client.resiliency.ResiliencyOptions;
import io.dapr.serializer.DaprObjectSerializer;
import io.dapr.serializer.DefaultObjectSerializer;
import io.dapr.utils.NetworkUtils;
import io.dapr.v1.DaprGrpc;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;

public class DaprClientBuilder {
    private final DaprHttpBuilder daprHttpBuilder;
    private DaprObjectSerializer objectSerializer = new DefaultObjectSerializer();
    private DaprObjectSerializer stateSerializer = new DefaultObjectSerializer();
    private ResiliencyOptions resiliencyOptions;

    public DaprClientBuilder() {
        this.daprHttpBuilder = new DaprHttpBuilder();
    }

    public DaprClientBuilder withObjectSerializer(DaprObjectSerializer objectSerializer) {
        if (objectSerializer == null) {
            throw new IllegalArgumentException("Object serializer is required");
        }
        if (objectSerializer.getContentType() == null || objectSerializer.getContentType().isEmpty()) {
            throw new IllegalArgumentException("Content Type should not be null or empty");
        }
        this.objectSerializer = objectSerializer;
        return this;
    }

    public DaprClientBuilder withStateSerializer(DaprObjectSerializer stateSerializer) {
        if (stateSerializer == null) {
            throw new IllegalArgumentException("State serializer is required");
        }
        this.stateSerializer = stateSerializer;
        return this;
    }

    public DaprClientBuilder withResiliencyOptions(ResiliencyOptions options) {
        this.resiliencyOptions = options;
        return this;
    }

    public DaprClient build() {
        return this.buildDaprClient();
    }

    public DaprPreviewClient buildPreviewClient() {
        return this.buildDaprClient();
    }

    private DaprClientImpl buildDaprClient() {
        ManagedChannel channel = NetworkUtils.buildGrpcManagedChannel(new ClientInterceptor[0]);
        DaprHttp daprHttp = this.daprHttpBuilder.build();
        GrpcChannelFacade channelFacade = new GrpcChannelFacade(channel);
        DaprGrpc.DaprStub asyncStub = DaprGrpc.newStub((Channel)channel);
        return new DaprClientImpl(channelFacade, asyncStub, daprHttp, this.objectSerializer, this.stateSerializer, this.resiliencyOptions);
    }
}

