/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import com.google.common.base.Strings;
import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import io.dapr.client.AbstractDaprClient;
import io.dapr.client.DaprHttp;
import io.dapr.client.GrpcChannelFacade;
import io.dapr.client.domain.ActorMetadata;
import io.dapr.client.domain.AppConnectionPropertiesHealthMetadata;
import io.dapr.client.domain.AppConnectionPropertiesMetadata;
import io.dapr.client.domain.BulkPublishEntry;
import io.dapr.client.domain.BulkPublishRequest;
import io.dapr.client.domain.BulkPublishResponse;
import io.dapr.client.domain.BulkPublishResponseFailedEntry;
import io.dapr.client.domain.ComponentMetadata;
import io.dapr.client.domain.ConfigurationItem;
import io.dapr.client.domain.DaprMetadata;
import io.dapr.client.domain.DeleteStateRequest;
import io.dapr.client.domain.ExecuteStateTransactionRequest;
import io.dapr.client.domain.GetBulkSecretRequest;
import io.dapr.client.domain.GetBulkStateRequest;
import io.dapr.client.domain.GetConfigurationRequest;
import io.dapr.client.domain.GetSecretRequest;
import io.dapr.client.domain.GetStateRequest;
import io.dapr.client.domain.HttpEndpointMetadata;
import io.dapr.client.domain.HttpExtension;
import io.dapr.client.domain.InvokeBindingRequest;
import io.dapr.client.domain.InvokeMethodRequest;
import io.dapr.client.domain.LockRequest;
import io.dapr.client.domain.PublishEventRequest;
import io.dapr.client.domain.QueryStateItem;
import io.dapr.client.domain.QueryStateRequest;
import io.dapr.client.domain.QueryStateResponse;
import io.dapr.client.domain.RuleMetadata;
import io.dapr.client.domain.SaveStateRequest;
import io.dapr.client.domain.State;
import io.dapr.client.domain.StateOptions;
import io.dapr.client.domain.SubscribeConfigurationRequest;
import io.dapr.client.domain.SubscribeConfigurationResponse;
import io.dapr.client.domain.SubscriptionMetadata;
import io.dapr.client.domain.TransactionalStateOperation;
import io.dapr.client.domain.UnlockRequest;
import io.dapr.client.domain.UnlockResponseStatus;
import io.dapr.client.domain.UnsubscribeConfigurationRequest;
import io.dapr.client.domain.UnsubscribeConfigurationResponse;
import io.dapr.client.resiliency.ResiliencyOptions;
import io.dapr.exceptions.DaprException;
import io.dapr.internal.grpc.DaprClientGrpcInterceptors;
import io.dapr.internal.resiliency.RetryPolicy;
import io.dapr.internal.resiliency.TimeoutPolicy;
import io.dapr.serializer.DaprObjectSerializer;
import io.dapr.serializer.DefaultObjectSerializer;
import io.dapr.utils.DefaultContentTypeConverter;
import io.dapr.utils.TypeRef;
import io.dapr.v1.CommonProtos;
import io.dapr.v1.DaprGrpc;
import io.dapr.v1.DaprProtos;
import io.grpc.Channel;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.util.context.ContextView;
import reactor.util.retry.Retry;
import reactor.util.retry.RetryBackoffSpec;

public class DaprClientImpl
extends AbstractDaprClient {
    private final GrpcChannelFacade channel;
    private final TimeoutPolicy timeoutPolicy;
    private final RetryPolicy retryPolicy;
    private final DaprGrpc.DaprStub asyncStub;
    private final DaprHttp httpClient;

    DaprClientImpl(GrpcChannelFacade channel, DaprGrpc.DaprStub asyncStub, DaprHttp httpClient, DaprObjectSerializer objectSerializer, DaprObjectSerializer stateSerializer) {
        this(channel, asyncStub, httpClient, objectSerializer, stateSerializer, null);
    }

    DaprClientImpl(GrpcChannelFacade channel, DaprGrpc.DaprStub asyncStub, DaprHttp httpClient, DaprObjectSerializer objectSerializer, DaprObjectSerializer stateSerializer, ResiliencyOptions resiliencyOptions) {
        super(objectSerializer, stateSerializer);
        this.channel = channel;
        this.asyncStub = asyncStub;
        this.httpClient = httpClient;
        this.timeoutPolicy = new TimeoutPolicy(resiliencyOptions == null ? null : resiliencyOptions.getTimeout());
        this.retryPolicy = new RetryPolicy(resiliencyOptions == null ? null : resiliencyOptions.getMaxRetries());
    }

    private CommonProtos.StateOptions.StateConsistency getGrpcStateConsistency(StateOptions options) {
        switch (options.getConsistency()) {
            case EVENTUAL: {
                return CommonProtos.StateOptions.StateConsistency.CONSISTENCY_EVENTUAL;
            }
            case STRONG: {
                return CommonProtos.StateOptions.StateConsistency.CONSISTENCY_STRONG;
            }
        }
        throw new IllegalArgumentException("Missing Consistency mapping to gRPC Consistency enum");
    }

    private CommonProtos.StateOptions.StateConcurrency getGrpcStateConcurrency(StateOptions options) {
        switch (options.getConcurrency()) {
            case FIRST_WRITE: {
                return CommonProtos.StateOptions.StateConcurrency.CONCURRENCY_FIRST_WRITE;
            }
            case LAST_WRITE: {
                return CommonProtos.StateOptions.StateConcurrency.CONCURRENCY_LAST_WRITE;
            }
        }
        throw new IllegalArgumentException("Missing StateConcurrency mapping to gRPC Concurrency enum");
    }

    @Override
    public <T extends AbstractStub<T>> T newGrpcStub(String appId, Function<Channel, T> stubBuilder) {
        return (T)DaprClientGrpcInterceptors.intercept(appId, (AbstractStub)stubBuilder.apply((Channel)this.channel.getGrpcChannel()), this.timeoutPolicy);
    }

    @Override
    public Mono<Void> waitForSidecar(int timeoutInMilliseconds) {
        String[] pathSegments = new String[]{"v1.0", "healthz", "outbound"};
        int maxRetries = 5;
        RetryBackoffSpec retrySpec = Retry.fixedDelay((long)maxRetries, (Duration)Duration.ofMillis(500L)).doBeforeRetry(retrySignal -> System.out.println("Retrying component health check..."));
        Mono<DaprHttp.Response> responseMono = this.httpClient.invokeApi(DaprHttp.HttpMethods.GET.name(), pathSegments, null, "", null, null);
        return responseMono.retryWhen((Retry)retrySpec).timeout(Duration.ofMillis(timeoutInMilliseconds)).onErrorResume(DaprException.class, e -> Mono.error((Throwable)new RuntimeException((Throwable)e))).switchIfEmpty(DaprException.wrapMono(new RuntimeException("Health check timed out"))).then();
    }

    @Override
    public Mono<Void> publishEvent(PublishEventRequest request) {
        try {
            String pubsubName = request.getPubsubName();
            String topic = request.getTopic();
            Object data = request.getData();
            DaprProtos.PublishEventRequest.Builder envelopeBuilder = DaprProtos.PublishEventRequest.newBuilder().setTopic(topic).setPubsubName(pubsubName).setData(ByteString.copyFrom((byte[])this.objectSerializer.serialize(data)));
            String contentType = request.getContentType();
            if (contentType == null || contentType.isEmpty()) {
                contentType = this.objectSerializer.getContentType();
            }
            envelopeBuilder.setDataContentType(contentType);
            Map<String, String> metadata = request.getMetadata();
            if (metadata != null) {
                envelopeBuilder.putAllMetadata(metadata);
            }
            return Mono.deferContextual(context -> this.createMono(it -> this.intercept((ContextView)context, this.asyncStub).publishEvent(envelopeBuilder.build(), it))).then();
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public <T> Mono<BulkPublishResponse<T>> publishEvents(BulkPublishRequest<T> request) {
        try {
            String pubsubName = request.getPubsubName();
            String topic = request.getTopic();
            DaprProtos.BulkPublishRequest.Builder envelopeBuilder = DaprProtos.BulkPublishRequest.newBuilder();
            envelopeBuilder.setTopic(topic);
            envelopeBuilder.setPubsubName(pubsubName);
            if (Strings.isNullOrEmpty((String)pubsubName) || Strings.isNullOrEmpty((String)topic)) {
                throw new IllegalArgumentException("pubsubName and topic name cannot be null or empty");
            }
            for (BulkPublishEntry<T> entry : request.getEntries()) {
                byte[] data;
                T event = entry.getEvent();
                String contentType = entry.getContentType();
                try {
                    if (!Strings.isNullOrEmpty((String)contentType) && this.objectSerializer instanceof DefaultObjectSerializer) {
                        data = DefaultContentTypeConverter.convertEventToBytesForGrpc(event, contentType);
                    } else {
                        data = this.objectSerializer.serialize(event);
                        if (Strings.isNullOrEmpty((String)contentType)) {
                            contentType = this.objectSerializer.getContentType();
                        }
                    }
                }
                catch (IOException ex) {
                    throw DaprException.propagate(ex);
                }
                DaprProtos.BulkPublishRequestEntry.Builder reqEntryBuilder = DaprProtos.BulkPublishRequestEntry.newBuilder().setEntryId(entry.getEntryId()).setEvent(ByteString.copyFrom((byte[])data)).setContentType(contentType);
                Map<String, String> metadata = entry.getMetadata();
                if (metadata != null) {
                    reqEntryBuilder.putAllMetadata(metadata);
                }
                envelopeBuilder.addEntries(reqEntryBuilder.build());
            }
            Map<String, String> metadata = request.getMetadata();
            if (metadata != null) {
                envelopeBuilder.putAllMetadata(metadata);
            }
            HashMap entryMap = new HashMap();
            for (BulkPublishEntry<T> entry : request.getEntries()) {
                entryMap.put(entry.getEntryId(), entry);
            }
            return Mono.deferContextual(context -> this.createMono(it -> this.intercept((ContextView)context, this.asyncStub).bulkPublishEventAlpha1(envelopeBuilder.build(), it))).map(it -> {
                ArrayList entries = new ArrayList();
                for (DaprProtos.BulkPublishResponseFailedEntry entry : it.getFailedEntriesList()) {
                    BulkPublishResponseFailedEntry domainEntry = new BulkPublishResponseFailedEntry((BulkPublishEntry)entryMap.get(entry.getEntryId()), entry.getError());
                    entries.add(domainEntry);
                }
                if (entries.size() > 0) {
                    return new BulkPublishResponse(entries);
                }
                return new BulkPublishResponse();
            });
        }
        catch (RuntimeException ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public <T> Mono<T> invokeMethod(InvokeMethodRequest invokeMethodRequest, TypeRef<T> type) {
        try {
            String appId = invokeMethodRequest.getAppId();
            String method = invokeMethodRequest.getMethod();
            Object request = invokeMethodRequest.getBody();
            HttpExtension httpExtension = invokeMethodRequest.getHttpExtension();
            String contentType = invokeMethodRequest.getContentType();
            Map<String, String> metadata = invokeMethodRequest.getMetadata();
            if (httpExtension == null) {
                throw new IllegalArgumentException("HttpExtension cannot be null. Use HttpExtension.NONE instead.");
            }
            String httpMethod = httpExtension.getMethod().toString();
            if (appId == null || appId.trim().isEmpty()) {
                throw new IllegalArgumentException("App Id cannot be null or empty.");
            }
            if (method == null || method.trim().isEmpty()) {
                throw new IllegalArgumentException("Method name cannot be null or empty.");
            }
            String[] methodSegments = method.split("/");
            ArrayList<String> pathSegments = new ArrayList<String>(Arrays.asList("v1.0", "invoke", appId, "method"));
            pathSegments.addAll(Arrays.asList(methodSegments));
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.putAll(httpExtension.getHeaders());
            if (metadata != null) {
                headers.putAll(metadata);
            }
            byte[] serializedRequestBody = this.objectSerializer.serialize(request);
            if (contentType != null && !contentType.isEmpty()) {
                headers.put("content-type", contentType);
            } else {
                headers.put("content-type", this.objectSerializer.getContentType());
            }
            Mono response = Mono.deferContextual(context -> this.httpClient.invokeApi(httpMethod, pathSegments.toArray(new String[0]), httpExtension.getQueryParams(), serializedRequestBody, (Map<String, String>)headers, (ContextView)context));
            return response.flatMap(r -> this.getMonoForHttpResponse(type, (DaprHttp.Response)r));
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    private <T> Mono<T> getMonoForHttpResponse(TypeRef<T> type, DaprHttp.Response r) {
        try {
            T object = this.objectSerializer.deserialize(r.getBody(), type);
            if (object == null) {
                return Mono.empty();
            }
            return Mono.just(object);
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public <T> Mono<T> invokeBinding(InvokeBindingRequest request, TypeRef<T> type) {
        try {
            String name = request.getName();
            String operation = request.getOperation();
            Object data = request.getData();
            Map<String, String> metadata = request.getMetadata();
            if (name == null || name.trim().isEmpty()) {
                throw new IllegalArgumentException("Binding name cannot be null or empty.");
            }
            if (operation == null || operation.trim().isEmpty()) {
                throw new IllegalArgumentException("Binding operation cannot be null or empty.");
            }
            byte[] byteData = this.objectSerializer.serialize(data);
            DaprProtos.InvokeBindingRequest.Builder builder = DaprProtos.InvokeBindingRequest.newBuilder().setName(name).setOperation(operation);
            if (byteData != null) {
                builder.setData(ByteString.copyFrom((byte[])byteData));
            }
            if (metadata != null) {
                builder.putAllMetadata(metadata);
            }
            DaprProtos.InvokeBindingRequest envelope = builder.build();
            return Mono.deferContextual(context -> this.createMono(it -> this.intercept((ContextView)context, this.asyncStub).invokeBinding(envelope, it))).flatMap(it -> {
                try {
                    return Mono.justOrEmpty(this.objectSerializer.deserialize(it.getData().toByteArray(), type));
                }
                catch (IOException e) {
                    throw DaprException.propagate(e);
                }
            });
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public <T> Mono<State<T>> getState(GetStateRequest request, TypeRef<T> type) {
        try {
            String stateStoreName = request.getStoreName();
            String key = request.getKey();
            StateOptions options = request.getStateOptions();
            Map<String, String> metadata = request.getMetadata();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (key == null || key.trim().isEmpty()) {
                throw new IllegalArgumentException("Key cannot be null or empty.");
            }
            DaprProtos.GetStateRequest.Builder builder = DaprProtos.GetStateRequest.newBuilder().setStoreName(stateStoreName).setKey(key);
            if (metadata != null) {
                builder.putAllMetadata(metadata);
            }
            if (options != null && options.getConsistency() != null) {
                builder.setConsistency(this.getGrpcStateConsistency(options));
            }
            DaprProtos.GetStateRequest envelope = builder.build();
            return Mono.deferContextual(context -> this.createMono(it -> this.intercept((ContextView)context, this.asyncStub).getState(envelope, it))).map(it -> {
                try {
                    return this.buildStateKeyValue((DaprProtos.GetStateResponse)it, key, options, type);
                }
                catch (IOException ex) {
                    throw DaprException.propagate(ex);
                }
            });
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public <T> Mono<List<State<T>>> getBulkState(GetBulkStateRequest request, TypeRef<T> type) {
        try {
            String stateStoreName = request.getStoreName();
            List<String> keys = request.getKeys();
            int parallelism = request.getParallelism();
            Map<String, String> metadata = request.getMetadata();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (keys == null || keys.isEmpty()) {
                throw new IllegalArgumentException("Key cannot be null or empty.");
            }
            if (parallelism < 0) {
                throw new IllegalArgumentException("Parallelism cannot be negative.");
            }
            DaprProtos.GetBulkStateRequest.Builder builder = DaprProtos.GetBulkStateRequest.newBuilder().setStoreName(stateStoreName).addAllKeys(keys).setParallelism(parallelism);
            if (metadata != null) {
                builder.putAllMetadata(metadata);
            }
            DaprProtos.GetBulkStateRequest envelope = builder.build();
            return Mono.deferContextual(context -> this.createMono(it -> this.intercept((ContextView)context, this.asyncStub).getBulkState(envelope, it))).map(it -> it.getItemsList().stream().map(b -> {
                try {
                    return this.buildStateKeyValue((DaprProtos.BulkStateItem)b, type);
                }
                catch (Exception e) {
                    throw DaprException.propagate(e);
                }
            }).collect(Collectors.toList()));
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    private <T> State<T> buildStateKeyValue(DaprProtos.BulkStateItem item, TypeRef<T> type) throws IOException {
        String key = item.getKey();
        String error = item.getError();
        if (!Strings.isNullOrEmpty((String)error)) {
            return new State(key, error);
        }
        ByteString payload = item.getData();
        byte[] data = payload == null ? null : payload.toByteArray();
        T value = this.stateSerializer.deserialize(data, type);
        String etag = item.getEtag();
        if (etag.equals("")) {
            etag = null;
        }
        return new State<T>(key, value, etag, item.getMetadataMap(), null);
    }

    private <T> State<T> buildStateKeyValue(DaprProtos.GetStateResponse response, String requestedKey, StateOptions stateOptions, TypeRef<T> type) throws IOException {
        ByteString payload = response.getData();
        byte[] data = payload == null ? null : payload.toByteArray();
        T value = this.stateSerializer.deserialize(data, type);
        String etag = response.getEtag();
        if (etag.equals("")) {
            etag = null;
        }
        return new State<T>(requestedKey, value, etag, response.getMetadataMap(), stateOptions);
    }

    @Override
    public Mono<Void> executeStateTransaction(ExecuteStateTransactionRequest request) {
        try {
            String stateStoreName = request.getStateStoreName();
            List<TransactionalStateOperation<?>> operations = request.getOperations();
            Map<String, String> metadata = request.getMetadata();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            DaprProtos.ExecuteStateTransactionRequest.Builder builder = DaprProtos.ExecuteStateTransactionRequest.newBuilder();
            builder.setStoreName(stateStoreName);
            if (metadata != null) {
                builder.putAllMetadata(metadata);
            }
            for (TransactionalStateOperation<?> operation : operations) {
                DaprProtos.TransactionalStateOperation.Builder operationBuilder = DaprProtos.TransactionalStateOperation.newBuilder();
                operationBuilder.setOperationType(operation.getOperation().toString().toLowerCase());
                operationBuilder.setRequest(this.buildStateRequest(operation.getRequest()).build());
                builder.addOperations(operationBuilder.build());
            }
            DaprProtos.ExecuteStateTransactionRequest req = builder.build();
            return Mono.deferContextual(context -> this.createMono(it -> this.intercept((ContextView)context, this.asyncStub).executeStateTransaction(req, it))).then();
        }
        catch (Exception e) {
            return DaprException.wrapMono(e);
        }
    }

    @Override
    public Mono<Void> saveBulkState(SaveStateRequest request) {
        try {
            String stateStoreName = request.getStoreName();
            List<State<?>> states = request.getStates();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            DaprProtos.SaveStateRequest.Builder builder = DaprProtos.SaveStateRequest.newBuilder();
            builder.setStoreName(stateStoreName);
            for (State<?> state : states) {
                builder.addStates(this.buildStateRequest(state).build());
            }
            DaprProtos.SaveStateRequest req = builder.build();
            return Mono.deferContextual(context -> this.createMono(it -> this.intercept((ContextView)context, this.asyncStub).saveState(req, it))).then();
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    private <T> CommonProtos.StateItem.Builder buildStateRequest(State<T> state) throws IOException {
        byte[] bytes = this.stateSerializer.serialize(state.getValue());
        CommonProtos.StateItem.Builder stateBuilder = CommonProtos.StateItem.newBuilder();
        if (state.getEtag() != null) {
            stateBuilder.setEtag(CommonProtos.Etag.newBuilder().setValue(state.getEtag()).build());
        }
        if (state.getMetadata() != null) {
            stateBuilder.putAllMetadata(state.getMetadata());
        }
        if (bytes != null) {
            stateBuilder.setValue(ByteString.copyFrom((byte[])bytes));
        }
        stateBuilder.setKey(state.getKey());
        CommonProtos.StateOptions.Builder optionBuilder = null;
        if (state.getOptions() != null) {
            StateOptions options = state.getOptions();
            optionBuilder = CommonProtos.StateOptions.newBuilder();
            if (options.getConcurrency() != null) {
                optionBuilder.setConcurrency(this.getGrpcStateConcurrency(options));
            }
            if (options.getConsistency() != null) {
                optionBuilder.setConsistency(this.getGrpcStateConsistency(options));
            }
        }
        if (optionBuilder != null) {
            stateBuilder.setOptions(optionBuilder.build());
        }
        return stateBuilder;
    }

    @Override
    public Mono<Void> deleteState(DeleteStateRequest request) {
        try {
            String stateStoreName = request.getStateStoreName();
            String key = request.getKey();
            StateOptions options = request.getStateOptions();
            String etag = request.getEtag();
            Map<String, String> metadata = request.getMetadata();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (key == null || key.trim().isEmpty()) {
                throw new IllegalArgumentException("Key cannot be null or empty.");
            }
            CommonProtos.StateOptions.Builder optionBuilder = null;
            if (options != null) {
                optionBuilder = CommonProtos.StateOptions.newBuilder();
                if (options.getConcurrency() != null) {
                    optionBuilder.setConcurrency(this.getGrpcStateConcurrency(options));
                }
                if (options.getConsistency() != null) {
                    optionBuilder.setConsistency(this.getGrpcStateConsistency(options));
                }
            }
            DaprProtos.DeleteStateRequest.Builder builder = DaprProtos.DeleteStateRequest.newBuilder().setStoreName(stateStoreName).setKey(key);
            if (metadata != null) {
                builder.putAllMetadata(metadata);
            }
            if (etag != null) {
                builder.setEtag(CommonProtos.Etag.newBuilder().setValue(etag).build());
            }
            if (optionBuilder != null) {
                builder.setOptions(optionBuilder.build());
            }
            DaprProtos.DeleteStateRequest req = builder.build();
            return Mono.deferContextual(context -> this.createMono(it -> this.intercept((ContextView)context, this.asyncStub).deleteState(req, it))).then();
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public Mono<Map<String, String>> getSecret(GetSecretRequest request) {
        String secretStoreName = request.getStoreName();
        String key = request.getKey();
        Map<String, String> metadata = request.getMetadata();
        try {
            if (secretStoreName == null || secretStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("Secret store name cannot be null or empty.");
            }
            if (key == null || key.trim().isEmpty()) {
                throw new IllegalArgumentException("Secret key cannot be null or empty.");
            }
        }
        catch (Exception e) {
            return DaprException.wrapMono(e);
        }
        DaprProtos.GetSecretRequest.Builder requestBuilder = DaprProtos.GetSecretRequest.newBuilder().setStoreName(secretStoreName).setKey(key);
        if (metadata != null) {
            requestBuilder.putAllMetadata(metadata);
        }
        DaprProtos.GetSecretRequest req = requestBuilder.build();
        return Mono.deferContextual(context -> this.createMono(it -> this.intercept((ContextView)context, this.asyncStub).getSecret(req, it))).map(DaprProtos.GetSecretResponse::getDataMap);
    }

    @Override
    public Mono<Map<String, Map<String, String>>> getBulkSecret(GetBulkSecretRequest request) {
        try {
            String storeName = request.getStoreName();
            Map<String, String> metadata = request.getMetadata();
            if (storeName == null || storeName.trim().isEmpty()) {
                throw new IllegalArgumentException("Secret store name cannot be null or empty.");
            }
            DaprProtos.GetBulkSecretRequest.Builder builder = DaprProtos.GetBulkSecretRequest.newBuilder().setStoreName(storeName);
            if (metadata != null) {
                builder.putAllMetadata(metadata);
            }
            DaprProtos.GetBulkSecretRequest envelope = builder.build();
            return Mono.deferContextual(context -> this.createMono(it -> this.intercept((ContextView)context, this.asyncStub).getBulkSecret(envelope, it))).map(it -> {
                Map secretsMap = it.getDataMap();
                if (secretsMap == null) {
                    return Collections.emptyMap();
                }
                return secretsMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, s -> ((DaprProtos.SecretResponse)s.getValue()).getSecretsMap()));
            });
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public Mono<Boolean> tryLock(LockRequest request) {
        try {
            String stateStoreName = request.getStoreName();
            String resourceId = request.getResourceId();
            String lockOwner = request.getLockOwner();
            Integer expiryInSeconds = request.getExpiryInSeconds();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (resourceId == null || resourceId.isEmpty()) {
                throw new IllegalArgumentException("ResourceId cannot be null or empty.");
            }
            if (lockOwner == null || lockOwner.isEmpty()) {
                throw new IllegalArgumentException("LockOwner cannot be null or empty.");
            }
            if (expiryInSeconds < 0) {
                throw new IllegalArgumentException("ExpiryInSeconds cannot be negative.");
            }
            DaprProtos.TryLockRequest.Builder builder = DaprProtos.TryLockRequest.newBuilder().setStoreName(stateStoreName).setResourceId(resourceId).setLockOwner(lockOwner).setExpiryInSeconds(expiryInSeconds.intValue());
            DaprProtos.TryLockRequest tryLockRequest = builder.build();
            return Mono.deferContextual(context -> this.createMono(it -> this.intercept((ContextView)context, this.asyncStub).tryLockAlpha1(tryLockRequest, it))).flatMap(response -> {
                try {
                    return Mono.just((Object)response.getSuccess());
                }
                catch (Exception ex) {
                    return DaprException.wrapMono(ex);
                }
            });
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public Mono<UnlockResponseStatus> unlock(UnlockRequest request) {
        try {
            String stateStoreName = request.getStoreName();
            String resourceId = request.getResourceId();
            String lockOwner = request.getLockOwner();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (resourceId == null || resourceId.isEmpty()) {
                throw new IllegalArgumentException("ResourceId cannot be null or empty.");
            }
            if (lockOwner == null || lockOwner.isEmpty()) {
                throw new IllegalArgumentException("LockOwner cannot be null or empty.");
            }
            DaprProtos.UnlockRequest.Builder builder = DaprProtos.UnlockRequest.newBuilder().setStoreName(stateStoreName).setResourceId(resourceId).setLockOwner(lockOwner);
            DaprProtos.UnlockRequest unlockRequest = builder.build();
            return Mono.deferContextual(context -> this.createMono(it -> this.intercept((ContextView)context, this.asyncStub).unlockAlpha1(unlockRequest, it))).flatMap(response -> {
                try {
                    return Mono.just((Object)((Object)UnlockResponseStatus.valueOf(response.getStatus().getNumber())));
                }
                catch (Exception ex) {
                    return DaprException.wrapMono(ex);
                }
            });
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public <T> Mono<QueryStateResponse<T>> queryState(QueryStateRequest request, TypeRef<T> type) {
        try {
            String queryString;
            if (request == null) {
                throw new IllegalArgumentException("Query state request cannot be null.");
            }
            String storeName = request.getStoreName();
            Map<String, String> metadata = request.getMetadata();
            if (storeName == null || storeName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (request.getQuery() != null) {
                queryString = JSON_REQUEST_MAPPER.writeValueAsString((Object)request.getQuery());
            } else if (request.getQueryString() != null) {
                queryString = request.getQueryString();
            } else {
                throw new IllegalArgumentException("Both query and queryString fields are not set.");
            }
            DaprProtos.QueryStateRequest.Builder builder = DaprProtos.QueryStateRequest.newBuilder().setStoreName(storeName).setQuery(queryString);
            if (metadata != null) {
                builder.putAllMetadata(metadata);
            }
            DaprProtos.QueryStateRequest envelope = builder.build();
            return Mono.deferContextual(context -> this.createMono(it -> this.intercept((ContextView)context, this.asyncStub).queryStateAlpha1(envelope, it))).map(it -> {
                Map resultMeta = it.getMetadataMap();
                String token = it.getToken();
                List res = it.getResultsList().stream().map(v -> {
                    try {
                        return this.buildQueryStateKeyValue((DaprProtos.QueryStateItem)v, type);
                    }
                    catch (Exception e) {
                        throw DaprException.propagate(e);
                    }
                }).collect(Collectors.toList());
                return new QueryStateResponse(res, token).setMetadata(metadata);
            });
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    private <T> QueryStateItem<T> buildQueryStateKeyValue(DaprProtos.QueryStateItem item, TypeRef<T> type) throws IOException {
        String key = item.getKey();
        String error = item.getError();
        if (!Strings.isNullOrEmpty((String)error)) {
            return new QueryStateItem(key, null, error);
        }
        ByteString payload = item.getData();
        byte[] data = payload == null ? null : payload.toByteArray();
        T value = this.stateSerializer.deserialize(data, type);
        String etag = item.getEtag();
        if (etag.equals("")) {
            etag = null;
        }
        return new QueryStateItem<T>(key, value, etag);
    }

    @Override
    public void close() throws Exception {
        DaprException.wrap(() -> {
            if (this.channel != null) {
                this.channel.close();
            }
            if (this.httpClient != null) {
                this.httpClient.close();
            }
            return true;
        }).call();
    }

    @Override
    public Mono<Void> shutdown() {
        DaprProtos.ShutdownRequest shutdownRequest = DaprProtos.ShutdownRequest.newBuilder().build();
        return Mono.deferContextual(context -> this.createMono(it -> this.intercept((ContextView)context, this.asyncStub).shutdown(shutdownRequest, it))).then();
    }

    @Override
    public Mono<Map<String, ConfigurationItem>> getConfiguration(GetConfigurationRequest request) {
        try {
            String configurationStoreName = request.getStoreName();
            Map<String, String> metadata = request.getMetadata();
            List<String> keys = request.getKeys();
            if (configurationStoreName == null || configurationStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("Configuration Store Name cannot be null or empty.");
            }
            DaprProtos.GetConfigurationRequest.Builder builder = DaprProtos.GetConfigurationRequest.newBuilder().setStoreName(configurationStoreName).addAllKeys(keys);
            if (metadata != null) {
                builder.putAllMetadata(metadata);
            }
            DaprProtos.GetConfigurationRequest envelope = builder.build();
            return this.getConfiguration(envelope);
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    private Mono<Map<String, ConfigurationItem>> getConfiguration(DaprProtos.GetConfigurationRequest envelope) {
        return Mono.deferContextual(context -> this.createMono(it -> this.intercept((ContextView)context, this.asyncStub).getConfiguration(envelope, it))).map(it -> {
            HashMap<String, ConfigurationItem> configMap = new HashMap<String, ConfigurationItem>();
            for (Map.Entry entry : it.getItems().entrySet()) {
                configMap.put((String)entry.getKey(), this.buildConfigurationItem((CommonProtos.ConfigurationItem)entry.getValue(), (String)entry.getKey()));
            }
            return Collections.unmodifiableMap(configMap);
        });
    }

    @Override
    public Flux<SubscribeConfigurationResponse> subscribeConfiguration(SubscribeConfigurationRequest request) {
        try {
            String configurationStoreName = request.getStoreName();
            List<String> keys = request.getKeys();
            Map<String, String> metadata = request.getMetadata();
            if (configurationStoreName == null || configurationStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("Configuration Store Name can not be null or empty.");
            }
            DaprProtos.SubscribeConfigurationRequest.Builder builder = DaprProtos.SubscribeConfigurationRequest.newBuilder().setStoreName(configurationStoreName).addAllKeys(keys);
            if (metadata != null) {
                builder.putAllMetadata(metadata);
            }
            DaprProtos.SubscribeConfigurationRequest envelope = builder.build();
            return this.createFlux(it -> this.intercept(null, this.asyncStub).subscribeConfiguration(envelope, it)).map(it -> {
                HashMap<String, ConfigurationItem> configMap = new HashMap<String, ConfigurationItem>();
                for (Map.Entry entry : it.getItemsMap().entrySet()) {
                    configMap.put((String)entry.getKey(), this.buildConfigurationItem((CommonProtos.ConfigurationItem)entry.getValue(), (String)entry.getKey()));
                }
                return new SubscribeConfigurationResponse(it.getId(), Collections.unmodifiableMap(configMap));
            });
        }
        catch (Exception ex) {
            return DaprException.wrapFlux(ex);
        }
    }

    @Override
    public Mono<UnsubscribeConfigurationResponse> unsubscribeConfiguration(UnsubscribeConfigurationRequest request) {
        try {
            String configurationStoreName = request.getStoreName();
            String id = request.getSubscriptionId();
            if (configurationStoreName == null || configurationStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("Configuration Store Name can not be null or empty.");
            }
            if (id.isEmpty()) {
                throw new IllegalArgumentException("Subscription id can not be null or empty.");
            }
            DaprProtos.UnsubscribeConfigurationRequest.Builder builder = DaprProtos.UnsubscribeConfigurationRequest.newBuilder().setId(id).setStoreName(configurationStoreName);
            DaprProtos.UnsubscribeConfigurationRequest envelope = builder.build();
            return this.createMono(it -> this.intercept(null, this.asyncStub).unsubscribeConfiguration(envelope, it)).map(it -> new UnsubscribeConfigurationResponse(it.getOk(), it.getMessage()));
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    private ConfigurationItem buildConfigurationItem(CommonProtos.ConfigurationItem configurationItem, String key) {
        return new ConfigurationItem(key, configurationItem.getValue(), configurationItem.getVersion(), configurationItem.getMetadataMap());
    }

    private DaprGrpc.DaprStub intercept(ContextView context, DaprGrpc.DaprStub client) {
        return DaprClientGrpcInterceptors.intercept(client, this.timeoutPolicy, context);
    }

    private <T> Mono<T> createMono(Consumer<StreamObserver<T>> consumer) {
        return this.retryPolicy.apply(Mono.create(sink -> DaprException.wrap(() -> consumer.accept(this.createStreamObserver((MonoSink)sink))).run()));
    }

    private <T> Flux<T> createFlux(Consumer<StreamObserver<T>> consumer) {
        return this.retryPolicy.apply(Flux.create(sink -> DaprException.wrap(() -> consumer.accept(this.createStreamObserver((FluxSink)sink))).run()));
    }

    private <T> StreamObserver<T> createStreamObserver(final MonoSink<T> sink) {
        return new StreamObserver<T>(){

            public void onNext(T value) {
                sink.success(value);
            }

            public void onError(Throwable t) {
                sink.error((Throwable)DaprException.propagate(new ExecutionException(t)));
            }

            public void onCompleted() {
                sink.success();
            }
        };
    }

    private <T> StreamObserver<T> createStreamObserver(final FluxSink<T> sink) {
        return new StreamObserver<T>(){

            public void onNext(T value) {
                sink.next(value);
            }

            public void onError(Throwable t) {
                sink.error((Throwable)DaprException.propagate(new ExecutionException(t)));
            }

            public void onCompleted() {
                sink.complete();
            }
        };
    }

    @Override
    public Mono<DaprMetadata> getMetadata() {
        DaprProtos.GetMetadataRequest metadataRequest = DaprProtos.GetMetadataRequest.newBuilder().build();
        return Mono.deferContextual(context -> this.createMono(it -> this.intercept((ContextView)context, this.asyncStub).getMetadata(metadataRequest, it))).map(it -> {
            try {
                return this.buildDaprMetadata((DaprProtos.GetMetadataResponse)it);
            }
            catch (IOException ex) {
                throw DaprException.propagate(ex);
            }
        });
    }

    private DaprMetadata buildDaprMetadata(DaprProtos.GetMetadataResponse response) throws IOException {
        String id = response.getId();
        String runtimeVersion = response.getRuntimeVersion();
        ProtocolStringList enabledFeatures = response.getEnabledFeaturesList();
        List<ActorMetadata> actors = this.getActors(response);
        Map attributes = response.getExtendedMetadataMap();
        List<ComponentMetadata> components = this.getComponents(response);
        List<HttpEndpointMetadata> httpEndpoints = this.getHttpEndpoints(response);
        List<SubscriptionMetadata> subscriptions = this.getSubscriptions(response);
        AppConnectionPropertiesMetadata appConnectionProperties = this.getAppConnectionProperties(response);
        return new DaprMetadata(id, runtimeVersion, (List<String>)enabledFeatures, actors, attributes, components, httpEndpoints, subscriptions, appConnectionProperties);
    }

    private List<ActorMetadata> getActors(DaprProtos.GetMetadataResponse response) {
        DaprProtos.ActorRuntime actorRuntime = response.getActorRuntime();
        List activeActorsList = actorRuntime.getActiveActorsList();
        ArrayList<ActorMetadata> actors = new ArrayList<ActorMetadata>();
        for (DaprProtos.ActiveActorsCount aac : activeActorsList) {
            actors.add(new ActorMetadata(aac.getType(), aac.getCount()));
        }
        return actors;
    }

    private List<ComponentMetadata> getComponents(DaprProtos.GetMetadataResponse response) {
        List registeredComponentsList = response.getRegisteredComponentsList();
        ArrayList<ComponentMetadata> components = new ArrayList<ComponentMetadata>();
        for (DaprProtos.RegisteredComponents rc : registeredComponentsList) {
            components.add(new ComponentMetadata(rc.getName(), rc.getType(), rc.getVersion(), (List<String>)rc.getCapabilitiesList()));
        }
        return components;
    }

    private List<SubscriptionMetadata> getSubscriptions(DaprProtos.GetMetadataResponse response) {
        List subscriptionsList = response.getSubscriptionsList();
        ArrayList<SubscriptionMetadata> subscriptions = new ArrayList<SubscriptionMetadata>();
        for (DaprProtos.PubsubSubscription s : subscriptionsList) {
            List rulesList = s.getRules().getRulesList();
            ArrayList<RuleMetadata> rules = new ArrayList<RuleMetadata>();
            for (DaprProtos.PubsubSubscriptionRule r : rulesList) {
                rules.add(new RuleMetadata(r.getMatch(), r.getPath()));
            }
            subscriptions.add(new SubscriptionMetadata(s.getPubsubName(), s.getTopic(), s.getMetadataMap(), rules, s.getDeadLetterTopic()));
        }
        return subscriptions;
    }

    private List<HttpEndpointMetadata> getHttpEndpoints(DaprProtos.GetMetadataResponse response) {
        List httpEndpointsList = response.getHttpEndpointsList();
        ArrayList<HttpEndpointMetadata> httpEndpoints = new ArrayList<HttpEndpointMetadata>();
        for (DaprProtos.MetadataHTTPEndpoint m : httpEndpointsList) {
            httpEndpoints.add(new HttpEndpointMetadata(m.getName()));
        }
        return httpEndpoints;
    }

    private AppConnectionPropertiesMetadata getAppConnectionProperties(DaprProtos.GetMetadataResponse response) {
        DaprProtos.AppConnectionProperties appConnectionProperties = response.getAppConnectionProperties();
        int port = appConnectionProperties.getPort();
        String protocol = appConnectionProperties.getProtocol();
        String channelAddress = appConnectionProperties.getChannelAddress();
        int maxConcurrency = appConnectionProperties.getMaxConcurrency();
        AppConnectionPropertiesHealthMetadata health = this.getAppConnectionPropertiesHealth(appConnectionProperties);
        return new AppConnectionPropertiesMetadata(port, protocol, channelAddress, maxConcurrency, health);
    }

    private AppConnectionPropertiesHealthMetadata getAppConnectionPropertiesHealth(DaprProtos.AppConnectionProperties appConnectionProperties) {
        if (!appConnectionProperties.hasHealth()) {
            return null;
        }
        DaprProtos.AppConnectionHealthProperties health = appConnectionProperties.getHealth();
        String healthCheckPath = health.getHealthCheckPath();
        String healthProbeInterval = health.getHealthProbeInterval();
        String healthProbeTimeout = health.getHealthProbeTimeout();
        int healthThreshold = health.getHealthThreshold();
        return new AppConnectionPropertiesHealthMetadata(healthCheckPath, healthProbeInterval, healthProbeTimeout, healthThreshold);
    }
}

