/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import io.dapr.client.DaprHttp;
import io.dapr.config.Properties;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;

public class DaprHttpBuilder {
    private static volatile OkHttpClient OK_HTTP_CLIENT;
    private static final Object LOCK;
    private static final int KEEP_ALIVE_DURATION = 30;

    public DaprHttp build() {
        return this.buildDaprHttp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DaprHttp buildDaprHttp() {
        String endpoint;
        if (OK_HTTP_CLIENT == null) {
            Object object = LOCK;
            synchronized (object) {
                if (OK_HTTP_CLIENT == null) {
                    OkHttpClient.Builder builder = new OkHttpClient.Builder();
                    Duration readTimeout = Duration.ofSeconds(Properties.HTTP_CLIENT_READ_TIMEOUT_SECONDS.get().intValue());
                    builder.readTimeout(readTimeout);
                    Dispatcher dispatcher = new Dispatcher();
                    dispatcher.setMaxRequests(Properties.HTTP_CLIENT_MAX_REQUESTS.get().intValue());
                    dispatcher.setMaxRequestsPerHost(Properties.HTTP_CLIENT_MAX_REQUESTS.get().intValue());
                    builder.dispatcher(dispatcher);
                    ConnectionPool pool = new ConnectionPool(Properties.HTTP_CLIENT_MAX_IDLE_CONNECTIONS.get().intValue(), 30L, TimeUnit.SECONDS);
                    builder.connectionPool(pool);
                    OK_HTTP_CLIENT = builder.build();
                }
            }
        }
        if ((endpoint = Properties.HTTP_ENDPOINT.get()) != null && !endpoint.isEmpty()) {
            return new DaprHttp(endpoint, OK_HTTP_CLIENT);
        }
        return new DaprHttp(Properties.SIDECAR_IP.get(), Properties.HTTP_PORT.get(), OK_HTTP_CLIENT);
    }

    static {
        LOCK = new Object();
    }
}

