/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.internal.grpc;

import io.dapr.internal.grpc.interceptors.DaprApiTokenInterceptor;
import io.dapr.internal.grpc.interceptors.DaprAppIdInterceptor;
import io.dapr.internal.grpc.interceptors.DaprTimeoutInterceptor;
import io.dapr.internal.grpc.interceptors.DaprTracingInterceptor;
import io.dapr.internal.resiliency.TimeoutPolicy;
import io.grpc.ClientInterceptor;
import io.grpc.stub.AbstractStub;
import reactor.util.context.ContextView;

public class DaprClientGrpcInterceptors {
    public static <T extends AbstractStub<T>> T intercept(String appId, T client) {
        return DaprClientGrpcInterceptors.intercept(appId, client, null, null);
    }

    public static <T extends AbstractStub<T>> T intercept(T client) {
        return DaprClientGrpcInterceptors.intercept(null, client, null, null);
    }

    public static <T extends AbstractStub<T>> T intercept(String appId, T client, TimeoutPolicy timeoutPolicy) {
        return DaprClientGrpcInterceptors.intercept(appId, client, timeoutPolicy, null);
    }

    public static <T extends AbstractStub<T>> T intercept(T client, TimeoutPolicy timeoutPolicy) {
        return DaprClientGrpcInterceptors.intercept(null, client, timeoutPolicy, null);
    }

    public static <T extends AbstractStub<T>> T intercept(String appId, T client, ContextView context) {
        return DaprClientGrpcInterceptors.intercept(appId, client, null, context);
    }

    public static <T extends AbstractStub<T>> T intercept(T client, ContextView context) {
        return DaprClientGrpcInterceptors.intercept(null, client, null, context);
    }

    public static <T extends AbstractStub<T>> T intercept(T client, TimeoutPolicy timeoutPolicy, ContextView context) {
        return DaprClientGrpcInterceptors.intercept(null, client, timeoutPolicy, context);
    }

    public static <T extends AbstractStub<T>> T intercept(String appId, T client, TimeoutPolicy timeoutPolicy, ContextView context) {
        if (client == null) {
            throw new IllegalArgumentException("client cannot be null");
        }
        return (T)client.withInterceptors(new ClientInterceptor[]{new DaprAppIdInterceptor(appId), new DaprApiTokenInterceptor(), new DaprTimeoutInterceptor(timeoutPolicy), new DaprTracingInterceptor(context)});
    }
}

