/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.internal.exceptions;

import io.grpc.Metadata;
import java.util.concurrent.ExecutionException;

public class DaprHttpException
extends ExecutionException {
    private static final Metadata.Key<String> GRPC_METADATA_KEY_HTTP_STATUS_CODE = Metadata.Key.of((String)"metadata.statuscode", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final int statusCode;
    private final byte[] payload;

    private DaprHttpException(int statusCode, Throwable cause) {
        super(cause);
        this.statusCode = statusCode;
        this.payload = null;
    }

    public DaprHttpException(int statusCode, byte[] payload) {
        this.statusCode = statusCode;
        this.payload = payload;
    }

    public static ExecutionException fromGrpcExecutionException(Metadata grpcMetadata, Throwable cause) {
        int httpStatusCode = DaprHttpException.parseHttpStatusCode(grpcMetadata);
        if (!DaprHttpException.isValidHttpStatusCode(httpStatusCode)) {
            return new ExecutionException(cause);
        }
        return new DaprHttpException(httpStatusCode, cause);
    }

    public static boolean isValidHttpStatusCode(int statusCode) {
        return statusCode >= 100 && statusCode <= 599;
    }

    public static boolean isSuccessfulHttpStatusCode(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    private static int parseHttpStatusCode(Metadata grpcMetadata) {
        if (grpcMetadata == null) {
            return 0;
        }
        return DaprHttpException.parseHttpStatusCode((String)grpcMetadata.get(GRPC_METADATA_KEY_HTTP_STATUS_CODE));
    }

    public static int parseHttpStatusCode(String value) {
        if (value == null || value.isEmpty()) {
            return 0;
        }
        try {
            int httpStatusCode = Integer.parseInt(value);
            if (!DaprHttpException.isValidHttpStatusCode(httpStatusCode)) {
                return 0;
            }
            return httpStatusCode;
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public byte[] getPayload() {
        return this.payload;
    }
}

