/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.internal.grpc;

import io.dapr.internal.grpc.interceptors.DaprApiTokenInterceptor;
import io.dapr.internal.grpc.interceptors.DaprAppIdInterceptor;
import io.dapr.internal.grpc.interceptors.DaprMetadataReceiverInterceptor;
import io.dapr.internal.grpc.interceptors.DaprTimeoutInterceptor;
import io.dapr.internal.grpc.interceptors.DaprTracingInterceptor;
import io.dapr.internal.resiliency.TimeoutPolicy;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.stub.AbstractStub;
import java.util.function.Consumer;
import reactor.util.context.ContextView;

public class DaprClientGrpcInterceptors {
    private final String daprApiToken;
    private final TimeoutPolicy timeoutPolicy;

    public DaprClientGrpcInterceptors() {
        this(null, null);
    }

    public DaprClientGrpcInterceptors(String daprApiToken, TimeoutPolicy timeoutPolicy) {
        this.daprApiToken = daprApiToken;
        this.timeoutPolicy = timeoutPolicy;
    }

    public <T extends AbstractStub<T>> T intercept(T client) {
        return this.intercept(null, client, null, null);
    }

    public <T extends AbstractStub<T>> T intercept(String appId, T client) {
        return this.intercept(appId, client, null, null);
    }

    public <T extends AbstractStub<T>> T intercept(T client, ContextView context) {
        return this.intercept(null, client, context, null);
    }

    public <T extends AbstractStub<T>> T intercept(T client, ContextView context, Consumer<Metadata> metadataConsumer) {
        return this.intercept(null, client, context, metadataConsumer);
    }

    public <T extends AbstractStub<T>> T intercept(String appId, T client, ContextView context, Consumer<Metadata> metadataConsumer) {
        if (client == null) {
            throw new IllegalArgumentException("client cannot be null");
        }
        return (T)client.withInterceptors(new ClientInterceptor[]{new DaprAppIdInterceptor(appId), new DaprApiTokenInterceptor(this.daprApiToken), new DaprTimeoutInterceptor(this.timeoutPolicy), new DaprTracingInterceptor(context), new DaprMetadataReceiverInterceptor(metadataConsumer)});
    }
}

