/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.utils;

import io.dapr.serializer.DefaultObjectSerializer;
import io.dapr.utils.TypeRef;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class DefaultContentTypeConverter {
    private static final DefaultObjectSerializer OBJECT_SERIALIZER = new DefaultObjectSerializer();

    public static <T> byte[] convertEventToBytesForHttp(T event, String contentType) throws IllegalArgumentException, IOException {
        if (DefaultContentTypeConverter.isBinaryContentType(contentType)) {
            if (event instanceof byte[]) {
                return Base64.getEncoder().encode((byte[])event);
            }
            throw new IllegalArgumentException("mismatch between 'application/octect-stream' contentType and event. expected binary data as bytes array");
        }
        if (DefaultContentTypeConverter.isStringContentType(contentType)) {
            if (event instanceof String) {
                return ((String)event).getBytes(StandardCharsets.UTF_8);
            }
            if (event instanceof Boolean || event instanceof Number) {
                return String.valueOf(event).getBytes(StandardCharsets.UTF_8);
            }
            throw new IllegalArgumentException("mismatch between string contentType and event. expected event to be convertible into a string");
        }
        if (DefaultContentTypeConverter.isJsonContentType(contentType) || DefaultContentTypeConverter.isCloudEventContentType(contentType)) {
            return OBJECT_SERIALIZER.serialize(event);
        }
        throw new IllegalArgumentException("mismatch between contentType and event");
    }

    public static <T> byte[] convertEventToBytesForGrpc(T event, String contentType) throws IllegalArgumentException, IOException {
        if (DefaultContentTypeConverter.isBinaryContentType(contentType)) {
            if (event instanceof byte[]) {
                return (byte[])event;
            }
            throw new IllegalArgumentException("mismatch between 'application/octect-stream' contentType and event. expected binary data as bytes array");
        }
        return DefaultContentTypeConverter.convertEventToBytesForHttp(event, contentType);
    }

    public static <T> T convertBytesToEventFromHttp(byte[] event, String contentType, TypeRef<T> typeRef) throws IllegalArgumentException, IOException {
        if (DefaultContentTypeConverter.isBinaryContentType(contentType)) {
            byte[] decoded = Base64.getDecoder().decode(new String(event, StandardCharsets.UTF_8));
            return OBJECT_SERIALIZER.deserialize(decoded, typeRef);
        }
        if (DefaultContentTypeConverter.isStringContentType(contentType)) {
            if (TypeRef.STRING.equals(typeRef)) {
                return (T)new String(event, StandardCharsets.UTF_8);
            }
            if (TypeRef.isPrimitive(typeRef)) {
                return OBJECT_SERIALIZER.deserialize(event, typeRef);
            }
        } else if (DefaultContentTypeConverter.isJsonContentType(contentType) || DefaultContentTypeConverter.isCloudEventContentType(contentType)) {
            return OBJECT_SERIALIZER.deserialize(event, typeRef);
        }
        throw new IllegalArgumentException("mismatch between contentType and requested type cast in return");
    }

    public static <T> T convertBytesToEventFromGrpc(byte[] event, String contentType, TypeRef<T> typeRef) throws IllegalArgumentException, IOException {
        if (DefaultContentTypeConverter.isBinaryContentType(contentType)) {
            return OBJECT_SERIALIZER.deserialize(event, typeRef);
        }
        return DefaultContentTypeConverter.convertBytesToEventFromHttp(event, contentType, typeRef);
    }

    public static boolean isCloudEventContentType(String contentType) {
        return DefaultContentTypeConverter.isContentType(contentType, "application/cloudevents+json");
    }

    public static boolean isJsonContentType(String contentType) {
        return DefaultContentTypeConverter.isContentType(contentType, "application/json");
    }

    public static boolean isStringContentType(String contentType) {
        return contentType != null && (contentType.toLowerCase().startsWith("text/") || DefaultContentTypeConverter.isContentType(contentType, "application/xml"));
    }

    public static boolean isBinaryContentType(String contentType) {
        return DefaultContentTypeConverter.isContentType(contentType, "application/octet-stream");
    }

    private static boolean isContentType(String contentType, String expected) {
        if (contentType == null) {
            return false;
        }
        if (contentType.equalsIgnoreCase(expected)) {
            return true;
        }
        int semiColonPos = contentType.indexOf(";");
        if (semiColonPos > 0) {
            return contentType.substring(0, semiColonPos).equalsIgnoreCase(expected);
        }
        return false;
    }
}

