/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dapr.client.DaprClient;
import io.dapr.client.DaprPreviewClient;
import io.dapr.client.domain.BulkPublishEntry;
import io.dapr.client.domain.BulkPublishRequest;
import io.dapr.client.domain.BulkPublishResponse;
import io.dapr.client.domain.ConfigurationItem;
import io.dapr.client.domain.DeleteStateRequest;
import io.dapr.client.domain.ExecuteStateTransactionRequest;
import io.dapr.client.domain.GetBulkSecretRequest;
import io.dapr.client.domain.GetBulkStateRequest;
import io.dapr.client.domain.GetConfigurationRequest;
import io.dapr.client.domain.GetSecretRequest;
import io.dapr.client.domain.GetStateRequest;
import io.dapr.client.domain.HttpExtension;
import io.dapr.client.domain.InvokeBindingRequest;
import io.dapr.client.domain.InvokeMethodRequest;
import io.dapr.client.domain.LockRequest;
import io.dapr.client.domain.PublishEventRequest;
import io.dapr.client.domain.QueryStateRequest;
import io.dapr.client.domain.QueryStateResponse;
import io.dapr.client.domain.SaveStateRequest;
import io.dapr.client.domain.State;
import io.dapr.client.domain.StateOptions;
import io.dapr.client.domain.SubscribeConfigurationRequest;
import io.dapr.client.domain.SubscribeConfigurationResponse;
import io.dapr.client.domain.TransactionalStateOperation;
import io.dapr.client.domain.UnlockRequest;
import io.dapr.client.domain.UnlockResponseStatus;
import io.dapr.client.domain.UnsubscribeConfigurationRequest;
import io.dapr.client.domain.UnsubscribeConfigurationResponse;
import io.dapr.client.domain.query.Query;
import io.dapr.serializer.DaprObjectSerializer;
import io.dapr.utils.TypeRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class AbstractDaprClient
implements DaprClient,
DaprPreviewClient {
    protected static final ObjectMapper JSON_REQUEST_MAPPER = new ObjectMapper();
    protected DaprObjectSerializer objectSerializer;
    protected DaprObjectSerializer stateSerializer;

    AbstractDaprClient(DaprObjectSerializer objectSerializer, DaprObjectSerializer stateSerializer) {
        this.objectSerializer = objectSerializer;
        this.stateSerializer = stateSerializer;
    }

    @Override
    public Mono<Void> publishEvent(String pubsubName, String topicName, Object data) {
        return this.publishEvent(pubsubName, topicName, data, null);
    }

    @Override
    public Mono<Void> publishEvent(String pubsubName, String topicName, Object data, Map<String, String> metadata) {
        PublishEventRequest req = new PublishEventRequest(pubsubName, topicName, data).setMetadata(metadata);
        return this.publishEvent(req).then();
    }

    @Override
    public <T> Mono<T> invokeMethod(String appId, String methodName, Object data, HttpExtension httpExtension, Map<String, String> metadata, TypeRef<T> type) {
        InvokeMethodRequest req = new InvokeMethodRequest(appId, methodName).setBody(data).setHttpExtension(httpExtension).setContentType(this.objectSerializer.getContentType()).setMetadata(metadata);
        return this.invokeMethod(req, type);
    }

    @Override
    public <T> Mono<T> invokeMethod(String appId, String methodName, Object request, HttpExtension httpExtension, Map<String, String> metadata, Class<T> clazz) {
        return this.invokeMethod(appId, methodName, request, httpExtension, metadata, TypeRef.get(clazz));
    }

    @Override
    public <T> Mono<T> invokeMethod(String appId, String methodName, HttpExtension httpExtension, Map<String, String> metadata, TypeRef<T> type) {
        return this.invokeMethod(appId, methodName, null, httpExtension, metadata, type);
    }

    @Override
    public <T> Mono<T> invokeMethod(String appId, String methodName, HttpExtension httpExtension, Map<String, String> metadata, Class<T> clazz) {
        return this.invokeMethod(appId, methodName, null, httpExtension, metadata, TypeRef.get(clazz));
    }

    @Override
    public <T> Mono<T> invokeMethod(String appId, String methodName, Object request, HttpExtension httpExtension, TypeRef<T> type) {
        return this.invokeMethod(appId, methodName, request, httpExtension, null, type);
    }

    @Override
    public <T> Mono<T> invokeMethod(String appId, String methodName, Object request, HttpExtension httpExtension, Class<T> clazz) {
        return this.invokeMethod(appId, methodName, request, httpExtension, null, TypeRef.get(clazz));
    }

    @Override
    public Mono<Void> invokeMethod(String appId, String methodName, Object request, HttpExtension httpExtension) {
        return this.invokeMethod(appId, methodName, request, httpExtension, null, TypeRef.BYTE_ARRAY).then();
    }

    @Override
    public Mono<Void> invokeMethod(String appId, String methodName, Object request, HttpExtension httpExtension, Map<String, String> metadata) {
        return this.invokeMethod(appId, methodName, request, httpExtension, metadata, TypeRef.BYTE_ARRAY).then();
    }

    @Override
    public Mono<Void> invokeMethod(String appId, String methodName, HttpExtension httpExtension, Map<String, String> metadata) {
        return this.invokeMethod(appId, methodName, null, httpExtension, metadata, TypeRef.BYTE_ARRAY).then();
    }

    @Override
    public Mono<byte[]> invokeMethod(String appId, String methodName, byte[] request, HttpExtension httpExtension, Map<String, String> metadata) {
        return this.invokeMethod(appId, methodName, (Object)request, httpExtension, metadata, TypeRef.BYTE_ARRAY);
    }

    @Override
    public Mono<Void> invokeBinding(String bindingName, String operation, Object data) {
        return this.invokeBinding(bindingName, operation, data, null, TypeRef.BYTE_ARRAY).then();
    }

    @Override
    public Mono<byte[]> invokeBinding(String bindingName, String operation, byte[] data, Map<String, String> metadata) {
        return this.invokeBinding(bindingName, operation, (Object)data, metadata, TypeRef.BYTE_ARRAY);
    }

    @Override
    public <T> Mono<T> invokeBinding(String bindingName, String operation, Object data, TypeRef<T> type) {
        return this.invokeBinding(bindingName, operation, data, null, type);
    }

    @Override
    public <T> Mono<T> invokeBinding(String bindingName, String operation, Object data, Class<T> clazz) {
        return this.invokeBinding(bindingName, operation, data, null, TypeRef.get(clazz));
    }

    @Override
    public <T> Mono<T> invokeBinding(String bindingName, String operation, Object data, Map<String, String> metadata, TypeRef<T> type) {
        InvokeBindingRequest request = new InvokeBindingRequest(bindingName, operation).setData(data).setMetadata(metadata);
        return this.invokeBinding(request, type);
    }

    @Override
    public <T> Mono<T> invokeBinding(String bindingName, String operation, Object data, Map<String, String> metadata, Class<T> clazz) {
        return this.invokeBinding(bindingName, operation, data, metadata, TypeRef.get(clazz));
    }

    @Override
    public Mono<Void> invokeBinding(InvokeBindingRequest request) {
        return this.invokeBinding(request, TypeRef.VOID);
    }

    @Override
    public <T> Mono<State<T>> getState(String storeName, State<T> state, TypeRef<T> type) {
        return this.getState(storeName, state.getKey(), state.getOptions(), type);
    }

    @Override
    public <T> Mono<State<T>> getState(String storeName, State<T> state, Class<T> clazz) {
        return this.getState(storeName, state.getKey(), state.getOptions(), TypeRef.get(clazz));
    }

    @Override
    public <T> Mono<State<T>> getState(String storeName, String key, TypeRef<T> type) {
        return this.getState(storeName, key, null, type);
    }

    @Override
    public <T> Mono<State<T>> getState(String storeName, String key, Class<T> clazz) {
        return this.getState(storeName, key, null, TypeRef.get(clazz));
    }

    @Override
    public <T> Mono<State<T>> getState(String storeName, String key, StateOptions options, TypeRef<T> type) {
        GetStateRequest request = new GetStateRequest(storeName, key).setStateOptions(options);
        return this.getState(request, type);
    }

    @Override
    public <T> Mono<State<T>> getState(String storeName, String key, StateOptions options, Class<T> clazz) {
        return this.getState(storeName, key, options, TypeRef.get(clazz));
    }

    @Override
    public <T> Mono<QueryStateResponse<T>> queryState(String storeName, String query, Map<String, String> metadata, Class<T> clazz) {
        return this.queryState(new QueryStateRequest(storeName).setQueryString(query).setMetadata(metadata), clazz);
    }

    @Override
    public <T> Mono<QueryStateResponse<T>> queryState(String storeName, String query, Map<String, String> metadata, TypeRef<T> type) {
        return this.queryState(new QueryStateRequest(storeName).setQueryString(query).setMetadata(metadata), type);
    }

    @Override
    public <T> Mono<QueryStateResponse<T>> queryState(String storeName, String query, Class<T> clazz) {
        return this.queryState(new QueryStateRequest(storeName).setQueryString(query), clazz);
    }

    @Override
    public <T> Mono<QueryStateResponse<T>> queryState(String storeName, String query, TypeRef<T> type) {
        return this.queryState(new QueryStateRequest(storeName).setQueryString(query), type);
    }

    @Override
    public <T> Mono<QueryStateResponse<T>> queryState(String storeName, Query query, Map<String, String> metadata, Class<T> clazz) {
        return this.queryState(new QueryStateRequest(storeName).setQuery(query).setMetadata(metadata), clazz);
    }

    @Override
    public <T> Mono<QueryStateResponse<T>> queryState(String storeName, Query query, Map<String, String> metadata, TypeRef<T> type) {
        return this.queryState(new QueryStateRequest(storeName).setQuery(query).setMetadata(metadata), type);
    }

    @Override
    public <T> Mono<QueryStateResponse<T>> queryState(String storeName, Query query, Class<T> clazz) {
        return this.queryState(new QueryStateRequest(storeName).setQuery(query), clazz);
    }

    @Override
    public <T> Mono<QueryStateResponse<T>> queryState(String storeName, Query query, TypeRef<T> type) {
        return this.queryState(new QueryStateRequest(storeName).setQuery(query), type);
    }

    @Override
    public <T> Mono<QueryStateResponse<T>> queryState(QueryStateRequest request, Class<T> clazz) {
        return this.queryState(request, TypeRef.get(clazz));
    }

    @Override
    public <T> Mono<BulkPublishResponse<T>> publishEvents(String pubsubName, String topicName, String contentType, List<T> events) {
        return this.publishEvents(pubsubName, topicName, contentType, (Map<String, String>)null, events);
    }

    @Override
    public <T> Mono<BulkPublishResponse<T>> publishEvents(String pubsubName, String topicName, String contentType, T ... events) {
        return this.publishEvents(pubsubName, topicName, contentType, null, events);
    }

    @Override
    public <T> Mono<BulkPublishResponse<T>> publishEvents(String pubsubName, String topicName, String contentType, Map<String, String> requestMetadata, T ... events) {
        return this.publishEvents(pubsubName, topicName, contentType, requestMetadata, Arrays.asList(events));
    }

    @Override
    public <T> Mono<BulkPublishResponse<T>> publishEvents(String pubsubName, String topicName, String contentType, Map<String, String> requestMetadata, List<T> events) {
        if (events == null || events.size() == 0) {
            throw new IllegalArgumentException("list of events cannot be null or empty");
        }
        ArrayList entries = new ArrayList();
        for (int i = 0; i < events.size(); ++i) {
            entries.add(new BulkPublishEntry<T>("" + i, events.get(i), contentType, null));
        }
        return this.publishEvents(new BulkPublishRequest(pubsubName, topicName, entries, requestMetadata));
    }

    @Override
    public <T> Mono<List<State<T>>> getBulkState(String storeName, List<String> keys, TypeRef<T> type) {
        return this.getBulkState(new GetBulkStateRequest(storeName, keys), type);
    }

    @Override
    public <T> Mono<List<State<T>>> getBulkState(String storeName, List<String> keys, Class<T> clazz) {
        return this.getBulkState(storeName, keys, TypeRef.get(clazz));
    }

    @Override
    public Mono<Void> executeStateTransaction(String storeName, List<TransactionalStateOperation<?>> operations) {
        ExecuteStateTransactionRequest request = new ExecuteStateTransactionRequest(storeName).setOperations(operations);
        return this.executeStateTransaction(request).then();
    }

    @Override
    public Mono<Void> saveBulkState(String storeName, List<State<?>> states) {
        SaveStateRequest request = new SaveStateRequest(storeName).setStates(states);
        return this.saveBulkState(request).then();
    }

    @Override
    public Mono<Void> saveState(String storeName, String key, Object value) {
        return this.saveState(storeName, key, null, value, null);
    }

    @Override
    public Mono<Void> saveState(String storeName, String key, String etag, Object value, StateOptions options) {
        Map<String, String> meta = null;
        if (value != null) {
            meta = Collections.singletonMap("contentType", this.stateSerializer.getContentType());
        }
        State<Object> state = new State<Object>(key, value, etag, meta, options);
        return this.saveBulkState(storeName, Collections.singletonList(state));
    }

    @Override
    public Mono<Void> deleteState(String storeName, String key) {
        return this.deleteState(storeName, key, null, null);
    }

    @Override
    public Mono<Void> deleteState(String storeName, String key, String etag, StateOptions options) {
        DeleteStateRequest request = new DeleteStateRequest(storeName, key).setEtag(etag).setStateOptions(options);
        return this.deleteState(request).then();
    }

    @Override
    public Mono<Map<String, String>> getSecret(String storeName, String key, Map<String, String> metadata) {
        GetSecretRequest request = new GetSecretRequest(storeName, key).setMetadata(metadata);
        return this.getSecret(request).defaultIfEmpty(Collections.emptyMap());
    }

    @Override
    public Mono<Map<String, String>> getSecret(String storeName, String secretName) {
        return this.getSecret(storeName, secretName, null);
    }

    @Override
    public Mono<Map<String, Map<String, String>>> getBulkSecret(String storeName) {
        return this.getBulkSecret(storeName, null);
    }

    @Override
    public Mono<Map<String, Map<String, String>>> getBulkSecret(String storeName, Map<String, String> metadata) {
        GetBulkSecretRequest request = new GetBulkSecretRequest(storeName).setMetadata(metadata);
        return this.getBulkSecret(request).defaultIfEmpty(Collections.emptyMap());
    }

    @Override
    public Mono<ConfigurationItem> getConfiguration(String storeName, String key) {
        GetConfigurationRequest request = new GetConfigurationRequest(storeName, this.filterEmptyKeys(key));
        return this.getConfiguration(request).map(data -> (ConfigurationItem)data.get(key));
    }

    @Override
    public Mono<ConfigurationItem> getConfiguration(String storeName, String key, Map<String, String> metadata) {
        GetConfigurationRequest request = new GetConfigurationRequest(storeName, this.filterEmptyKeys(key));
        request.setMetadata(metadata);
        return this.getConfiguration(request).map(data -> (ConfigurationItem)data.get(key));
    }

    @Override
    public Mono<Map<String, ConfigurationItem>> getConfiguration(String storeName, String ... keys) {
        List<String> listOfKeys = this.filterEmptyKeys(keys);
        GetConfigurationRequest request = new GetConfigurationRequest(storeName, listOfKeys);
        return this.getConfiguration(request);
    }

    @Override
    public Mono<Map<String, ConfigurationItem>> getConfiguration(String storeName, List<String> keys, Map<String, String> metadata) {
        GetConfigurationRequest request = new GetConfigurationRequest(storeName, keys);
        request.setMetadata(metadata);
        return this.getConfiguration(request);
    }

    @Override
    public Flux<SubscribeConfigurationResponse> subscribeConfiguration(String storeName, String ... keys) {
        List<String> listOfKeys = this.filterEmptyKeys(keys);
        SubscribeConfigurationRequest request = new SubscribeConfigurationRequest(storeName, listOfKeys);
        return this.subscribeConfiguration(request);
    }

    @Override
    public Flux<SubscribeConfigurationResponse> subscribeConfiguration(String storeName, List<String> keys, Map<String, String> metadata) {
        SubscribeConfigurationRequest request = new SubscribeConfigurationRequest(storeName, keys);
        request.setMetadata(metadata);
        return this.subscribeConfiguration(request);
    }

    @Override
    public Mono<UnsubscribeConfigurationResponse> unsubscribeConfiguration(String id, String storeName) {
        UnsubscribeConfigurationRequest request = new UnsubscribeConfigurationRequest(id, storeName);
        return this.unsubscribeConfiguration(request);
    }

    @Override
    public Mono<Boolean> tryLock(String storeName, String resourceId, String lockOwner, Integer expiryInSeconds) {
        LockRequest lockRequest = new LockRequest(storeName, resourceId, lockOwner, expiryInSeconds);
        return this.tryLock(lockRequest);
    }

    @Override
    public Mono<UnlockResponseStatus> unlock(String storeName, String resourceId, String lockOwner) {
        UnlockRequest request = new UnlockRequest(storeName, resourceId, lockOwner);
        return this.unlock(request);
    }

    private List<String> filterEmptyKeys(String ... keys) {
        return Arrays.stream(keys).filter(key -> !key.trim().isEmpty()).collect(Collectors.toList());
    }
}

