/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client.domain.query.filters;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import io.dapr.client.domain.query.filters.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class AndFilter
extends Filter<Void> {
    @JsonIgnore
    private final List<Filter<?>> and;

    public AndFilter() {
        super("AND");
        this.and = new ArrayList();
    }

    @JsonCreator
    AndFilter(Filter<?>[] filters) {
        super("AND");
        this.and = Arrays.asList(filters);
    }

    public <V extends Filter<?>> AndFilter addClause(V filter) {
        this.and.add(filter);
        return this;
    }

    @JsonValue
    public Filter<?>[] getClauses() {
        return this.and.toArray(new Filter[0]);
    }

    @Override
    @JsonIgnore
    public String getRepresentation() {
        return this.and.stream().map(Filter::getRepresentation).collect(Collectors.joining(" AND "));
    }

    @Override
    public Boolean isValid() {
        boolean validAnd;
        boolean bl = validAnd = this.and != null && this.and.size() >= 2;
        if (validAnd) {
            for (Filter<?> filter : this.and) {
                if (filter.isValid().booleanValue()) continue;
                return false;
            }
        }
        return validAnd;
    }
}

