/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.internal.grpc.interceptors;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

public class DaprAppIdInterceptor
implements ClientInterceptor {
    private final Metadata extraHeaders;

    public DaprAppIdInterceptor(String appId) {
        this.extraHeaders = DaprAppIdInterceptor.buildMetadata(appId);
    }

    private static final Metadata buildMetadata(String appId) {
        if (appId == null) {
            return null;
        }
        Metadata headers = new Metadata();
        headers.put(Metadata.Key.of((String)"dapr-app-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)appId);
        return headers;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions options, Channel channel) {
        ClientCall clientCall = channel.newCall(methodDescriptor, options);
        final Metadata extraHeaders = this.extraHeaders;
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(clientCall){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                if (extraHeaders != null) {
                    headers.merge(extraHeaders);
                }
                super.start(responseListener, headers);
            }
        };
    }
}

