/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Objects;

public class CloudEvent<T> {
    public static final String CONTENT_TYPE = "application/cloudevents+json";
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private String id;
    private String source;
    private String type;
    private String specversion;
    private String datacontenttype;
    private T data;
    @JsonProperty(value="data_base64")
    private byte[] binaryData;
    @JsonProperty(value="pubsubname")
    private String pubsubName;
    private String topic;
    @JsonSerialize(using=OffsetDateTimeSerializer.class)
    @JsonDeserialize(using=OffsetDateTimeDeserializer.class)
    private OffsetDateTime time;
    @Deprecated
    @JsonProperty(value="traceid")
    private String traceId;
    @JsonProperty(value="traceparent")
    private String traceParent;
    @JsonProperty(value="tracestate")
    private String traceState;

    public CloudEvent() {
    }

    public CloudEvent(String id, String source, String type, String specversion, String datacontenttype, T data) {
        this.id = id;
        this.source = source;
        this.type = type;
        this.specversion = specversion;
        this.datacontenttype = datacontenttype;
        this.data = data;
    }

    public CloudEvent(String id, String source, String type, String specversion, byte[] binaryData) {
        this.id = id;
        this.source = source;
        this.type = type;
        this.specversion = specversion;
        this.datacontenttype = "application/octet-stream";
        this.binaryData = binaryData == null ? null : Arrays.copyOf(binaryData, binaryData.length);
    }

    public static CloudEvent<?> deserialize(byte[] payload) throws IOException {
        if (payload == null) {
            return null;
        }
        return (CloudEvent)OBJECT_MAPPER.readValue(payload, CloudEvent.class);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSpecversion() {
        return this.specversion;
    }

    public void setSpecversion(String specversion) {
        this.specversion = specversion;
    }

    public String getDatacontenttype() {
        return this.datacontenttype;
    }

    public void setDatacontenttype(String datacontenttype) {
        this.datacontenttype = datacontenttype;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public byte[] getBinaryData() {
        return this.binaryData == null ? null : Arrays.copyOf(this.binaryData, this.binaryData.length);
    }

    public void setBinaryData(byte[] binaryData) {
        this.binaryData = binaryData == null ? null : Arrays.copyOf(binaryData, binaryData.length);
    }

    public String getPubsubName() {
        return this.pubsubName;
    }

    public void setPubsubName(String pubsubName) {
        this.pubsubName = pubsubName;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public OffsetDateTime getTime() {
        return this.time;
    }

    public void setTime(OffsetDateTime time) {
        this.time = time;
    }

    @Deprecated
    public String getTraceId() {
        return this.traceId;
    }

    @Deprecated
    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getTraceParent() {
        return this.traceParent;
    }

    public void setTraceParent(String traceParent) {
        this.traceParent = traceParent;
    }

    public String getTraceState() {
        return this.traceState;
    }

    public void setTraceState(String traceState) {
        this.traceState = traceState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudEvent that = (CloudEvent)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.source, that.source) && Objects.equals(this.type, that.type) && Objects.equals(this.specversion, that.specversion) && Objects.equals(this.datacontenttype, that.datacontenttype) && Objects.equals(this.data, that.data) && Arrays.equals(this.binaryData, that.binaryData) && Objects.equals(this.pubsubName, that.pubsubName) && Objects.equals(this.topic, that.topic) && (this.time == null && that.time == null || this.time != null && that.time != null && this.time.isEqual(that.time)) && Objects.equals(this.traceId, that.traceId) && Objects.equals(this.traceParent, that.traceParent) && Objects.equals(this.traceState, that.traceState);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.source, this.type, this.specversion, this.datacontenttype, this.data, this.binaryData, this.pubsubName, this.topic, this.time, this.traceId, this.traceParent, this.traceState);
    }

    private static class OffsetDateTimeDeserializer
    extends JsonDeserializer<OffsetDateTime> {
        private OffsetDateTimeDeserializer() {
        }

        public OffsetDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return OffsetDateTime.parse(jsonParser.getText());
        }
    }

    private static class OffsetDateTimeSerializer
    extends JsonSerializer<OffsetDateTime> {
        private OffsetDateTimeSerializer() {
        }

        public void serialize(OffsetDateTime offsetDateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(offsetDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
    }
}

