/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.config;

import io.dapr.config.BooleanProperty;
import io.dapr.config.GenericProperty;
import io.dapr.config.IntegerProperty;
import io.dapr.config.MillisecondsDurationProperty;
import io.dapr.config.Property;
import io.dapr.config.SecondsDurationProperty;
import io.dapr.config.StringProperty;
import io.dapr.utils.NetworkUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.stream.Collectors;

public class Properties {
    private static final String DEFAULT_SIDECAR_IP = NetworkUtils.getHostLoopbackAddress();
    private static final Integer DEFAULT_HTTP_PORT = 3500;
    private static final Integer DEFAULT_GRPC_PORT = 50001;
    private static final Integer DEFAULT_API_MAX_RETRIES = 0;
    private static final Duration DEFAULT_API_TIMEOUT = Duration.ofMillis(0L);
    private static final Charset DEFAULT_STRING_CHARSET = StandardCharsets.UTF_8;
    private static final Integer DEFAULT_HTTP_CLIENT_READ_TIMEOUT_SECONDS = 60;
    private static final Integer DEFAULT_HTTP_CLIENT_MAX_REQUESTS = 1024;
    private static final Integer DEFAULT_HTTP_CLIENT_MAX_IDLE_CONNECTIONS = 128;
    public static final Property<String> SIDECAR_IP = new StringProperty("dapr.sidecar.ip", "DAPR_SIDECAR_IP", DEFAULT_SIDECAR_IP);
    public static final Property<Integer> HTTP_PORT = new IntegerProperty("dapr.http.port", "DAPR_HTTP_PORT", DEFAULT_HTTP_PORT);
    public static final Property<Integer> GRPC_PORT = new IntegerProperty("dapr.grpc.port", "DAPR_GRPC_PORT", DEFAULT_GRPC_PORT);
    public static final Property<String> GRPC_TLS_CERT_PATH = new StringProperty("dapr.grpc.tls.cert.path", "DAPR_GRPC_TLS_CERT_PATH", null);
    public static final Property<String> GRPC_TLS_KEY_PATH = new StringProperty("dapr.grpc.tls.key.path", "DAPR_GRPC_TLS_KEY_PATH", null);
    public static final Property<String> GRPC_TLS_CA_PATH = new StringProperty("dapr.grpc.tls.ca.path", "DAPR_GRPC_TLS_CA_PATH", null);
    public static final Property<Boolean> GRPC_TLS_INSECURE = new BooleanProperty("dapr.grpc.tls.insecure", "DAPR_GRPC_TLS_INSECURE", false);
    public static final Property<String> GRPC_ENDPOINT = new StringProperty("dapr.grpc.endpoint", "DAPR_GRPC_ENDPOINT", null);
    public static final Property<Boolean> GRPC_ENABLE_KEEP_ALIVE = new BooleanProperty("dapr.grpc.enable.keep.alive", "DAPR_GRPC_ENABLE_KEEP_ALIVE", false);
    public static final Property<Duration> GRPC_KEEP_ALIVE_TIME_SECONDS = new SecondsDurationProperty("dapr.grpc.keep.alive.time.seconds", "DAPR_GRPC_KEEP_ALIVE_TIME_SECONDS", Duration.ofSeconds(10L));
    public static final Property<Duration> GRPC_KEEP_ALIVE_TIMEOUT_SECONDS = new SecondsDurationProperty("dapr.grpc.keep.alive.timeout.seconds", "DAPR_GRPC_KEEP_ALIVE_TIMEOUT_SECONDS", Duration.ofSeconds(5L));
    public static final Property<Boolean> GRPC_KEEP_ALIVE_WITHOUT_CALLS = new BooleanProperty("dapr.grpc.keep.alive.without.calls", "DAPR_GRPC_KEEP_ALIVE_WITHOUT_CALLS", true);
    public static final Property<String> HTTP_ENDPOINT = new StringProperty("dapr.http.endpoint", "DAPR_HTTP_ENDPOINT", null);
    public static final Property<Integer> MAX_RETRIES = new IntegerProperty("dapr.api.maxRetries", "DAPR_API_MAX_RETRIES", DEFAULT_API_MAX_RETRIES);
    public static final Property<Duration> TIMEOUT = new MillisecondsDurationProperty("dapr.api.timeoutMilliseconds", "DAPR_API_TIMEOUT_MILLISECONDS", DEFAULT_API_TIMEOUT);
    public static final Property<String> API_TOKEN = new StringProperty("dapr.api.token", "DAPR_API_TOKEN", null);
    public static final Property<Charset> STRING_CHARSET = new GenericProperty<Charset>("dapr.string.charset", "DAPR_STRING_CHARSET", DEFAULT_STRING_CHARSET, s -> Charset.forName(s));
    public static final Property<Integer> HTTP_CLIENT_READ_TIMEOUT_SECONDS = new IntegerProperty("dapr.http.client.readTimeoutSeconds", "DAPR_HTTP_CLIENT_READ_TIMEOUT_SECONDS", DEFAULT_HTTP_CLIENT_READ_TIMEOUT_SECONDS);
    public static final Property<Integer> HTTP_CLIENT_MAX_REQUESTS = new IntegerProperty("dapr.http.client.maxRequests", "DAPR_HTTP_CLIENT_MAX_REQUESTS", DEFAULT_HTTP_CLIENT_MAX_REQUESTS);
    public static final Property<Integer> HTTP_CLIENT_MAX_IDLE_CONNECTIONS = new IntegerProperty("dapr.http.client.maxIdleConnections", "DAPR_HTTP_CLIENT_MAX_IDLE_CONNECTIONS", DEFAULT_HTTP_CLIENT_MAX_IDLE_CONNECTIONS);
    public static final Property<Integer> GRPC_MAX_INBOUND_MESSAGE_SIZE_BYTES = new IntegerProperty("dapr.grpc.max.inbound.message.size.bytes", "DAPR_GRPC_MAX_INBOUND_MESSAGE_SIZE_BYTES", 0x400000);
    public static final Property<Integer> GRPC_MAX_INBOUND_METADATA_SIZE_BYTES = new IntegerProperty("dapr.grpc.max.inbound.metadata.size.bytes", "DAPR_GRPC_MAX_INBOUND_METADATA_SIZE_BYTES", 8192);
    private final Map<String, String> overrides;

    public Properties() {
        this.overrides = null;
    }

    public Properties(Map<?, String> overridesInput) {
        this.overrides = overridesInput == null ? Map.of() : Map.copyOf(overridesInput.entrySet().stream().filter(e -> e.getKey() != null).filter(e -> e.getValue() != null).collect(Collectors.toMap(entry -> entry.getKey().toString(), entry -> (String)entry.getValue())));
    }

    public <T> T getValue(Property<T> property) {
        if (this.overrides != null) {
            String override = this.overrides.get(property.getName());
            return property.get(override);
        }
        return property.get();
    }
}

