/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.internal.grpc.interceptors;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

public class DaprApiTokenInterceptor
implements ClientInterceptor {
    private final String token;

    public DaprApiTokenInterceptor(String token) {
        this.token = token;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions options, Channel channel) {
        ClientCall clientCall = channel.newCall(methodDescriptor, options);
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(clientCall){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata metadata) {
                if (DaprApiTokenInterceptor.this.token != null) {
                    metadata.put(Metadata.Key.of((String)"dapr-api-token", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)DaprApiTokenInterceptor.this.token);
                }
                super.start(responseListener, metadata);
            }
        };
    }
}

