/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.utils;

import io.dapr.config.Properties;
import io.dapr.exceptions.DaprError;
import io.dapr.exceptions.DaprException;
import io.dapr.utils.Version;
import io.grpc.ChannelCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.TlsChannelCredentials;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NetworkUtils {
    private static final long RETRY_WAIT_MILLISECONDS = 1000L;
    private static final String IPV6_REGEX = "(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))";
    private static final Pattern IPV6_PATTERN = Pattern.compile("(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))", 2);
    private static final String GRPC_ENDPOINT_FILENAME_REGEX_PART = "[^\u0000\\?]+";
    private static final String GRPC_ENDPOINT_HOSTNAME_REGEX_PART = "(([A-Za-z0-9_\\-\\.]+)|(\\[(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\\]))";
    private static final String GRPC_ENDPOINT_DNS_AUTHORITY_REGEX_PART = "(?<dnsWithAuthority>dns://)(?<authorityEndpoint>(([A-Za-z0-9_\\-\\.]+)|(\\[(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\\])):[0-9]+)?/";
    private static final String GRPC_ENDPOINT_PARAM_REGEX_PART = "(\\?(?<param>tls\\=((true)|(false))))?";
    private static final String GRPC_ENDPOINT_SOCKET_REGEX_PART = "(?<socket>((unix:)|(unix://)|(unix-abstract:))[^\u0000\\?]+)";
    private static final String GRPC_ENDPOINT_VSOCKET_REGEX_PART = "(?<vsocket>vsock:(([A-Za-z0-9_\\-\\.]+)|(\\[(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\\])):[0-9]+)";
    private static final String GRPC_ENDPOINT_HOST_REGEX_PART = "((?<http>http://)|(?<https>https://)|(?<dns>dns:)|((?<dnsWithAuthority>dns://)(?<authorityEndpoint>(([A-Za-z0-9_\\-\\.]+)|(\\[(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\\])):[0-9]+)?/))?(?<hostname>(([A-Za-z0-9_\\-\\.]+)|(\\[(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\\])))?+(:(?<port>[0-9]+))?";
    private static final String GRPC_ENDPOINT_REGEX = "^((((?<http>http://)|(?<https>https://)|(?<dns>dns:)|((?<dnsWithAuthority>dns://)(?<authorityEndpoint>(([A-Za-z0-9_\\-\\.]+)|(\\[(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\\])):[0-9]+)?/))?(?<hostname>(([A-Za-z0-9_\\-\\.]+)|(\\[(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\\])))?+(:(?<port>[0-9]+))?)|((?<socket>((unix:)|(unix://)|(unix-abstract:))[^\u0000\\?]+))|((?<vsocket>vsock:(([A-Za-z0-9_\\-\\.]+)|(\\[(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\\])):[0-9]+)))(\\?(?<param>tls\\=((true)|(false))))?$";
    private static final Pattern GRPC_ENDPOINT_PATTERN = Pattern.compile("^((((?<http>http://)|(?<https>https://)|(?<dns>dns:)|((?<dnsWithAuthority>dns://)(?<authorityEndpoint>(([A-Za-z0-9_\\-\\.]+)|(\\[(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\\])):[0-9]+)?/))?(?<hostname>(([A-Za-z0-9_\\-\\.]+)|(\\[(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\\])))?+(:(?<port>[0-9]+))?)|((?<socket>((unix:)|(unix://)|(unix-abstract:))[^\u0000\\?]+))|((?<vsocket>vsock:(([A-Za-z0-9_\\-\\.]+)|(\\[(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\\])):[0-9]+)))(\\?(?<param>tls\\=((true)|(false))))?$", 2);

    private NetworkUtils() {
    }

    public static void waitForSocket(String host, int port, int timeoutInMilliseconds) throws InterruptedException {
        long started = System.currentTimeMillis();
        NetworkUtils.callWithRetry(() -> {
            try (Socket socket = new Socket();){
                int remainingTimeout = (int)Math.max(1L, (long)timeoutInMilliseconds - (System.currentTimeMillis() - started));
                socket.connect(new InetSocketAddress(host, port), remainingTimeout);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, timeoutInMilliseconds);
    }

    public static ManagedChannel buildGrpcManagedChannel(Properties properties, ClientInterceptor ... interceptors) {
        ManagedChannelBuilder builder;
        GrpcEndpointSettings settings;
        block36: {
            settings = GrpcEndpointSettings.parse(properties);
            boolean insecureTls = properties.getValue(Properties.GRPC_TLS_INSECURE);
            if (insecureTls) {
                try {
                    NettyChannelBuilder builder2 = NettyChannelBuilder.forTarget((String)settings.endpoint).sslContext(GrpcSslContexts.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build());
                    builder2.userAgent(Version.getSdkVersion());
                    if (interceptors != null && interceptors.length > 0) {
                        builder2 = builder2.intercept(interceptors);
                    }
                    if (settings.enableKeepAlive) {
                        builder2.keepAliveTime(settings.keepAliveTimeSeconds.toSeconds(), TimeUnit.SECONDS).keepAliveTimeout(settings.keepAliveTimeoutSeconds.toSeconds(), TimeUnit.SECONDS).keepAliveWithoutCalls(settings.keepAliveWithoutCalls);
                    }
                    return builder2.maxInboundMessageSize(settings.maxInboundMessageSize).maxInboundMetadataSize(settings.maxInboundMetadataSize).build();
                }
                catch (Exception e) {
                    throw new DaprException(new DaprError().setErrorCode("TLS_CREDENTIALS_ERROR").setMessage("Failed to create insecure TLS credentials"), (Throwable)e);
                }
            }
            String clientKeyPath = settings.tlsPrivateKeyPath;
            String clientCertPath = settings.tlsCertPath;
            String caCertPath = settings.tlsCaPath;
            builder = ManagedChannelBuilder.forTarget((String)settings.endpoint);
            if (clientCertPath != null && clientKeyPath != null) {
                try (FileInputStream clientCertInputStream = new FileInputStream(clientCertPath);
                     FileInputStream clientKeyInputStream = new FileInputStream(clientKeyPath);
                     FileInputStream caCertInputStream = caCertPath != null ? new FileInputStream(caCertPath) : null;){
                    TlsChannelCredentials.Builder builderCreds = TlsChannelCredentials.newBuilder().keyManager((InputStream)clientCertInputStream, (InputStream)clientKeyInputStream);
                    if (caCertInputStream != null) {
                        builderCreds.trustManager((InputStream)caCertInputStream);
                    }
                    ChannelCredentials credentials = builderCreds.build();
                    builder = Grpc.newChannelBuilder((String)settings.endpoint, (ChannelCredentials)credentials);
                    break block36;
                }
                catch (IOException e) {
                    throw new DaprException(new DaprError().setErrorCode("TLS_CREDENTIALS_ERROR").setMessage("Failed to create mTLS credentials" + (caCertPath != null ? " with CA cert" : "")), (Throwable)e);
                }
            }
            if (caCertPath != null) {
                try (FileInputStream caCertInputStream = new FileInputStream(caCertPath);){
                    ChannelCredentials credentials = TlsChannelCredentials.newBuilder().trustManager((InputStream)caCertInputStream).build();
                    builder = Grpc.newChannelBuilder((String)settings.endpoint, (ChannelCredentials)credentials);
                    break block36;
                }
                catch (IOException e) {
                    throw new DaprException(new DaprError().setErrorCode("TLS_CREDENTIALS_ERROR").setMessage("Failed to create TLS credentials with CA cert"), (Throwable)e);
                }
            }
            if (!settings.secure) {
                builder = builder.usePlaintext();
            }
        }
        builder.userAgent(Version.getSdkVersion());
        if (interceptors != null && interceptors.length > 0) {
            builder = builder.intercept(interceptors);
        }
        if (settings.enableKeepAlive) {
            builder.keepAliveTime(settings.keepAliveTimeSeconds.toSeconds(), TimeUnit.SECONDS).keepAliveTimeout(settings.keepAliveTimeoutSeconds.toSeconds(), TimeUnit.SECONDS).keepAliveWithoutCalls(settings.keepAliveWithoutCalls);
        }
        return builder.maxInboundMessageSize(settings.maxInboundMessageSize).maxInboundMetadataSize(settings.maxInboundMetadataSize).build();
    }

    private static void callWithRetry(Runnable function, long retryTimeoutMilliseconds) throws InterruptedException {
        long started = System.currentTimeMillis();
        while (true) {
            Object exception;
            try {
                function.run();
                return;
            }
            catch (Exception e) {
                exception = e;
            }
            catch (AssertionError e) {
                exception = e;
            }
            long elapsed = System.currentTimeMillis() - started;
            if (elapsed >= retryTimeoutMilliseconds) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException((Throwable)exception);
            }
            long remaining = retryTimeoutMilliseconds - elapsed;
            Thread.sleep(Math.min(remaining, 1000L));
        }
    }

    public static String getHostLoopbackAddress() {
        return InetAddress.getLoopbackAddress().getHostAddress();
    }

    static boolean isIPv6(String ip) {
        return IPV6_PATTERN.matcher(ip).matches();
    }

    static final class GrpcEndpointSettings {
        final String endpoint;
        final boolean secure;
        final String tlsPrivateKeyPath;
        final String tlsCertPath;
        final String tlsCaPath;
        final boolean enableKeepAlive;
        final Duration keepAliveTimeSeconds;
        final Duration keepAliveTimeoutSeconds;
        final boolean keepAliveWithoutCalls;
        final int maxInboundMessageSize;
        final int maxInboundMetadataSize;

        private GrpcEndpointSettings(String endpoint, boolean secure, String tlsPrivateKeyPath, String tlsCertPath, String tlsCaPath, boolean enableKeepAlive, Duration keepAliveTimeSeconds, Duration keepAliveTimeoutSeconds, boolean keepAliveWithoutCalls, int maxInboundMessageSize, int maxInboundMetadataSize) {
            this.endpoint = endpoint;
            this.secure = secure;
            this.tlsPrivateKeyPath = tlsPrivateKeyPath;
            this.tlsCertPath = tlsCertPath;
            this.tlsCaPath = tlsCaPath;
            this.enableKeepAlive = enableKeepAlive;
            this.keepAliveTimeSeconds = keepAliveTimeSeconds;
            this.keepAliveTimeoutSeconds = keepAliveTimeoutSeconds;
            this.keepAliveWithoutCalls = keepAliveWithoutCalls;
            this.maxInboundMessageSize = maxInboundMessageSize;
            this.maxInboundMetadataSize = maxInboundMetadataSize;
        }

        static GrpcEndpointSettings parse(Properties properties) {
            String address = properties.getValue(Properties.SIDECAR_IP);
            int port = properties.getValue(Properties.GRPC_PORT);
            String clientKeyPath = properties.getValue(Properties.GRPC_TLS_KEY_PATH);
            String clientCertPath = properties.getValue(Properties.GRPC_TLS_CERT_PATH);
            String caCertPath = properties.getValue(Properties.GRPC_TLS_CA_PATH);
            boolean enablekeepAlive = properties.getValue(Properties.GRPC_ENABLE_KEEP_ALIVE);
            Duration keepAliveTimeSeconds = properties.getValue(Properties.GRPC_KEEP_ALIVE_TIME_SECONDS);
            Duration keepAliveTimeoutSeconds = properties.getValue(Properties.GRPC_KEEP_ALIVE_TIMEOUT_SECONDS);
            boolean keepAliveWithoutCalls = properties.getValue(Properties.GRPC_KEEP_ALIVE_WITHOUT_CALLS);
            int maxInboundMessageSizeBytes = properties.getValue(Properties.GRPC_MAX_INBOUND_MESSAGE_SIZE_BYTES);
            int maxInboundMetadataSizeBytes = properties.getValue(Properties.GRPC_MAX_INBOUND_METADATA_SIZE_BYTES);
            boolean secure = false;
            String grpcEndpoint = properties.getValue(Properties.GRPC_ENDPOINT);
            if (grpcEndpoint != null && !grpcEndpoint.isEmpty()) {
                String authorityEndpoint;
                Matcher matcher = GRPC_ENDPOINT_PATTERN.matcher(grpcEndpoint);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("Illegal gRPC endpoint: " + grpcEndpoint);
                }
                String parsedHost = matcher.group("hostname");
                if (parsedHost != null) {
                    address = parsedHost;
                }
                boolean https = matcher.group("https") != null;
                boolean http = matcher.group("http") != null;
                secure = https;
                String parsedPort = matcher.group("port");
                port = parsedPort != null ? Integer.parseInt(parsedPort) : (http ? 80 : 443);
                String parsedParam = matcher.group("param");
                if ((http || https) && parsedParam != null) {
                    throw new IllegalArgumentException("Query params is not supported in HTTP URI for gRPC endpoint.");
                }
                if (parsedParam != null) {
                    secure = parsedParam.equalsIgnoreCase("tls=true");
                }
                if ((authorityEndpoint = matcher.group("authorityEndpoint")) != null) {
                    return new GrpcEndpointSettings(String.format("dns://%s/%s:%d", authorityEndpoint, address, port), secure, clientKeyPath, clientCertPath, caCertPath, enablekeepAlive, keepAliveTimeSeconds, keepAliveTimeoutSeconds, keepAliveWithoutCalls, maxInboundMessageSizeBytes, maxInboundMetadataSizeBytes);
                }
                String socket = matcher.group("socket");
                if (socket != null) {
                    return new GrpcEndpointSettings(socket, secure, clientKeyPath, clientCertPath, caCertPath, enablekeepAlive, keepAliveTimeSeconds, keepAliveTimeoutSeconds, keepAliveWithoutCalls, maxInboundMessageSizeBytes, maxInboundMetadataSizeBytes);
                }
                String vsocket = matcher.group("vsocket");
                if (vsocket != null) {
                    return new GrpcEndpointSettings(vsocket, secure, clientKeyPath, clientCertPath, caCertPath, enablekeepAlive, keepAliveTimeSeconds, keepAliveTimeoutSeconds, keepAliveWithoutCalls, maxInboundMessageSizeBytes, maxInboundMetadataSizeBytes);
                }
            }
            return new GrpcEndpointSettings(String.format("dns:///%s:%d", address, port), secure, clientKeyPath, clientCertPath, caCertPath, enablekeepAlive, keepAliveTimeSeconds, keepAliveTimeoutSeconds, keepAliveWithoutCalls, maxInboundMessageSizeBytes, maxInboundMetadataSizeBytes);
        }
    }
}

