/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;

public final class Version {
    private static volatile AtomicReference<String> sdkVersion = new AtomicReference();

    public static String getSdkVersion() {
        Object version = sdkVersion.get();
        if (version != null && !((String)version).isBlank()) {
            return version;
        }
        try (InputStream input = Version.class.getResourceAsStream("/sdk_version.properties");){
            Properties properties = new Properties();
            properties.load(input);
            String v = properties.getProperty("sdk_version", null);
            if (v == null) {
                throw new IllegalStateException("Did not find sdk_version property!");
            }
            if (v.isBlank()) {
                throw new IllegalStateException("Property sdk_version cannot be blank.");
            }
            version = "dapr-sdk-java/v" + v;
            sdkVersion.set((String)version);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load sdk_version property!", e);
        }
        return version;
    }
}

