/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class ProtobufValueHelper {
    public static Value toProtobufValue(Object obj) throws IOException {
        if (obj == null) {
            return Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
        }
        if (obj instanceof Boolean) {
            return Value.newBuilder().setBoolValue(((Boolean)obj).booleanValue()).build();
        }
        if (obj instanceof String) {
            return Value.newBuilder().setStringValue((String)obj).build();
        }
        if (obj instanceof Number) {
            return Value.newBuilder().setNumberValue(((Number)obj).doubleValue()).build();
        }
        if (obj instanceof List) {
            ListValue.Builder listBuilder = ListValue.newBuilder();
            for (Object item : (List)obj) {
                listBuilder.addValues(ProtobufValueHelper.toProtobufValue(item));
            }
            return Value.newBuilder().setListValue(listBuilder.build()).build();
        }
        if (obj instanceof Map) {
            Struct.Builder structBuilder = Struct.newBuilder();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                String key = entry.getKey().toString();
                Value value = ProtobufValueHelper.toProtobufValue(entry.getValue());
                structBuilder.putFields(key, value);
            }
            return Value.newBuilder().setStructValue(structBuilder.build()).build();
        }
        return Value.newBuilder().setStringValue(obj.toString()).build();
    }
}

