/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client.domain;

import java.time.Duration;

public class JobSchedule {
    private final String expression;

    private JobSchedule(String expression) {
        this.expression = expression;
    }

    public static JobSchedule fromPeriod(Duration duration) {
        if (duration == null) {
            throw new IllegalArgumentException("duration cannot be null");
        }
        String formattedDuration = String.format("%dh%dm%ds%dms", duration.toHoursPart(), duration.toMinutesPart(), duration.toSecondsPart(), duration.toMillisPart());
        return new JobSchedule("@every " + formattedDuration);
    }

    public static JobSchedule fromString(String cronExpression) {
        if (cronExpression == null) {
            throw new IllegalArgumentException("cronExpression cannot be null");
        }
        return new JobSchedule(cronExpression);
    }

    public static JobSchedule yearly() {
        return new JobSchedule("0 0 0 1 1 *");
    }

    public static JobSchedule monthly() {
        return new JobSchedule("0 0 0 1 * *");
    }

    public static JobSchedule weekly() {
        return new JobSchedule("0 0 0 * * 0");
    }

    public static JobSchedule daily() {
        return new JobSchedule("0 0 0 * * *");
    }

    public static JobSchedule hourly() {
        return new JobSchedule("0 0 * * * *");
    }

    public String getExpression() {
        return this.expression;
    }
}

