/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.internal.grpc.interceptors;

import io.dapr.internal.opencensus.GrpcHelper;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import reactor.util.context.ContextView;

public class DaprTracingInterceptor
implements ClientInterceptor {
    private final ContextView context;

    public DaprTracingInterceptor(ContextView context) {
        this.context = context;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        ClientCall clientCall = channel.newCall(methodDescriptor, callOptions);
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(clientCall){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata metadata) {
                if (DaprTracingInterceptor.this.context != null) {
                    GrpcHelper.populateMetadata(DaprTracingInterceptor.this.context, metadata);
                }
                super.start(responseListener, metadata);
            }
        };
    }
}

