/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.internal.opencensus;

import io.dapr.internal.opencensus.SpanId;
import io.dapr.internal.opencensus.TraceId;
import io.dapr.internal.opencensus.TraceOptions;
import io.dapr.internal.opencensus.Tracestate;
import java.util.Arrays;
import javax.annotation.concurrent.Immutable;

@Immutable
final class SpanContext {
    private final TraceId traceId;
    private final SpanId spanId;
    private final TraceOptions traceOptions;
    private final Tracestate tracestate;

    static SpanContext create(TraceId traceId, SpanId spanId, TraceOptions traceOptions, Tracestate tracestate) {
        return new SpanContext(traceId, spanId, traceOptions, tracestate);
    }

    TraceId getTraceId() {
        return this.traceId;
    }

    SpanId getSpanId() {
        return this.spanId;
    }

    TraceOptions getTraceOptions() {
        return this.traceOptions;
    }

    Tracestate getTracestate() {
        return this.tracestate;
    }

    boolean isValid() {
        return this.traceId.isValid() && this.spanId.isValid();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SpanContext)) {
            return false;
        }
        SpanContext that = (SpanContext)obj;
        return this.traceId.equals(that.traceId) && this.spanId.equals(that.spanId) && this.traceOptions.equals(that.traceOptions);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.traceId, this.spanId, this.traceOptions});
    }

    private SpanContext(TraceId traceId, SpanId spanId, TraceOptions traceOptions, Tracestate tracestate) {
        this.traceId = traceId;
        this.spanId = spanId;
        this.traceOptions = traceOptions;
        this.tracestate = tracestate;
    }
}

