/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.dapr.utils.DurationUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class StateOptions {
    private final Consistency consistency;
    private final Concurrency concurrency;

    public StateOptions(Consistency consistency, Concurrency concurrency) {
        this.consistency = consistency;
        this.concurrency = concurrency;
    }

    public Concurrency getConcurrency() {
        return this.concurrency;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    @JsonIgnore
    public Map<String, String> getStateOptionsAsMap() {
        HashMap<String, String> mapOptions = new HashMap<String, String>();
        if (this.getConsistency() != null) {
            mapOptions.put("consistency", this.getConsistency().getValue());
        }
        if (this.getConcurrency() != null) {
            mapOptions.put("concurrency", this.getConcurrency().getValue());
        }
        return Collections.unmodifiableMap(Optional.ofNullable(mapOptions).orElse(Collections.EMPTY_MAP));
    }

    public static class StateOptionDurationDeserializer
    extends StdDeserializer<Duration> {
        public StateOptionDurationDeserializer(Class<?> vc) {
            super(vc);
        }

        public Duration deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String durationStr = (String)jsonParser.readValueAs(String.class);
            Duration duration = null;
            if (durationStr != null && !durationStr.trim().isEmpty()) {
                try {
                    duration = DurationUtils.convertDurationFromDaprFormat(durationStr);
                }
                catch (Exception ex) {
                    throw InvalidFormatException.from((JsonParser)jsonParser, (String)"Unable to parse duration.", (Throwable)ex);
                }
            }
            return duration;
        }
    }

    public static class StateOptionDurationSerializer
    extends StdSerializer<Duration> {
        public StateOptionDurationSerializer() {
            super(Duration.class);
        }

        public StateOptionDurationSerializer(Class<Duration> t) {
            super(t);
        }

        public void serialize(Duration duration, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeNumber(duration.toMillis());
        }
    }

    public static enum Concurrency {
        FIRST_WRITE("first-write"),
        LAST_WRITE("last-write");

        private final String value;

        private Concurrency(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Concurrency fromValue(String value) {
            return Concurrency.valueOf(value);
        }
    }

    public static enum Consistency {
        EVENTUAL("eventual"),
        STRONG("strong");

        private final String value;

        private Consistency(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Consistency fromValue(String value) {
            return Consistency.valueOf(value);
        }
    }
}

