/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import io.dapr.client.AbstractDaprClient;
import io.dapr.client.DaprHttp;
import io.dapr.client.ObjectSerializer;
import io.dapr.client.domain.ConfigurationItem;
import io.dapr.client.domain.DeleteStateRequest;
import io.dapr.client.domain.ExecuteStateTransactionRequest;
import io.dapr.client.domain.GetBulkSecretRequest;
import io.dapr.client.domain.GetBulkStateRequest;
import io.dapr.client.domain.GetConfigurationRequest;
import io.dapr.client.domain.GetSecretRequest;
import io.dapr.client.domain.GetStateRequest;
import io.dapr.client.domain.HttpExtension;
import io.dapr.client.domain.InvokeBindingRequest;
import io.dapr.client.domain.InvokeMethodRequest;
import io.dapr.client.domain.PublishEventRequest;
import io.dapr.client.domain.QueryStateItem;
import io.dapr.client.domain.QueryStateRequest;
import io.dapr.client.domain.QueryStateResponse;
import io.dapr.client.domain.SaveStateRequest;
import io.dapr.client.domain.State;
import io.dapr.client.domain.StateOptions;
import io.dapr.client.domain.SubscribeConfigurationRequest;
import io.dapr.client.domain.SubscribeConfigurationResponse;
import io.dapr.client.domain.TransactionalStateOperation;
import io.dapr.client.domain.TransactionalStateRequest;
import io.dapr.client.domain.UnsubscribeConfigurationRequest;
import io.dapr.client.domain.UnsubscribeConfigurationResponse;
import io.dapr.config.Properties;
import io.dapr.exceptions.DaprException;
import io.dapr.serializer.DaprObjectSerializer;
import io.dapr.serializer.DefaultObjectSerializer;
import io.dapr.utils.NetworkUtils;
import io.dapr.utils.TypeRef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class DaprClientHttp
extends AbstractDaprClient {
    private static final String HEADER_HTTP_ETAG_ID = "If-Match";
    private static final String METADATA_PREFIX = "metadata.";
    private static final ObjectSerializer INTERNAL_SERIALIZER = new ObjectSerializer();
    private final DaprHttp client;
    private final boolean isObjectSerializerDefault;
    private final boolean isStateSerializerDefault;

    DaprClientHttp(DaprHttp client, DaprObjectSerializer objectSerializer, DaprObjectSerializer stateSerializer) {
        super(objectSerializer, stateSerializer);
        this.client = client;
        this.isObjectSerializerDefault = objectSerializer.getClass() == DefaultObjectSerializer.class;
        this.isStateSerializerDefault = stateSerializer.getClass() == DefaultObjectSerializer.class;
    }

    DaprClientHttp(DaprHttp client) {
        this(client, new DefaultObjectSerializer(), new DefaultObjectSerializer());
    }

    @Override
    public Mono<Void> waitForSidecar(int timeoutInMilliseconds) {
        return Mono.fromRunnable(() -> {
            try {
                NetworkUtils.waitForSocket(Properties.SIDECAR_IP.get(), Properties.HTTP_PORT.get(), timeoutInMilliseconds);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public Mono<Void> publishEvent(PublishEventRequest request) {
        try {
            String pubsubName = request.getPubsubName();
            String topic = request.getTopic();
            Object data = request.getData();
            Map<String, String> metadata = request.getMetadata();
            if (topic == null || topic.trim().isEmpty()) {
                throw new IllegalArgumentException("Topic name cannot be null or empty.");
            }
            byte[] serializedEvent = this.objectSerializer.serialize(data);
            String contentType = request.getContentType();
            if (contentType == null || contentType.isEmpty()) {
                contentType = this.objectSerializer.getContentType();
            }
            Map<String, String> headers = Collections.singletonMap("content-type", contentType);
            String[] pathSegments = new String[]{"v1.0", "publish", pubsubName, topic};
            Map<String, List<String>> queryArgs = DaprClientHttp.metadataToQueryArgs(metadata);
            return Mono.subscriberContext().flatMap(context -> this.client.invokeApi(DaprHttp.HttpMethods.POST.name(), pathSegments, queryArgs, serializedEvent, headers, (Context)context)).then();
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public <T> Mono<T> invokeMethod(InvokeMethodRequest invokeMethodRequest, TypeRef<T> type) {
        try {
            String appId = invokeMethodRequest.getAppId();
            String method = invokeMethodRequest.getMethod();
            Object request = invokeMethodRequest.getBody();
            HttpExtension httpExtension = invokeMethodRequest.getHttpExtension();
            String contentType = invokeMethodRequest.getContentType();
            Map<String, String> metadata = invokeMethodRequest.getMetadata();
            if (httpExtension == null) {
                throw new IllegalArgumentException("HttpExtension cannot be null. Use HttpExtension.NONE instead.");
            }
            String httpMethod = httpExtension.getMethod().toString();
            if (appId == null || appId.trim().isEmpty()) {
                throw new IllegalArgumentException("App Id cannot be null or empty.");
            }
            if (method == null || method.trim().isEmpty()) {
                throw new IllegalArgumentException("Method name cannot be null or empty.");
            }
            String[] methodSegments = method.split("/");
            ArrayList<String> pathSegments = new ArrayList<String>(Arrays.asList("v1.0", "invoke", appId, "method"));
            pathSegments.addAll(Arrays.asList(methodSegments));
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.putAll(httpExtension.getHeaders());
            if (metadata != null) {
                headers.putAll(metadata);
            }
            byte[] serializedRequestBody = this.objectSerializer.serialize(request);
            if (contentType != null && !contentType.isEmpty()) {
                headers.put("content-type", contentType);
            } else {
                headers.put("content-type", this.objectSerializer.getContentType());
            }
            Mono response = Mono.subscriberContext().flatMap(context -> this.client.invokeApi(httpMethod, pathSegments.toArray(new String[0]), httpExtension.getQueryParams(), serializedRequestBody, (Map<String, String>)headers, (Context)context));
            return response.flatMap(r -> this.getMono(type, (DaprHttp.Response)r));
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    private <T> Mono<T> getMono(TypeRef<T> type, DaprHttp.Response r) {
        try {
            T object = this.objectSerializer.deserialize(r.getBody(), type);
            if (object == null) {
                return Mono.empty();
            }
            return Mono.just(object);
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public <T> Mono<T> invokeBinding(InvokeBindingRequest request, TypeRef<T> type) {
        try {
            String name = request.getName();
            String operation = request.getOperation();
            Object data = request.getData();
            Map<String, String> metadata = request.getMetadata();
            if (name == null || name.trim().isEmpty()) {
                throw new IllegalArgumentException("Binding name cannot be null or empty.");
            }
            if (operation == null || operation.trim().isEmpty()) {
                throw new IllegalArgumentException("Binding operation cannot be null or empty.");
            }
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put("operation", operation);
            if (metadata != null) {
                jsonMap.put("metadata", metadata);
            }
            if (data != null) {
                if (this.isObjectSerializerDefault) {
                    jsonMap.put("data", data);
                } else {
                    jsonMap.put("data", this.objectSerializer.serialize(data));
                }
            }
            byte[] payload = INTERNAL_SERIALIZER.serialize(jsonMap);
            String httpMethod = DaprHttp.HttpMethods.POST.name();
            String[] pathSegments = new String[]{"v1.0", "bindings", name};
            Mono response = Mono.subscriberContext().flatMap(context -> this.client.invokeApi(httpMethod, pathSegments, null, payload, null, (Context)context));
            return response.flatMap(r -> this.getMono(type, (DaprHttp.Response)r));
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public <T> Mono<List<State<T>>> getBulkState(GetBulkStateRequest request, TypeRef<T> type) {
        try {
            String stateStoreName = request.getStoreName();
            List<String> keys = request.getKeys();
            int parallelism = request.getParallelism();
            Map<String, String> metadata = request.getMetadata();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (keys == null || keys.isEmpty()) {
                throw new IllegalArgumentException("Key cannot be null or empty.");
            }
            if (parallelism < 0) {
                throw new IllegalArgumentException("Parallelism cannot be negative.");
            }
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            jsonMap.put("keys", keys);
            jsonMap.put("parallelism", parallelism);
            byte[] requestBody = INTERNAL_SERIALIZER.serialize(jsonMap);
            String[] pathSegments = new String[]{"v1.0", "state", stateStoreName, "bulk"};
            Map<String, List<String>> queryArgs = DaprClientHttp.metadataToQueryArgs(metadata);
            return Mono.subscriberContext().flatMap(context -> this.client.invokeApi(DaprHttp.HttpMethods.POST.name(), pathSegments, queryArgs, requestBody, null, (Context)context)).flatMap(s -> {
                try {
                    return Mono.just(this.buildStates((DaprHttp.Response)s, type));
                }
                catch (Exception ex) {
                    return DaprException.wrapMono(ex);
                }
            });
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public <T> Mono<State<T>> getState(GetStateRequest request, TypeRef<T> type) {
        try {
            String stateStoreName = request.getStoreName();
            String key = request.getKey();
            StateOptions options = request.getStateOptions();
            Map<String, String> metadata = request.getMetadata();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (key == null || key.trim().isEmpty()) {
                throw new IllegalArgumentException("Key cannot be null or empty.");
            }
            Map optionsMap = Optional.ofNullable(options).map(o -> o.getStateOptionsAsMap()).orElse(Collections.emptyMap());
            HashMap<String, List> queryParams = new HashMap<String, List>();
            queryParams.putAll(DaprClientHttp.metadataToQueryArgs(metadata));
            queryParams.putAll(optionsMap.entrySet().stream().collect(Collectors.toMap(kv -> (String)kv.getKey(), kv -> Collections.singletonList((String)kv.getValue()))));
            String[] pathSegments = new String[]{"v1.0", "state", stateStoreName, key};
            return Mono.subscriberContext().flatMap(context -> this.client.invokeApi(DaprHttp.HttpMethods.GET.name(), pathSegments, (Map<String, List<String>>)queryParams, null, (Context)context)).flatMap(s -> {
                try {
                    return Mono.justOrEmpty(this.buildState((DaprHttp.Response)s, key, options, type));
                }
                catch (Exception ex) {
                    return DaprException.wrapMono(ex);
                }
            });
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public Mono<Void> executeStateTransaction(ExecuteStateTransactionRequest request) {
        try {
            String stateStoreName = request.getStateStoreName();
            List<TransactionalStateOperation<?>> operations = request.getOperations();
            Map<String, String> metadata = request.getMetadata();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (operations == null || operations.isEmpty()) {
                return Mono.empty();
            }
            ArrayList internalOperationObjects = new ArrayList(operations.size());
            for (TransactionalStateOperation<?> operation : operations) {
                State<?> state;
                if (operation == null || (state = operation.getRequest()) == null) continue;
                if (this.isStateSerializerDefault) {
                    internalOperationObjects.add(operation);
                    continue;
                }
                byte[] data = this.stateSerializer.serialize(state.getValue());
                internalOperationObjects.add(new TransactionalStateOperation<byte[]>(operation.getOperation(), new State<byte[]>(state.getKey(), data, state.getEtag(), state.getMetadata(), state.getOptions())));
            }
            TransactionalStateRequest req = new TransactionalStateRequest(internalOperationObjects, metadata);
            byte[] serializedOperationBody = INTERNAL_SERIALIZER.serialize(req);
            String[] pathSegments = new String[]{"v1.0", "state", stateStoreName, "transaction"};
            return Mono.subscriberContext().flatMap(context -> this.client.invokeApi(DaprHttp.HttpMethods.POST.name(), pathSegments, null, serializedOperationBody, null, (Context)context)).then();
        }
        catch (Exception e) {
            return DaprException.wrapMono(e);
        }
    }

    @Override
    public Mono<Void> saveBulkState(SaveStateRequest request) {
        try {
            String stateStoreName = request.getStoreName();
            List<State<?>> states = request.getStates();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (states == null || states.isEmpty()) {
                return Mono.empty();
            }
            ArrayList internalStateObjects = new ArrayList(states.size());
            for (State<?> state : states) {
                if (state == null) continue;
                if (this.isStateSerializerDefault) {
                    internalStateObjects.add(state);
                    continue;
                }
                byte[] data = this.stateSerializer.serialize(state.getValue());
                internalStateObjects.add(new State<byte[]>(state.getKey(), data, state.getEtag(), state.getMetadata(), state.getOptions()));
            }
            byte[] serializedStateBody = INTERNAL_SERIALIZER.serialize(internalStateObjects);
            String[] pathSegments = new String[]{"v1.0", "state", stateStoreName};
            return Mono.subscriberContext().flatMap(context -> this.client.invokeApi(DaprHttp.HttpMethods.POST.name(), pathSegments, null, serializedStateBody, null, (Context)context)).then();
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public Mono<Void> deleteState(DeleteStateRequest request) {
        try {
            String stateStoreName = request.getStateStoreName();
            String key = request.getKey();
            StateOptions options = request.getStateOptions();
            String etag = request.getEtag();
            Map<String, String> metadata = request.getMetadata();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (key == null || key.trim().isEmpty()) {
                throw new IllegalArgumentException("Key cannot be null or empty.");
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            if (etag != null && !etag.trim().isEmpty()) {
                headers.put(HEADER_HTTP_ETAG_ID, etag);
            }
            Map optionsMap = Optional.ofNullable(options).map(o -> o.getStateOptionsAsMap()).orElse(Collections.emptyMap());
            HashMap<String, List> queryParams = new HashMap<String, List>();
            queryParams.putAll(DaprClientHttp.metadataToQueryArgs(metadata));
            queryParams.putAll(optionsMap.entrySet().stream().collect(Collectors.toMap(kv -> (String)kv.getKey(), kv -> Collections.singletonList((String)kv.getValue()))));
            String[] pathSegments = new String[]{"v1.0", "state", stateStoreName, key};
            return Mono.subscriberContext().flatMap(context -> this.client.invokeApi(DaprHttp.HttpMethods.DELETE.name(), pathSegments, (Map<String, List<String>>)queryParams, (Map<String, String>)headers, (Context)context)).then();
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    private <T> State<T> buildState(DaprHttp.Response response, String requestedKey, StateOptions stateOptions, TypeRef<T> type) throws IOException {
        T value = this.stateSerializer.deserialize(response.getBody(), type);
        String etag = null;
        if (response.getHeaders() != null && response.getHeaders().containsKey("Etag")) {
            etag = response.getHeaders().get("Etag");
        }
        return new State<T>(requestedKey, value, etag, Collections.emptyMap(), stateOptions);
    }

    private <T> List<State<T>> buildStates(DaprHttp.Response response, TypeRef<T> type) throws IOException {
        JsonNode root = INTERNAL_SERIALIZER.parseNode(response.getBody());
        ArrayList<State<T>> result = new ArrayList<State<T>>();
        Iterator it = root.elements();
        while (it.hasNext()) {
            JsonNode node = (JsonNode)it.next();
            String key = node.path("key").asText();
            String error = node.path("error").asText();
            if (!Strings.isNullOrEmpty((String)error)) {
                result.add(new State(key, error));
                continue;
            }
            String etag = node.path("etag").asText();
            if (etag.equals("")) {
                etag = null;
            }
            byte[] data = node.path("data").toString().getBytes(Properties.STRING_CHARSET.get());
            T value = this.stateSerializer.deserialize(data, type);
            result.add(new State<T>(key, value, etag));
        }
        return result;
    }

    @Override
    public Mono<Map<String, String>> getSecret(GetSecretRequest request) {
        String secretStoreName = request.getStoreName();
        String key = request.getKey();
        Map<String, String> metadata = request.getMetadata();
        try {
            if (secretStoreName == null || secretStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("Secret store name cannot be null or empty.");
            }
            if (key == null || key.trim().isEmpty()) {
                throw new IllegalArgumentException("Secret key cannot be null or empty.");
            }
        }
        catch (Exception e) {
            return DaprException.wrapMono(e);
        }
        Map<String, List<String>> queryArgs = DaprClientHttp.metadataToQueryArgs(metadata);
        String[] pathSegments = new String[]{"v1.0", "secrets", secretStoreName, key};
        return Mono.subscriberContext().flatMap(context -> this.client.invokeApi(DaprHttp.HttpMethods.GET.name(), pathSegments, queryArgs, (String)null, null, (Context)context)).flatMap(response -> {
            try {
                Map m = INTERNAL_SERIALIZER.deserialize(response.getBody(), Map.class);
                if (m == null) {
                    return Mono.just((Object)Collections.EMPTY_MAP);
                }
                return Mono.just((Object)m);
            }
            catch (IOException e) {
                return DaprException.wrapMono(e);
            }
        }).map(m -> m);
    }

    @Override
    public Mono<Map<String, Map<String, String>>> getBulkSecret(GetBulkSecretRequest request) {
        String secretStoreName = request.getStoreName();
        Map<String, String> metadata = request.getMetadata();
        try {
            if (secretStoreName == null || secretStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("Secret store name cannot be null or empty.");
            }
        }
        catch (Exception e) {
            return DaprException.wrapMono(e);
        }
        Map<String, List<String>> queryArgs = DaprClientHttp.metadataToQueryArgs(metadata);
        String[] pathSegments = new String[]{"v1.0", "secrets", secretStoreName, "bulk"};
        return Mono.subscriberContext().flatMap(context -> this.client.invokeApi(DaprHttp.HttpMethods.GET.name(), pathSegments, queryArgs, (String)null, null, (Context)context)).flatMap(response -> {
            try {
                Map m = INTERNAL_SERIALIZER.deserialize(response.getBody(), Map.class);
                if (m == null) {
                    return Mono.just((Object)Collections.EMPTY_MAP);
                }
                return Mono.just((Object)m);
            }
            catch (IOException e) {
                return DaprException.wrapMono(e);
            }
        }).map(m -> m);
    }

    @Override
    public <T> Mono<QueryStateResponse<T>> queryState(QueryStateRequest request, TypeRef<T> type) {
        try {
            String serializedRequest;
            if (request == null) {
                throw new IllegalArgumentException("Query state request cannot be null.");
            }
            String stateStoreName = request.getStoreName();
            Map<String, String> metadata = request.getMetadata();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            Map<String, List<String>> queryArgs = DaprClientHttp.metadataToQueryArgs(metadata);
            String[] pathSegments = new String[]{"v1.0-alpha1", "state", stateStoreName, "query"};
            if (request.getQuery() != null) {
                serializedRequest = JSON_REQUEST_MAPPER.writeValueAsString((Object)request.getQuery());
            } else if (request.getQueryString() != null) {
                serializedRequest = request.getQueryString();
            } else {
                throw new IllegalArgumentException("Both query and queryString fields are not set.");
            }
            return Mono.subscriberContext().flatMap(context -> this.client.invokeApi(DaprHttp.HttpMethods.POST.name(), pathSegments, queryArgs, serializedRequest, null, (Context)context)).flatMap(response -> {
                try {
                    return Mono.justOrEmpty(this.buildQueryStateResponse((DaprHttp.Response)response, type));
                }
                catch (Exception e) {
                    return DaprException.wrapMono(e);
                }
            });
        }
        catch (Exception e) {
            return DaprException.wrapMono(e);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Mono<Void> shutdown() {
        String[] pathSegments = new String[]{"v1.0", "shutdown"};
        return Mono.subscriberContext().flatMap(context -> this.client.invokeApi(DaprHttp.HttpMethods.POST.name(), pathSegments, null, null, (Context)context)).then();
    }

    private <T> QueryStateResponse<T> buildQueryStateResponse(DaprHttp.Response response, TypeRef<T> type) throws IOException {
        JsonNode root = INTERNAL_SERIALIZER.parseNode(response.getBody());
        if (!root.has("results")) {
            return new QueryStateResponse(Collections.emptyList(), null);
        }
        String token = null;
        if (root.has("token")) {
            token = root.path("token").asText();
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (root.has("metadata")) {
            Iterator it = root.get("metadata").fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                metadata.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
            }
        }
        ArrayList result = new ArrayList();
        Iterator it = root.get("results").elements();
        while (it.hasNext()) {
            JsonNode node = (JsonNode)it.next();
            String key = node.path("key").asText();
            String error = node.path("error").asText();
            if (!Strings.isNullOrEmpty((String)error)) {
                result.add(new QueryStateItem(key, null, error));
                continue;
            }
            String etag = node.path("etag").asText();
            if (etag.equals("")) {
                etag = null;
            }
            byte[] data = node.path("data").toString().getBytes(Properties.STRING_CHARSET.get());
            T value = this.stateSerializer.deserialize(data, type);
            result.add(new QueryStateItem<T>(key, value, etag));
        }
        return new QueryStateResponse(result, token).setMetadata(metadata);
    }

    @Override
    public Mono<Map<String, ConfigurationItem>> getConfiguration(GetConfigurationRequest request) {
        try {
            String configurationStoreName = request.getStoreName();
            List<String> keys = request.getKeys();
            Map<String, String> metadata = request.getMetadata();
            if (configurationStoreName == null || configurationStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("Configuration Store Name cannot be null or empty.");
            }
            HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
            if (!keys.isEmpty()) {
                queryParams.put("key", Collections.unmodifiableList(keys));
            }
            Map<String, List<String>> queryArgs = DaprClientHttp.metadataToQueryArgs(metadata);
            queryParams.putAll(queryArgs);
            String[] pathSegments = new String[]{"v1.0-alpha1", "configuration", configurationStoreName};
            return Mono.subscriberContext().flatMap(context -> this.client.invokeApi(DaprHttp.HttpMethods.GET.name(), pathSegments, (Map<String, List<String>>)queryParams, (String)null, null, (Context)context)).map(response -> {
                try {
                    Map m = INTERNAL_SERIALIZER.deserialize(response.getBody(), Map.class);
                    Set set = m.keySet();
                    JsonNode root = INTERNAL_SERIALIZER.parseNode(response.getBody());
                    Iterator itr = set.iterator();
                    HashMap<String, ConfigurationItem> result = new HashMap<String, ConfigurationItem>();
                    while (itr.hasNext()) {
                        String key = (String)itr.next();
                        String value = root.get(key).path("value").asText();
                        String version = root.get(key).path("version").asText();
                        result.put(key, new ConfigurationItem(key, value, version, new HashMap<String, String>()));
                    }
                    return Collections.unmodifiableMap(result);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public Flux<SubscribeConfigurationResponse> subscribeConfiguration(SubscribeConfigurationRequest request) {
        try {
            String configurationStoreName = request.getStoreName();
            List<String> keys = request.getKeys();
            Map<String, String> metadata = request.getMetadata();
            if (configurationStoreName == null || configurationStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("Configuration Store Name can not be null or empty.");
            }
            HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
            if (!keys.isEmpty()) {
                queryParams.put("key", Collections.unmodifiableList(keys));
            }
            Map<String, List<String>> queryArgs = DaprClientHttp.metadataToQueryArgs(metadata);
            queryParams.putAll(queryArgs);
            String[] pathSegments = new String[]{"v1.0-alpha1", "configuration", configurationStoreName, "subscribe"};
            SubscribeConfigurationResponse res = (SubscribeConfigurationResponse)Mono.subscriberContext().flatMap(context -> this.client.invokeApi(DaprHttp.HttpMethods.GET.name(), pathSegments, (Map<String, List<String>>)queryParams, (String)null, null, (Context)context)).map(response -> {
                try {
                    JsonNode root = INTERNAL_SERIALIZER.parseNode(response.getBody());
                    String subscriptionId = root.path("id").asText();
                    return new SubscribeConfigurationResponse(subscriptionId, new HashMap<String, ConfigurationItem>());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).block();
            if (res != null) {
                return Flux.just((Object)res);
            }
            return Flux.empty();
        }
        catch (Exception ex) {
            return DaprException.wrapFlux(ex);
        }
    }

    @Override
    public Mono<UnsubscribeConfigurationResponse> unsubscribeConfiguration(UnsubscribeConfigurationRequest request) {
        try {
            String id = request.getSubscriptionId();
            String configStoreName = request.getStoreName();
            if (configStoreName == null || configStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("Configuration Store Name can not be null or empty.");
            }
            if (id.isEmpty()) {
                throw new IllegalArgumentException("Subscription id can not be null or empty.");
            }
            String[] pathSegments = new String[]{"v1.0-alpha1", "configuration", configStoreName, id, "unsubscribe"};
            return Mono.subscriberContext().flatMap(context -> this.client.invokeApi(DaprHttp.HttpMethods.GET.name(), pathSegments, null, (String)null, null, (Context)context)).map(response -> {
                JsonNode root = null;
                try {
                    root = INTERNAL_SERIALIZER.parseNode(response.getBody());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                boolean ok = root.path("ok").asBoolean();
                String message = root.path("message").asText();
                return new UnsubscribeConfigurationResponse(ok, message);
            });
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    private static Map<String, List<String>> metadataToQueryArgs(Map<String, String> metadata) {
        if (metadata == null) {
            return Collections.emptyMap();
        }
        return metadata.entrySet().stream().filter(e -> e.getKey() != null).collect(Collectors.toMap(e -> METADATA_PREFIX + (String)e.getKey(), e -> Collections.singletonList((String)e.getValue())));
    }
}

