/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client.domain.query.filters;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import io.dapr.client.domain.query.filters.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class OrFilter
extends Filter {
    @JsonIgnore
    private List<Filter<?>> or;

    public OrFilter() {
        super("OR");
        this.or = new ArrayList();
    }

    @JsonCreator
    OrFilter(Filter<?>[] filters) {
        super("OR");
        this.or = Arrays.asList(filters);
    }

    public <V extends Filter> OrFilter addClause(V filter) {
        this.or.add(filter);
        return this;
    }

    @JsonValue
    public Filter<?>[] getClauses() {
        return this.or.toArray(new Filter[0]);
    }

    @Override
    @JsonIgnore
    public String getRepresentation() {
        return this.or.stream().map(Filter::getRepresentation).collect(Collectors.joining(" OR "));
    }

    @Override
    public Boolean isValid() {
        boolean validAnd;
        boolean bl = validAnd = this.or != null && this.or.size() >= 2;
        if (validAnd) {
            for (Filter<?> filter : this.or) {
                if (filter.isValid().booleanValue()) continue;
                return false;
            }
        }
        return validAnd;
    }
}

