/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dapr.config.Properties;
import io.dapr.exceptions.DaprError;
import io.dapr.exceptions.DaprException;
import io.dapr.utils.Version;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class DaprHttp
implements AutoCloseable {
    public static final String API_VERSION = "v1.0";
    public static final String ALPHA_1_API_VERSION = "v1.0-alpha1";
    private static final String HEADER_DAPR_REQUEST_ID = "X-DaprRequestId";
    private static final String DEFAULT_HTTP_SCHEME = "http";
    private static final Set<String> ALLOWED_CONTEXT_IN_HEADERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("grpc-trace-bin", "traceparent", "tracestate")));
    private static final MediaType MEDIA_TYPE_APPLICATION_JSON = MediaType.get((String)"application/json; charset=utf-8");
    private static final RequestBody REQUEST_BODY_EMPTY_JSON = RequestBody.Companion.create("", MEDIA_TYPE_APPLICATION_JSON);
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final String hostname;
    private final int port;
    private final OkHttpClient httpClient;

    DaprHttp(String hostname, int port, OkHttpClient httpClient) {
        this.hostname = hostname;
        this.port = port;
        this.httpClient = httpClient;
    }

    public Mono<Response> invokeApi(String method, String[] pathSegments, Map<String, List<String>> urlParameters, Map<String, String> headers, Context context) {
        return this.invokeApi(method, pathSegments, urlParameters, (byte[])null, headers, context);
    }

    public Mono<Response> invokeApi(String method, String[] pathSegments, Map<String, List<String>> urlParameters, String content, Map<String, String> headers, Context context) {
        return this.invokeApi(method, pathSegments, urlParameters, content == null ? EMPTY_BYTES : content.getBytes(StandardCharsets.UTF_8), headers, context);
    }

    public Mono<Response> invokeApi(String method, String[] pathSegments, Map<String, List<String>> urlParameters, byte[] content, Map<String, String> headers, Context context) {
        return Mono.fromCallable(() -> this.doInvokeApi(method, pathSegments, urlParameters, content, headers, context)).flatMap(f -> Mono.fromFuture((CompletableFuture)f));
    }

    @Override
    public void close() {
    }

    private CompletableFuture<Response> doInvokeApi(String method, String[] pathSegments, Map<String, List<String>> urlParameters, byte[] content, Map<String, String> headers, Context context) {
        MediaType mediaType;
        String requestId = UUID.randomUUID().toString();
        String contentType = headers != null ? headers.get("content-type") : null;
        MediaType mediaType2 = mediaType = contentType == null ? MEDIA_TYPE_APPLICATION_JSON : MediaType.get((String)contentType);
        RequestBody body = content == null ? (mediaType.equals((Object)MEDIA_TYPE_APPLICATION_JSON) ? REQUEST_BODY_EMPTY_JSON : RequestBody.Companion.create(new byte[0], mediaType)) : RequestBody.Companion.create(content, mediaType);
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder();
        urlBuilder.scheme(DEFAULT_HTTP_SCHEME).host(this.hostname).port(this.port);
        for (String pathSegment : pathSegments) {
            urlBuilder.addPathSegment(pathSegment);
        }
        Optional.ofNullable(urlParameters).orElse(Collections.emptyMap()).entrySet().stream().forEach(urlParameter -> Optional.ofNullable((List)urlParameter.getValue()).orElse(Collections.emptyList()).stream().forEach(urlParameterValue -> urlBuilder.addQueryParameter((String)urlParameter.getKey(), urlParameterValue)));
        Request.Builder requestBuilder = new Request.Builder().url(urlBuilder.build()).addHeader(HEADER_DAPR_REQUEST_ID, requestId);
        if (context != null) {
            context.stream().filter(entry -> ALLOWED_CONTEXT_IN_HEADERS.contains(entry.getKey().toString().toLowerCase())).forEach(entry -> requestBuilder.addHeader(entry.getKey().toString(), entry.getValue().toString()));
        }
        if (HttpMethods.GET.name().equals(method)) {
            requestBuilder.get();
        } else if (HttpMethods.DELETE.name().equals(method)) {
            requestBuilder.delete();
        } else {
            requestBuilder.method(method, body);
        }
        String daprApiToken = Properties.API_TOKEN.get();
        if (daprApiToken != null) {
            requestBuilder.addHeader("dapr-api-token", daprApiToken);
        }
        requestBuilder.addHeader("User-Agent", Version.getSdkVersion());
        if (headers != null) {
            Optional.ofNullable(headers.entrySet()).orElse(Collections.emptySet()).stream().forEach(header -> requestBuilder.addHeader((String)header.getKey(), (String)header.getValue()));
        }
        Request request = requestBuilder.build();
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        this.httpClient.newCall(request).enqueue((Callback)new ResponseFutureCallback(future));
        return future;
    }

    private static DaprError parseDaprError(byte[] json) {
        if (json == null || json.length == 0) {
            return null;
        }
        try {
            return (DaprError)OBJECT_MAPPER.readValue(json, DaprError.class);
        }
        catch (IOException e) {
            throw new DaprException("UNKNOWN", new String(json, StandardCharsets.UTF_8));
        }
    }

    private static byte[] getBodyBytesOrEmptyArray(okhttp3.Response response) throws IOException {
        ResponseBody body = response.body();
        if (body != null) {
            return body.bytes();
        }
        return EMPTY_BYTES;
    }

    private static class ResponseFutureCallback
    implements Callback {
        private final CompletableFuture<Response> future;

        public ResponseFutureCallback(CompletableFuture<Response> future) {
            this.future = future;
        }

        public void onFailure(Call call, IOException e) {
            this.future.completeExceptionally(e);
        }

        public void onResponse(@NotNull Call call, @NotNull okhttp3.Response response) throws IOException {
            if (!response.isSuccessful()) {
                try {
                    DaprError error = DaprHttp.parseDaprError(DaprHttp.getBodyBytesOrEmptyArray(response));
                    if (error != null && error.getErrorCode() != null) {
                        if (error.getMessage() != null) {
                            this.future.completeExceptionally(new DaprException(error));
                        } else {
                            this.future.completeExceptionally(new DaprException(error.getErrorCode(), "HTTP status code: " + response.code()));
                        }
                        return;
                    }
                    this.future.completeExceptionally(new DaprException("UNKNOWN", "HTTP status code: " + response.code()));
                    return;
                }
                catch (DaprException e) {
                    this.future.completeExceptionally(e);
                    return;
                }
            }
            HashMap<String, String> mapHeaders = new HashMap<String, String>();
            byte[] result = DaprHttp.getBodyBytesOrEmptyArray(response);
            response.headers().forEach(pair -> mapHeaders.put((String)pair.getFirst(), (String)pair.getSecond()));
            this.future.complete(new Response(result, mapHeaders, response.code()));
        }
    }

    public static class Response {
        private byte[] body;
        private Map<String, String> headers;
        private int statusCode;

        public Response(byte[] body, Map<String, String> headers, int statusCode) {
            this.body = body == null ? EMPTY_BYTES : Arrays.copyOf(body, body.length);
            this.headers = headers;
            this.statusCode = statusCode;
        }

        public byte[] getBody() {
            return Arrays.copyOf(this.body, this.body.length);
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }

    public static enum HttpMethods {
        NONE,
        GET,
        PUT,
        POST,
        DELETE,
        HEAD,
        CONNECT,
        OPTIONS,
        TRACE;

    }
}

