/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import com.google.common.base.Strings;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import io.dapr.client.AbstractDaprClient;
import io.dapr.client.domain.BulkPublishEntry;
import io.dapr.client.domain.BulkPublishRequest;
import io.dapr.client.domain.BulkPublishResponse;
import io.dapr.client.domain.BulkPublishResponseFailedEntry;
import io.dapr.client.domain.ConfigurationItem;
import io.dapr.client.domain.DeleteStateRequest;
import io.dapr.client.domain.ExecuteStateTransactionRequest;
import io.dapr.client.domain.GetBulkSecretRequest;
import io.dapr.client.domain.GetBulkStateRequest;
import io.dapr.client.domain.GetConfigurationRequest;
import io.dapr.client.domain.GetSecretRequest;
import io.dapr.client.domain.GetStateRequest;
import io.dapr.client.domain.HttpExtension;
import io.dapr.client.domain.InvokeBindingRequest;
import io.dapr.client.domain.InvokeMethodRequest;
import io.dapr.client.domain.PublishEventRequest;
import io.dapr.client.domain.QueryStateItem;
import io.dapr.client.domain.QueryStateRequest;
import io.dapr.client.domain.QueryStateResponse;
import io.dapr.client.domain.SaveStateRequest;
import io.dapr.client.domain.State;
import io.dapr.client.domain.StateOptions;
import io.dapr.client.domain.SubscribeConfigurationRequest;
import io.dapr.client.domain.SubscribeConfigurationResponse;
import io.dapr.client.domain.TransactionalStateOperation;
import io.dapr.client.domain.UnsubscribeConfigurationRequest;
import io.dapr.client.domain.UnsubscribeConfigurationResponse;
import io.dapr.config.Properties;
import io.dapr.exceptions.DaprException;
import io.dapr.internal.opencensus.GrpcWrapper;
import io.dapr.serializer.DaprObjectSerializer;
import io.dapr.serializer.DefaultObjectSerializer;
import io.dapr.utils.DefaultContentTypeConverter;
import io.dapr.utils.NetworkUtils;
import io.dapr.utils.TypeRef;
import io.dapr.v1.CommonProtos;
import io.dapr.v1.DaprGrpc;
import io.dapr.v1.DaprProtos;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.util.context.ContextView;

public class DaprClientGrpc
extends AbstractDaprClient {
    private Closeable channel;
    private DaprGrpc.DaprStub asyncStub;

    DaprClientGrpc(Closeable closeableChannel, DaprGrpc.DaprStub asyncStub, DaprObjectSerializer objectSerializer, DaprObjectSerializer stateSerializer) {
        super(objectSerializer, stateSerializer);
        this.channel = closeableChannel;
        this.asyncStub = DaprClientGrpc.intercept(asyncStub);
    }

    private CommonProtos.StateOptions.StateConsistency getGrpcStateConsistency(StateOptions options) {
        switch (options.getConsistency()) {
            case EVENTUAL: {
                return CommonProtos.StateOptions.StateConsistency.CONSISTENCY_EVENTUAL;
            }
            case STRONG: {
                return CommonProtos.StateOptions.StateConsistency.CONSISTENCY_STRONG;
            }
        }
        throw new IllegalArgumentException("Missing Consistency mapping to gRPC Consistency enum");
    }

    private CommonProtos.StateOptions.StateConcurrency getGrpcStateConcurrency(StateOptions options) {
        switch (options.getConcurrency()) {
            case FIRST_WRITE: {
                return CommonProtos.StateOptions.StateConcurrency.CONCURRENCY_FIRST_WRITE;
            }
            case LAST_WRITE: {
                return CommonProtos.StateOptions.StateConcurrency.CONCURRENCY_LAST_WRITE;
            }
        }
        throw new IllegalArgumentException("Missing StateConcurrency mapping to gRPC Concurrency enum");
    }

    @Override
    public Mono<Void> waitForSidecar(int timeoutInMilliseconds) {
        return Mono.fromRunnable(() -> {
            try {
                NetworkUtils.waitForSocket(Properties.SIDECAR_IP.get(), Properties.GRPC_PORT.get(), timeoutInMilliseconds);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public Mono<Void> publishEvent(PublishEventRequest request) {
        try {
            String pubsubName = request.getPubsubName();
            String topic = request.getTopic();
            Object data = request.getData();
            DaprProtos.PublishEventRequest.Builder envelopeBuilder = DaprProtos.PublishEventRequest.newBuilder().setTopic(topic).setPubsubName(pubsubName).setData(ByteString.copyFrom((byte[])this.objectSerializer.serialize(data)));
            String contentType = request.getContentType();
            if (contentType == null || contentType.isEmpty()) {
                contentType = this.objectSerializer.getContentType();
            }
            envelopeBuilder.setDataContentType(contentType);
            Map<String, String> metadata = request.getMetadata();
            if (metadata != null) {
                envelopeBuilder.putAllMetadata(metadata);
            }
            return Mono.deferContextual(context -> this.createMono(it -> DaprClientGrpc.intercept(context, this.asyncStub).publishEvent(envelopeBuilder.build(), it))).then();
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public <T> Mono<BulkPublishResponse<T>> publishEvents(BulkPublishRequest<T> request) {
        try {
            String pubsubName = request.getPubsubName();
            String topic = request.getTopic();
            DaprProtos.BulkPublishRequest.Builder envelopeBuilder = DaprProtos.BulkPublishRequest.newBuilder();
            envelopeBuilder.setTopic(topic);
            envelopeBuilder.setPubsubName(pubsubName);
            if (Strings.isNullOrEmpty((String)pubsubName) || Strings.isNullOrEmpty((String)topic)) {
                throw new IllegalArgumentException("pubsubName and topic name cannot be null or empty");
            }
            for (BulkPublishEntry<T> entry : request.getEntries()) {
                byte[] data;
                T event = entry.getEvent();
                String contentType = entry.getContentType();
                try {
                    if (!Strings.isNullOrEmpty((String)contentType) && this.objectSerializer instanceof DefaultObjectSerializer) {
                        data = DefaultContentTypeConverter.convertEventToBytesForGrpc(event, contentType);
                    } else {
                        data = this.objectSerializer.serialize(event);
                        if (Strings.isNullOrEmpty((String)contentType)) {
                            contentType = this.objectSerializer.getContentType();
                        }
                    }
                }
                catch (IOException ex) {
                    throw DaprException.propagate(ex);
                }
                DaprProtos.BulkPublishRequestEntry.Builder reqEntryBuilder = DaprProtos.BulkPublishRequestEntry.newBuilder().setEntryId(entry.getEntryId()).setEvent(ByteString.copyFrom((byte[])data)).setContentType(contentType);
                Map<String, String> metadata = entry.getMetadata();
                if (metadata != null) {
                    reqEntryBuilder.putAllMetadata(metadata);
                }
                envelopeBuilder.addEntries(reqEntryBuilder.build());
            }
            Map<String, String> metadata = request.getMetadata();
            if (metadata != null) {
                envelopeBuilder.putAllMetadata(metadata);
            }
            HashMap entryMap = new HashMap();
            for (BulkPublishEntry<T> entry : request.getEntries()) {
                entryMap.put(entry.getEntryId(), entry);
            }
            return Mono.deferContextual(context -> this.createMono(it -> DaprClientGrpc.intercept(context, this.asyncStub).bulkPublishEventAlpha1(envelopeBuilder.build(), it))).map(it -> {
                ArrayList entries = new ArrayList();
                for (DaprProtos.BulkPublishResponseFailedEntry entry : it.getFailedEntriesList()) {
                    BulkPublishResponseFailedEntry domainEntry = new BulkPublishResponseFailedEntry((BulkPublishEntry)entryMap.get(entry.getEntryId()), entry.getError());
                    entries.add(domainEntry);
                }
                if (entries.size() > 0) {
                    return new BulkPublishResponse(entries);
                }
                return new BulkPublishResponse();
            });
        }
        catch (RuntimeException ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public <T> Mono<T> invokeMethod(InvokeMethodRequest invokeMethodRequest, TypeRef<T> type) {
        try {
            String appId = invokeMethodRequest.getAppId();
            String method = invokeMethodRequest.getMethod();
            Object body = invokeMethodRequest.getBody();
            HttpExtension httpExtension = invokeMethodRequest.getHttpExtension();
            DaprProtos.InvokeServiceRequest envelope = this.buildInvokeServiceRequest(httpExtension, appId, method, body);
            return Mono.deferContextual(context -> this.createMono(it -> DaprClientGrpc.intercept(context, this.asyncStub).invokeService(envelope, it))).flatMap(it -> {
                try {
                    return Mono.justOrEmpty(this.objectSerializer.deserialize(it.getData().getValue().toByteArray(), type));
                }
                catch (IOException e) {
                    throw DaprException.propagate(e);
                }
            });
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public <T> Mono<T> invokeBinding(InvokeBindingRequest request, TypeRef<T> type) {
        try {
            String name = request.getName();
            String operation = request.getOperation();
            Object data = request.getData();
            Map<String, String> metadata = request.getMetadata();
            if (name == null || name.trim().isEmpty()) {
                throw new IllegalArgumentException("Binding name cannot be null or empty.");
            }
            if (operation == null || operation.trim().isEmpty()) {
                throw new IllegalArgumentException("Binding operation cannot be null or empty.");
            }
            byte[] byteData = this.objectSerializer.serialize(data);
            DaprProtos.InvokeBindingRequest.Builder builder = DaprProtos.InvokeBindingRequest.newBuilder().setName(name).setOperation(operation);
            if (byteData != null) {
                builder.setData(ByteString.copyFrom((byte[])byteData));
            }
            if (metadata != null) {
                builder.putAllMetadata(metadata);
            }
            DaprProtos.InvokeBindingRequest envelope = builder.build();
            return Mono.deferContextual(context -> this.createMono(it -> DaprClientGrpc.intercept(context, this.asyncStub).invokeBinding(envelope, it))).flatMap(it -> {
                try {
                    return Mono.justOrEmpty(this.objectSerializer.deserialize(it.getData().toByteArray(), type));
                }
                catch (IOException e) {
                    throw DaprException.propagate(e);
                }
            });
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public <T> Mono<State<T>> getState(GetStateRequest request, TypeRef<T> type) {
        try {
            String stateStoreName = request.getStoreName();
            String key = request.getKey();
            StateOptions options = request.getStateOptions();
            Map<String, String> metadata = request.getMetadata();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (key == null || key.trim().isEmpty()) {
                throw new IllegalArgumentException("Key cannot be null or empty.");
            }
            DaprProtos.GetStateRequest.Builder builder = DaprProtos.GetStateRequest.newBuilder().setStoreName(stateStoreName).setKey(key);
            if (metadata != null) {
                builder.putAllMetadata(metadata);
            }
            if (options != null && options.getConsistency() != null) {
                builder.setConsistency(this.getGrpcStateConsistency(options));
            }
            DaprProtos.GetStateRequest envelope = builder.build();
            return Mono.deferContextual(context -> this.createMono(it -> DaprClientGrpc.intercept(context, this.asyncStub).getState(envelope, it))).map(it -> {
                try {
                    return this.buildStateKeyValue((DaprProtos.GetStateResponse)it, key, options, type);
                }
                catch (IOException ex) {
                    throw DaprException.propagate(ex);
                }
            });
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public <T> Mono<List<State<T>>> getBulkState(GetBulkStateRequest request, TypeRef<T> type) {
        try {
            String stateStoreName = request.getStoreName();
            List<String> keys = request.getKeys();
            int parallelism = request.getParallelism();
            Map<String, String> metadata = request.getMetadata();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (keys == null || keys.isEmpty()) {
                throw new IllegalArgumentException("Key cannot be null or empty.");
            }
            if (parallelism < 0) {
                throw new IllegalArgumentException("Parallelism cannot be negative.");
            }
            DaprProtos.GetBulkStateRequest.Builder builder = DaprProtos.GetBulkStateRequest.newBuilder().setStoreName(stateStoreName).addAllKeys(keys).setParallelism(parallelism);
            if (metadata != null) {
                builder.putAllMetadata(metadata);
            }
            DaprProtos.GetBulkStateRequest envelope = builder.build();
            return Mono.deferContextual(context -> this.createMono(it -> DaprClientGrpc.intercept(context, this.asyncStub).getBulkState(envelope, it))).map(it -> it.getItemsList().stream().map(b -> {
                try {
                    return this.buildStateKeyValue((DaprProtos.BulkStateItem)b, type);
                }
                catch (Exception e) {
                    throw DaprException.propagate(e);
                }
            }).collect(Collectors.toList()));
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    private <T> State<T> buildStateKeyValue(DaprProtos.BulkStateItem item, TypeRef<T> type) throws IOException {
        String key = item.getKey();
        String error = item.getError();
        if (!Strings.isNullOrEmpty((String)error)) {
            return new State(key, error);
        }
        ByteString payload = item.getData();
        byte[] data = payload == null ? null : payload.toByteArray();
        T value = this.stateSerializer.deserialize(data, type);
        String etag = item.getEtag();
        if (etag.equals("")) {
            etag = null;
        }
        return new State<T>(key, value, etag, item.getMetadataMap(), null);
    }

    private <T> State<T> buildStateKeyValue(DaprProtos.GetStateResponse response, String requestedKey, StateOptions stateOptions, TypeRef<T> type) throws IOException {
        ByteString payload = response.getData();
        byte[] data = payload == null ? null : payload.toByteArray();
        T value = this.stateSerializer.deserialize(data, type);
        String etag = response.getEtag();
        if (etag.equals("")) {
            etag = null;
        }
        return new State<T>(requestedKey, value, etag, response.getMetadataMap(), stateOptions);
    }

    @Override
    public Mono<Void> executeStateTransaction(ExecuteStateTransactionRequest request) {
        try {
            String stateStoreName = request.getStateStoreName();
            List<TransactionalStateOperation<?>> operations = request.getOperations();
            Map<String, String> metadata = request.getMetadata();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            DaprProtos.ExecuteStateTransactionRequest.Builder builder = DaprProtos.ExecuteStateTransactionRequest.newBuilder();
            builder.setStoreName(stateStoreName);
            if (metadata != null) {
                builder.putAllMetadata(metadata);
            }
            for (TransactionalStateOperation<?> operation : operations) {
                DaprProtos.TransactionalStateOperation.Builder operationBuilder = DaprProtos.TransactionalStateOperation.newBuilder();
                operationBuilder.setOperationType(operation.getOperation().toString().toLowerCase());
                operationBuilder.setRequest(this.buildStateRequest(operation.getRequest()).build());
                builder.addOperations(operationBuilder.build());
            }
            DaprProtos.ExecuteStateTransactionRequest req = builder.build();
            return Mono.deferContextual(context -> this.createMono(it -> DaprClientGrpc.intercept(context, this.asyncStub).executeStateTransaction(req, it))).then();
        }
        catch (Exception e) {
            return DaprException.wrapMono(e);
        }
    }

    @Override
    public Mono<Void> saveBulkState(SaveStateRequest request) {
        try {
            String stateStoreName = request.getStoreName();
            List<State<?>> states = request.getStates();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            DaprProtos.SaveStateRequest.Builder builder = DaprProtos.SaveStateRequest.newBuilder();
            builder.setStoreName(stateStoreName);
            for (State<?> state : states) {
                builder.addStates(this.buildStateRequest(state).build());
            }
            DaprProtos.SaveStateRequest req = builder.build();
            return Mono.deferContextual(context -> this.createMono(it -> DaprClientGrpc.intercept(context, this.asyncStub).saveState(req, it))).then();
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    private <T> CommonProtos.StateItem.Builder buildStateRequest(State<T> state) throws IOException {
        byte[] bytes = this.stateSerializer.serialize(state.getValue());
        CommonProtos.StateItem.Builder stateBuilder = CommonProtos.StateItem.newBuilder();
        if (state.getEtag() != null) {
            stateBuilder.setEtag(CommonProtos.Etag.newBuilder().setValue(state.getEtag()).build());
        }
        if (state.getMetadata() != null) {
            stateBuilder.putAllMetadata(state.getMetadata());
        }
        if (bytes != null) {
            stateBuilder.setValue(ByteString.copyFrom((byte[])bytes));
        }
        stateBuilder.setKey(state.getKey());
        CommonProtos.StateOptions.Builder optionBuilder = null;
        if (state.getOptions() != null) {
            StateOptions options = state.getOptions();
            optionBuilder = CommonProtos.StateOptions.newBuilder();
            if (options.getConcurrency() != null) {
                optionBuilder.setConcurrency(this.getGrpcStateConcurrency(options));
            }
            if (options.getConsistency() != null) {
                optionBuilder.setConsistency(this.getGrpcStateConsistency(options));
            }
        }
        if (optionBuilder != null) {
            stateBuilder.setOptions(optionBuilder.build());
        }
        return stateBuilder;
    }

    @Override
    public Mono<Void> deleteState(DeleteStateRequest request) {
        try {
            String stateStoreName = request.getStateStoreName();
            String key = request.getKey();
            StateOptions options = request.getStateOptions();
            String etag = request.getEtag();
            Map<String, String> metadata = request.getMetadata();
            if (stateStoreName == null || stateStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (key == null || key.trim().isEmpty()) {
                throw new IllegalArgumentException("Key cannot be null or empty.");
            }
            CommonProtos.StateOptions.Builder optionBuilder = null;
            if (options != null) {
                optionBuilder = CommonProtos.StateOptions.newBuilder();
                if (options.getConcurrency() != null) {
                    optionBuilder.setConcurrency(this.getGrpcStateConcurrency(options));
                }
                if (options.getConsistency() != null) {
                    optionBuilder.setConsistency(this.getGrpcStateConsistency(options));
                }
            }
            DaprProtos.DeleteStateRequest.Builder builder = DaprProtos.DeleteStateRequest.newBuilder().setStoreName(stateStoreName).setKey(key);
            if (metadata != null) {
                builder.putAllMetadata(metadata);
            }
            if (etag != null) {
                builder.setEtag(CommonProtos.Etag.newBuilder().setValue(etag).build());
            }
            if (optionBuilder != null) {
                builder.setOptions(optionBuilder.build());
            }
            DaprProtos.DeleteStateRequest req = builder.build();
            return Mono.deferContextual(context -> this.createMono(it -> DaprClientGrpc.intercept(context, this.asyncStub).deleteState(req, it))).then();
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    private <K> DaprProtos.InvokeServiceRequest buildInvokeServiceRequest(HttpExtension httpExtension, String appId, String method, K body) throws IOException {
        if (httpExtension == null) {
            throw new IllegalArgumentException("HttpExtension cannot be null. Use HttpExtension.NONE instead.");
        }
        CommonProtos.InvokeRequest.Builder requestBuilder = CommonProtos.InvokeRequest.newBuilder();
        requestBuilder.setMethod(method);
        if (body != null) {
            byte[] byteRequest = this.objectSerializer.serialize(body);
            Any data = Any.newBuilder().setValue(ByteString.copyFrom((byte[])byteRequest)).build();
            requestBuilder.setData(data);
        } else {
            requestBuilder.setData(Any.newBuilder().build());
        }
        CommonProtos.HTTPExtension.Builder httpExtensionBuilder = CommonProtos.HTTPExtension.newBuilder();
        httpExtensionBuilder.setVerb(CommonProtos.HTTPExtension.Verb.valueOf((String)httpExtension.getMethod().toString())).setQuerystring(httpExtension.encodeQueryString());
        requestBuilder.setHttpExtension(httpExtensionBuilder.build());
        requestBuilder.setContentType(this.objectSerializer.getContentType());
        DaprProtos.InvokeServiceRequest.Builder envelopeBuilder = DaprProtos.InvokeServiceRequest.newBuilder().setId(appId).setMessage(requestBuilder.build());
        return envelopeBuilder.build();
    }

    @Override
    public Mono<Map<String, String>> getSecret(GetSecretRequest request) {
        String secretStoreName = request.getStoreName();
        String key = request.getKey();
        Map<String, String> metadata = request.getMetadata();
        try {
            if (secretStoreName == null || secretStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("Secret store name cannot be null or empty.");
            }
            if (key == null || key.trim().isEmpty()) {
                throw new IllegalArgumentException("Secret key cannot be null or empty.");
            }
        }
        catch (Exception e) {
            return DaprException.wrapMono(e);
        }
        DaprProtos.GetSecretRequest.Builder requestBuilder = DaprProtos.GetSecretRequest.newBuilder().setStoreName(secretStoreName).setKey(key);
        if (metadata != null) {
            requestBuilder.putAllMetadata(metadata);
        }
        DaprProtos.GetSecretRequest req = requestBuilder.build();
        return Mono.deferContextual(context -> this.createMono(it -> DaprClientGrpc.intercept(context, this.asyncStub).getSecret(req, it))).map(DaprProtos.GetSecretResponse::getDataMap);
    }

    @Override
    public Mono<Map<String, Map<String, String>>> getBulkSecret(GetBulkSecretRequest request) {
        try {
            String storeName = request.getStoreName();
            Map<String, String> metadata = request.getMetadata();
            if (storeName == null || storeName.trim().isEmpty()) {
                throw new IllegalArgumentException("Secret store name cannot be null or empty.");
            }
            DaprProtos.GetBulkSecretRequest.Builder builder = DaprProtos.GetBulkSecretRequest.newBuilder().setStoreName(storeName);
            if (metadata != null) {
                builder.putAllMetadata(metadata);
            }
            DaprProtos.GetBulkSecretRequest envelope = builder.build();
            return Mono.deferContextual(context -> this.createMono(it -> DaprClientGrpc.intercept(context, this.asyncStub).getBulkSecret(envelope, it))).map(it -> {
                Map secretsMap = it.getDataMap();
                if (secretsMap == null) {
                    return Collections.emptyMap();
                }
                return secretsMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, s -> ((DaprProtos.SecretResponse)s.getValue()).getSecretsMap()));
            });
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    @Override
    public <T> Mono<QueryStateResponse<T>> queryState(QueryStateRequest request, TypeRef<T> type) {
        try {
            String queryString;
            if (request == null) {
                throw new IllegalArgumentException("Query state request cannot be null.");
            }
            String storeName = request.getStoreName();
            Map<String, String> metadata = request.getMetadata();
            if (storeName == null || storeName.trim().isEmpty()) {
                throw new IllegalArgumentException("State store name cannot be null or empty.");
            }
            if (request.getQuery() != null) {
                queryString = JSON_REQUEST_MAPPER.writeValueAsString((Object)request.getQuery());
            } else if (request.getQueryString() != null) {
                queryString = request.getQueryString();
            } else {
                throw new IllegalArgumentException("Both query and queryString fields are not set.");
            }
            DaprProtos.QueryStateRequest.Builder builder = DaprProtos.QueryStateRequest.newBuilder().setStoreName(storeName).setQuery(queryString);
            if (metadata != null) {
                builder.putAllMetadata(metadata);
            }
            DaprProtos.QueryStateRequest envelope = builder.build();
            return Mono.deferContextual(context -> this.createMono(it -> DaprClientGrpc.intercept(context, this.asyncStub).queryStateAlpha1(envelope, it))).map(it -> {
                Map resultMeta = it.getMetadataMap();
                String token = it.getToken();
                List res = it.getResultsList().stream().map(v -> {
                    try {
                        return this.buildQueryStateKeyValue((DaprProtos.QueryStateItem)v, type);
                    }
                    catch (Exception e) {
                        throw DaprException.propagate(e);
                    }
                }).collect(Collectors.toList());
                return new QueryStateResponse(res, token).setMetadata(metadata);
            });
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    private <T> QueryStateItem<T> buildQueryStateKeyValue(DaprProtos.QueryStateItem item, TypeRef<T> type) throws IOException {
        String key = item.getKey();
        String error = item.getError();
        if (!Strings.isNullOrEmpty((String)error)) {
            return new QueryStateItem(key, null, error);
        }
        ByteString payload = item.getData();
        byte[] data = payload == null ? null : payload.toByteArray();
        T value = this.stateSerializer.deserialize(data, type);
        String etag = item.getEtag();
        if (etag.equals("")) {
            etag = null;
        }
        return new QueryStateItem<T>(key, value, etag);
    }

    @Override
    public void close() throws Exception {
        if (this.channel != null) {
            DaprException.wrap(() -> {
                this.channel.close();
                return true;
            }).call();
        }
    }

    @Override
    public Mono<Void> shutdown() {
        return Mono.deferContextual(context -> this.createMono(it -> DaprClientGrpc.intercept(context, this.asyncStub).shutdown(Empty.getDefaultInstance(), it))).then();
    }

    @Override
    public Mono<Map<String, ConfigurationItem>> getConfiguration(GetConfigurationRequest request) {
        try {
            String configurationStoreName = request.getStoreName();
            Map<String, String> metadata = request.getMetadata();
            List<String> keys = request.getKeys();
            if (configurationStoreName == null || configurationStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("Configuration Store Name cannot be null or empty.");
            }
            DaprProtos.GetConfigurationRequest.Builder builder = DaprProtos.GetConfigurationRequest.newBuilder().setStoreName(configurationStoreName).addAllKeys(keys);
            if (metadata != null) {
                builder.putAllMetadata(metadata);
            }
            DaprProtos.GetConfigurationRequest envelope = builder.build();
            return this.getConfiguration(envelope);
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    private Mono<Map<String, ConfigurationItem>> getConfiguration(DaprProtos.GetConfigurationRequest envelope) {
        return Mono.deferContextual(context -> this.createMono(it -> DaprClientGrpc.intercept(context, this.asyncStub).getConfiguration(envelope, it))).map(it -> {
            HashMap<String, ConfigurationItem> configMap = new HashMap<String, ConfigurationItem>();
            for (Map.Entry entry : it.getItems().entrySet()) {
                configMap.put((String)entry.getKey(), this.buildConfigurationItem((CommonProtos.ConfigurationItem)entry.getValue(), (String)entry.getKey()));
            }
            return Collections.unmodifiableMap(configMap);
        });
    }

    @Override
    public Flux<SubscribeConfigurationResponse> subscribeConfiguration(SubscribeConfigurationRequest request) {
        try {
            String configurationStoreName = request.getStoreName();
            List<String> keys = request.getKeys();
            Map<String, String> metadata = request.getMetadata();
            if (configurationStoreName == null || configurationStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("Configuration Store Name can not be null or empty.");
            }
            DaprProtos.SubscribeConfigurationRequest.Builder builder = DaprProtos.SubscribeConfigurationRequest.newBuilder().setStoreName(configurationStoreName).addAllKeys(keys);
            if (metadata != null) {
                builder.putAllMetadata(metadata);
            }
            DaprProtos.SubscribeConfigurationRequest envelope = builder.build();
            return this.createFlux(it -> DaprClientGrpc.intercept(this.asyncStub).subscribeConfiguration(envelope, it)).map(it -> {
                HashMap<String, ConfigurationItem> configMap = new HashMap<String, ConfigurationItem>();
                for (Map.Entry entry : it.getItemsMap().entrySet()) {
                    configMap.put((String)entry.getKey(), this.buildConfigurationItem((CommonProtos.ConfigurationItem)entry.getValue(), (String)entry.getKey()));
                }
                return new SubscribeConfigurationResponse(it.getId(), Collections.unmodifiableMap(configMap));
            });
        }
        catch (Exception ex) {
            return DaprException.wrapFlux(ex);
        }
    }

    @Override
    public Mono<UnsubscribeConfigurationResponse> unsubscribeConfiguration(UnsubscribeConfigurationRequest request) {
        try {
            String configurationStoreName = request.getStoreName();
            String id = request.getSubscriptionId();
            if (configurationStoreName == null || configurationStoreName.trim().isEmpty()) {
                throw new IllegalArgumentException("Configuration Store Name can not be null or empty.");
            }
            if (id.isEmpty()) {
                throw new IllegalArgumentException("Subscription id can not be null or empty.");
            }
            DaprProtos.UnsubscribeConfigurationRequest.Builder builder = DaprProtos.UnsubscribeConfigurationRequest.newBuilder().setId(id).setStoreName(configurationStoreName);
            DaprProtos.UnsubscribeConfigurationRequest envelope = builder.build();
            return this.createMono(it -> DaprClientGrpc.intercept(this.asyncStub).unsubscribeConfiguration(envelope, it)).map(it -> new UnsubscribeConfigurationResponse(it.getOk(), it.getMessage()));
        }
        catch (Exception ex) {
            return DaprException.wrapMono(ex);
        }
    }

    private ConfigurationItem buildConfigurationItem(CommonProtos.ConfigurationItem configurationItem, String key) {
        return new ConfigurationItem(key, configurationItem.getValue(), configurationItem.getVersion(), configurationItem.getMetadataMap());
    }

    private static DaprGrpc.DaprStub intercept(DaprGrpc.DaprStub client) {
        ClientInterceptor interceptor = new ClientInterceptor(){

            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
                ClientCall clientCall = channel.newCall(methodDescriptor, callOptions);
                return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(clientCall){

                    public void start(ClientCall.Listener<RespT> responseListener, Metadata metadata) {
                        String daprApiToken = Properties.API_TOKEN.get();
                        if (daprApiToken != null) {
                            metadata.put(Metadata.Key.of((String)"dapr-api-token", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)daprApiToken);
                        }
                        super.start(responseListener, metadata);
                    }
                };
            }
        };
        return (DaprGrpc.DaprStub)client.withInterceptors(new ClientInterceptor[]{interceptor});
    }

    private static DaprGrpc.DaprStub intercept(ContextView context, DaprGrpc.DaprStub client) {
        return GrpcWrapper.intercept(context, client);
    }

    private <T> Mono<T> createMono(Consumer<StreamObserver<T>> consumer) {
        return Mono.create(sink -> DaprException.wrap(() -> consumer.accept(this.createStreamObserver((MonoSink)sink))).run());
    }

    private <T> Flux<T> createFlux(Consumer<StreamObserver<T>> consumer) {
        return Flux.create(sink -> DaprException.wrap(() -> consumer.accept(this.createStreamObserver((FluxSink)sink))).run());
    }

    private <T> StreamObserver<T> createStreamObserver(final MonoSink<T> sink) {
        return new StreamObserver<T>(){

            public void onNext(T value) {
                sink.success(value);
            }

            public void onError(Throwable t) {
                sink.error((Throwable)DaprException.propagate(new ExecutionException(t)));
            }

            public void onCompleted() {
                sink.success();
            }
        };
    }

    private <T> StreamObserver<T> createStreamObserver(final FluxSink<T> sink) {
        return new StreamObserver<T>(){

            public void onNext(T value) {
                sink.next(value);
            }

            public void onError(Throwable t) {
                sink.error((Throwable)DaprException.propagate(new ExecutionException(t)));
            }

            public void onCompleted() {
                sink.complete();
            }
        };
    }
}

