/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.utils;

import java.time.Duration;

public class DurationUtils {
    public static Duration convertDurationFromDaprFormat(String valueString) {
        int secondIndex;
        if (valueString == null) {
            throw new IllegalArgumentException("duration string cannot be null");
        }
        Duration parsedDuration = Duration.ZERO;
        int hourIndex = valueString.indexOf(104);
        int minuteIndex = valueString.indexOf(109);
        if (minuteIndex != -1 && valueString.length() > minuteIndex + 1 && valueString.charAt(minuteIndex + 1) == 's') {
            minuteIndex = -1;
        }
        if ((secondIndex = valueString.indexOf(115)) != -1 && valueString.charAt(secondIndex - 1) == 'm') {
            secondIndex = -1;
        }
        int milliIndex = valueString.indexOf("ms");
        if (hourIndex != -1) {
            String hoursSpan = valueString.substring(0, hourIndex);
            int hours = Integer.parseInt(hoursSpan);
            int days = hours / 24;
            parsedDuration = parsedDuration.plusDays(days).plusHours(hours %= 24);
        }
        if (minuteIndex != -1) {
            String minutesSpan = valueString.substring(hourIndex + 1, minuteIndex);
            int minutes = Integer.parseInt(minutesSpan);
            parsedDuration = parsedDuration.plusMinutes(minutes);
        }
        if (secondIndex != -1) {
            String secondsSpan = valueString.substring(minuteIndex + 1, secondIndex);
            int seconds = Integer.parseInt(secondsSpan);
            parsedDuration = parsedDuration.plusSeconds(seconds);
        }
        if (milliIndex != -1) {
            String millisecondsSpan = valueString.substring(secondIndex + 1, milliIndex);
            int milliseconds = Integer.parseInt(millisecondsSpan);
            parsedDuration = parsedDuration.plusMillis(milliseconds);
        }
        return parsedDuration;
    }

    public static String convertDurationToDaprFormat(Duration value) {
        String stringValue = "";
        if (value == Duration.ZERO || value.compareTo(Duration.ZERO) > 0) {
            long hours = DurationUtils.getDaysPart(value) * 24L + DurationUtils.getHoursPart(value);
            StringBuilder sb = new StringBuilder();
            sb.append(hours);
            sb.append("h");
            sb.append(DurationUtils.getMinutesPart(value));
            sb.append("m");
            sb.append(DurationUtils.getSecondsPart(value));
            sb.append("s");
            sb.append(DurationUtils.getMilliSecondsPart(value));
            sb.append("ms");
            return sb.toString();
        }
        return stringValue;
    }

    static long getDaysPart(Duration d) {
        long t = d.getSeconds() / 60L / 60L / 24L;
        return t;
    }

    static long getHoursPart(Duration d) {
        long u = d.getSeconds() / 60L / 60L % 24L;
        return u;
    }

    static long getMinutesPart(Duration d) {
        long u = d.getSeconds() / 60L % 60L;
        return u;
    }

    static long getSecondsPart(Duration d) {
        long u = d.getSeconds() % 60L;
        return u;
    }

    static long getMilliSecondsPart(Duration d) {
        long u = d.toMillis() % 1000L;
        return u;
    }
}

