/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.durabletask;

import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nullable;

public interface DataConverter {
    @Nullable
    public String serialize(@Nullable Object var1);

    @Nullable
    public <T> T deserialize(@Nullable String var1, Class<T> var2);

    public static Instant getInstantFromTimestamp(Timestamp ts) {
        if (ts == null) {
            return null;
        }
        return Instant.ofEpochSecond(ts.getSeconds(), ts.getNanos()).truncatedTo(ChronoUnit.MILLIS);
    }

    public static Timestamp getTimestampFromInstant(Instant instant) {
        if (instant == null) {
            return null;
        }
        return Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
    }

    public static class DataConverterException
    extends RuntimeException {
        public DataConverterException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

