/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.durabletask;

import com.google.protobuf.StringValue;
import com.google.protobuf.Timestamp;
import io.dapr.durabletask.DataConverter;
import io.dapr.durabletask.DurableTaskClient;
import io.dapr.durabletask.DurableTaskGrpcClientBuilder;
import io.dapr.durabletask.Helpers;
import io.dapr.durabletask.JacksonDataConverter;
import io.dapr.durabletask.NewOrchestrationInstanceOptions;
import io.dapr.durabletask.OrchestrationMetadata;
import io.dapr.durabletask.OrchestrationRuntimeStatus;
import io.dapr.durabletask.OrchestrationStatusQuery;
import io.dapr.durabletask.OrchestrationStatusQueryResult;
import io.dapr.durabletask.PurgeInstanceCriteria;
import io.dapr.durabletask.PurgeResult;
import io.dapr.durabletask.implementation.protobuf.OrchestratorService;
import io.dapr.durabletask.implementation.protobuf.TaskHubSidecarServiceGrpc;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.TlsChannelCredentials;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class DurableTaskGrpcClient
extends DurableTaskClient {
    private static final int DEFAULT_PORT = 4001;
    private static final Logger logger = Logger.getLogger(DurableTaskGrpcClient.class.getPackage().getName());
    private static final String GRPC_TLS_CA_PATH = "DAPR_GRPC_TLS_CA_PATH";
    private static final String GRPC_TLS_CERT_PATH = "DAPR_GRPC_TLS_CERT_PATH";
    private static final String GRPC_TLS_KEY_PATH = "DAPR_GRPC_TLS_KEY_PATH";
    private static final String GRPC_TLS_INSECURE = "DAPR_GRPC_TLS_INSECURE";
    private final DataConverter dataConverter;
    private final ManagedChannel managedSidecarChannel;
    private final TaskHubSidecarServiceGrpc.TaskHubSidecarServiceBlockingStub sidecarClient;

    DurableTaskGrpcClient(DurableTaskGrpcClientBuilder builder) {
        Channel sidecarGrpcChannel;
        DataConverter dataConverter = this.dataConverter = builder.dataConverter != null ? builder.dataConverter : new JacksonDataConverter();
        if (builder.channel != null) {
            this.managedSidecarChannel = null;
            sidecarGrpcChannel = builder.channel;
        } else {
            ManagedChannelBuilder channelBuilder;
            block61: {
                boolean insecure;
                int port = 4001;
                if (builder.port > 0) {
                    port = builder.port;
                }
                String endpoint = "localhost:" + port;
                String tlsCaPath = builder.tlsCaPath != null ? builder.tlsCaPath : System.getenv(GRPC_TLS_CA_PATH);
                String tlsCertPath = builder.tlsCertPath != null ? builder.tlsCertPath : System.getenv(GRPC_TLS_CERT_PATH);
                String tlsKeyPath = builder.tlsKeyPath != null ? builder.tlsKeyPath : System.getenv(GRPC_TLS_KEY_PATH);
                boolean bl = insecure = builder.insecure || Boolean.parseBoolean(System.getenv(GRPC_TLS_INSECURE));
                if (insecure) {
                    try {
                        channelBuilder = NettyChannelBuilder.forTarget((String)endpoint).sslContext(GrpcSslContexts.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to create insecure TLS credentials", e);
                    }
                }
                if (tlsCertPath != null && tlsKeyPath != null) {
                    try (FileInputStream clientCertInputStream = new FileInputStream(tlsCertPath);
                         FileInputStream clientKeyInputStream = new FileInputStream(tlsKeyPath);
                         FileInputStream caCertInputStream = tlsCaPath != null ? new FileInputStream(tlsCaPath) : null;){
                        TlsChannelCredentials.Builder tlsBuilder = TlsChannelCredentials.newBuilder().keyManager((InputStream)clientCertInputStream, (InputStream)clientKeyInputStream);
                        if (caCertInputStream != null) {
                            tlsBuilder.trustManager((InputStream)caCertInputStream);
                        }
                        ChannelCredentials credentials = tlsBuilder.build();
                        channelBuilder = Grpc.newChannelBuilder((String)endpoint, (ChannelCredentials)credentials);
                        break block61;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to create mTLS credentials" + (tlsCaPath != null ? " with CA cert" : ""), e);
                    }
                }
                if (tlsCaPath != null) {
                    try (FileInputStream caCertInputStream = new FileInputStream(tlsCaPath);){
                        ChannelCredentials credentials = TlsChannelCredentials.newBuilder().trustManager((InputStream)caCertInputStream).build();
                        channelBuilder = Grpc.newChannelBuilder((String)endpoint, (ChannelCredentials)credentials);
                        break block61;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to create TLS credentials with CA cert", e);
                    }
                }
                channelBuilder = ManagedChannelBuilder.forTarget((String)endpoint).usePlaintext();
            }
            this.managedSidecarChannel = channelBuilder.build();
            sidecarGrpcChannel = this.managedSidecarChannel;
        }
        this.sidecarClient = TaskHubSidecarServiceGrpc.newBlockingStub(sidecarGrpcChannel);
    }

    @Override
    public void close() {
        if (this.managedSidecarChannel != null) {
            try {
                this.managedSidecarChannel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public String scheduleNewOrchestrationInstance(String orchestratorName, NewOrchestrationInstanceOptions options) {
        Instant startTime;
        Object input;
        if (orchestratorName == null || orchestratorName.length() == 0) {
            throw new IllegalArgumentException("A non-empty orchestrator name must be specified.");
        }
        Helpers.throwIfArgumentNull(options, "options");
        OrchestratorService.CreateInstanceRequest.Builder builder = OrchestratorService.CreateInstanceRequest.newBuilder();
        builder.setName(orchestratorName);
        String instanceId = options.getInstanceId();
        if (instanceId == null) {
            instanceId = UUID.randomUUID().toString();
        }
        builder.setInstanceId(instanceId);
        String version = options.getVersion();
        if (version != null) {
            builder.setVersion(StringValue.of((String)version));
        }
        if ((input = options.getInput()) != null) {
            String serializedInput = this.dataConverter.serialize(input);
            builder.setInput(StringValue.of((String)serializedInput));
        }
        if ((startTime = options.getStartTime()) != null) {
            Timestamp ts = DataConverter.getTimestampFromInstant(startTime);
            builder.setScheduledStartTimestamp(ts);
        }
        OrchestratorService.CreateInstanceRequest request = builder.build();
        OrchestratorService.CreateInstanceResponse response = this.sidecarClient.startInstance(request);
        return response.getInstanceId();
    }

    @Override
    public void raiseEvent(String instanceId, String eventName, Object eventPayload) {
        Helpers.throwIfArgumentNull(instanceId, "instanceId");
        Helpers.throwIfArgumentNull(eventName, "eventName");
        OrchestratorService.RaiseEventRequest.Builder builder = OrchestratorService.RaiseEventRequest.newBuilder().setInstanceId(instanceId).setName(eventName);
        if (eventPayload != null) {
            String serializedPayload = this.dataConverter.serialize(eventPayload);
            builder.setInput(StringValue.of((String)serializedPayload));
        }
        OrchestratorService.RaiseEventRequest request = builder.build();
        this.sidecarClient.raiseEvent(request);
    }

    @Override
    public OrchestrationMetadata getInstanceMetadata(String instanceId, boolean getInputsAndOutputs) {
        OrchestratorService.GetInstanceRequest request = OrchestratorService.GetInstanceRequest.newBuilder().setInstanceId(instanceId).setGetInputsAndOutputs(getInputsAndOutputs).build();
        OrchestratorService.GetInstanceResponse response = this.sidecarClient.getInstance(request);
        return new OrchestrationMetadata(response, this.dataConverter, request.getGetInputsAndOutputs());
    }

    @Override
    public OrchestrationMetadata waitForInstanceStart(String instanceId, Duration timeout, boolean getInputsAndOutputs) throws TimeoutException {
        OrchestratorService.GetInstanceResponse response;
        OrchestratorService.GetInstanceRequest request = OrchestratorService.GetInstanceRequest.newBuilder().setInstanceId(instanceId).setGetInputsAndOutputs(getInputsAndOutputs).build();
        if (timeout == null || timeout.isNegative() || timeout.isZero()) {
            timeout = Duration.ofMinutes(10L);
        }
        TaskHubSidecarServiceGrpc.TaskHubSidecarServiceBlockingStub grpcClient = (TaskHubSidecarServiceGrpc.TaskHubSidecarServiceBlockingStub)this.sidecarClient.withDeadlineAfter(timeout.toMillis(), TimeUnit.MILLISECONDS);
        try {
            response = grpcClient.waitForInstanceStart(request);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.DEADLINE_EXCEEDED) {
                throw new TimeoutException("Start orchestration timeout reached.");
            }
            throw e;
        }
        return new OrchestrationMetadata(response, this.dataConverter, request.getGetInputsAndOutputs());
    }

    @Override
    public OrchestrationMetadata waitForInstanceCompletion(String instanceId, Duration timeout, boolean getInputsAndOutputs) throws TimeoutException {
        OrchestratorService.GetInstanceResponse response;
        OrchestratorService.GetInstanceRequest request = OrchestratorService.GetInstanceRequest.newBuilder().setInstanceId(instanceId).setGetInputsAndOutputs(getInputsAndOutputs).build();
        if (timeout == null || timeout.isNegative() || timeout.isZero()) {
            timeout = Duration.ofMinutes(10L);
        }
        TaskHubSidecarServiceGrpc.TaskHubSidecarServiceBlockingStub grpcClient = (TaskHubSidecarServiceGrpc.TaskHubSidecarServiceBlockingStub)this.sidecarClient.withDeadlineAfter(timeout.toMillis(), TimeUnit.MILLISECONDS);
        try {
            response = grpcClient.waitForInstanceCompletion(request);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.DEADLINE_EXCEEDED) {
                throw new TimeoutException("Orchestration instance completion timeout reached.");
            }
            throw e;
        }
        return new OrchestrationMetadata(response, this.dataConverter, request.getGetInputsAndOutputs());
    }

    @Override
    public void terminate(String instanceId, @Nullable Object output) {
        Helpers.throwIfArgumentNull(instanceId, "instanceId");
        String serializeOutput = this.dataConverter.serialize(output);
        logger.fine(() -> String.format("Terminating instance %s and setting output to: %s", instanceId, serializeOutput != null ? serializeOutput : "(null)"));
        OrchestratorService.TerminateRequest.Builder builder = OrchestratorService.TerminateRequest.newBuilder().setInstanceId(instanceId);
        if (serializeOutput != null) {
            builder.setOutput(StringValue.of((String)serializeOutput));
        }
        this.sidecarClient.terminateInstance(builder.build());
    }

    @Override
    public OrchestrationStatusQueryResult queryInstances(OrchestrationStatusQuery query) {
        OrchestratorService.InstanceQuery.Builder instanceQueryBuilder = OrchestratorService.InstanceQuery.newBuilder();
        Optional.ofNullable(query.getCreatedTimeFrom()).ifPresent(createdTimeFrom -> instanceQueryBuilder.setCreatedTimeFrom(DataConverter.getTimestampFromInstant(createdTimeFrom)));
        Optional.ofNullable(query.getCreatedTimeTo()).ifPresent(createdTimeTo -> instanceQueryBuilder.setCreatedTimeTo(DataConverter.getTimestampFromInstant(createdTimeTo)));
        Optional.ofNullable(query.getContinuationToken()).ifPresent(token -> instanceQueryBuilder.setContinuationToken(StringValue.of((String)token)));
        Optional.ofNullable(query.getInstanceIdPrefix()).ifPresent(prefix -> instanceQueryBuilder.setInstanceIdPrefix(StringValue.of((String)prefix)));
        instanceQueryBuilder.setFetchInputsAndOutputs(query.isFetchInputsAndOutputs());
        instanceQueryBuilder.setMaxInstanceCount(query.getMaxInstanceCount());
        query.getRuntimeStatusList().forEach(runtimeStatus -> Optional.ofNullable(runtimeStatus).ifPresent(status -> instanceQueryBuilder.addRuntimeStatus(OrchestrationRuntimeStatus.toProtobuf(status))));
        query.getTaskHubNames().forEach(taskHubName -> Optional.ofNullable(taskHubName).ifPresent(name -> instanceQueryBuilder.addTaskHubNames(StringValue.of((String)name))));
        OrchestratorService.QueryInstancesResponse queryInstancesResponse = this.sidecarClient.queryInstances(OrchestratorService.QueryInstancesRequest.newBuilder().setQuery(instanceQueryBuilder).build());
        return this.toQueryResult(queryInstancesResponse, query.isFetchInputsAndOutputs());
    }

    private OrchestrationStatusQueryResult toQueryResult(OrchestratorService.QueryInstancesResponse queryInstancesResponse, boolean fetchInputsAndOutputs) {
        ArrayList<OrchestrationMetadata> metadataList = new ArrayList<OrchestrationMetadata>();
        queryInstancesResponse.getOrchestrationStateList().forEach(state -> metadataList.add(new OrchestrationMetadata((OrchestratorService.OrchestrationState)state, this.dataConverter, fetchInputsAndOutputs)));
        return new OrchestrationStatusQueryResult(metadataList, queryInstancesResponse.getContinuationToken().getValue());
    }

    @Override
    public void createTaskHub(boolean recreateIfExists) {
        this.sidecarClient.createTaskHub(OrchestratorService.CreateTaskHubRequest.newBuilder().setRecreateIfExists(recreateIfExists).build());
    }

    @Override
    public void deleteTaskHub() {
        this.sidecarClient.deleteTaskHub(OrchestratorService.DeleteTaskHubRequest.newBuilder().build());
    }

    @Override
    public PurgeResult purgeInstance(String instanceId) {
        OrchestratorService.PurgeInstancesRequest request = OrchestratorService.PurgeInstancesRequest.newBuilder().setInstanceId(instanceId).build();
        OrchestratorService.PurgeInstancesResponse response = this.sidecarClient.purgeInstances(request);
        return this.toPurgeResult(response);
    }

    @Override
    public PurgeResult purgeInstances(PurgeInstanceCriteria purgeInstanceCriteria) throws TimeoutException {
        OrchestratorService.PurgeInstanceFilter.Builder builder = OrchestratorService.PurgeInstanceFilter.newBuilder();
        builder.setCreatedTimeFrom(DataConverter.getTimestampFromInstant(purgeInstanceCriteria.getCreatedTimeFrom()));
        Optional.ofNullable(purgeInstanceCriteria.getCreatedTimeTo()).ifPresent(createdTimeTo -> builder.setCreatedTimeTo(DataConverter.getTimestampFromInstant(createdTimeTo)));
        purgeInstanceCriteria.getRuntimeStatusList().forEach(runtimeStatus -> Optional.ofNullable(runtimeStatus).ifPresent(status -> builder.addRuntimeStatus(OrchestrationRuntimeStatus.toProtobuf(status))));
        Duration timeout = purgeInstanceCriteria.getTimeout();
        if (timeout == null || timeout.isNegative() || timeout.isZero()) {
            timeout = Duration.ofMinutes(4L);
        }
        TaskHubSidecarServiceGrpc.TaskHubSidecarServiceBlockingStub grpcClient = (TaskHubSidecarServiceGrpc.TaskHubSidecarServiceBlockingStub)this.sidecarClient.withDeadlineAfter(timeout.toMillis(), TimeUnit.MILLISECONDS);
        try {
            OrchestratorService.PurgeInstancesResponse response = grpcClient.purgeInstances(OrchestratorService.PurgeInstancesRequest.newBuilder().setPurgeInstanceFilter(builder).build());
            return this.toPurgeResult(response);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.Code.DEADLINE_EXCEEDED) {
                String timeOutException = String.format("Purge instances timeout duration of %s reached.", timeout);
                throw new TimeoutException(timeOutException);
            }
            throw e;
        }
    }

    @Override
    public void suspendInstance(String instanceId, @Nullable String reason) {
        OrchestratorService.SuspendRequest.Builder suspendRequestBuilder = OrchestratorService.SuspendRequest.newBuilder();
        suspendRequestBuilder.setInstanceId(instanceId);
        if (reason != null) {
            suspendRequestBuilder.setReason(StringValue.of((String)reason));
        }
        this.sidecarClient.suspendInstance(suspendRequestBuilder.build());
    }

    @Override
    public void resumeInstance(String instanceId, @Nullable String reason) {
        OrchestratorService.ResumeRequest.Builder resumeRequestBuilder = OrchestratorService.ResumeRequest.newBuilder();
        resumeRequestBuilder.setInstanceId(instanceId);
        if (reason != null) {
            resumeRequestBuilder.setReason(StringValue.of((String)reason));
        }
        this.sidecarClient.resumeInstance(resumeRequestBuilder.build());
    }

    @Override
    public String restartInstance(String instanceId, boolean restartWithNewInstanceId) {
        OrchestrationMetadata metadata = this.getInstanceMetadata(instanceId, true);
        if (!metadata.isInstanceFound()) {
            throw new IllegalArgumentException("An orchestration with instanceId " + instanceId + " was not found.");
        }
        if (restartWithNewInstanceId) {
            return this.scheduleNewOrchestrationInstance(metadata.getName(), this.dataConverter.deserialize(metadata.getSerializedInput(), Object.class));
        }
        return this.scheduleNewOrchestrationInstance(metadata.getName(), this.dataConverter.deserialize(metadata.getSerializedInput(), Object.class), metadata.getInstanceId());
    }

    private PurgeResult toPurgeResult(OrchestratorService.PurgeInstancesResponse response) {
        return new PurgeResult(response.getDeletedInstanceCount());
    }
}

