/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.durabletask;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.StringValue;
import io.dapr.durabletask.JacksonDataConverter;
import io.dapr.durabletask.OrchestratorFunction;
import io.dapr.durabletask.TaskOrchestration;
import io.dapr.durabletask.TaskOrchestrationExecutor;
import io.dapr.durabletask.TaskOrchestrationFactory;
import io.dapr.durabletask.TaskOrchestratorResult;
import io.dapr.durabletask.implementation.protobuf.OrchestratorService;
import java.time.Duration;
import java.util.Base64;
import java.util.HashMap;
import java.util.logging.Logger;

public final class OrchestrationRunner {
    private static final Logger logger = Logger.getLogger(OrchestrationRunner.class.getPackage().getName());
    private static final Duration DEFAULT_MAXIMUM_TIMER_INTERVAL = Duration.ofDays(3L);

    private OrchestrationRunner() {
    }

    public static <R> String loadAndRun(String base64EncodedOrchestratorRequest, OrchestratorFunction<R> orchestratorFunc) {
        byte[] decodedBytes = Base64.getDecoder().decode(base64EncodedOrchestratorRequest);
        byte[] resultBytes = OrchestrationRunner.loadAndRun(decodedBytes, orchestratorFunc);
        return Base64.getEncoder().encodeToString(resultBytes);
    }

    public static <R> byte[] loadAndRun(byte[] orchestratorRequestBytes, OrchestratorFunction<R> orchestratorFunc) {
        if (orchestratorFunc == null) {
            throw new IllegalArgumentException("orchestratorFunc must not be null");
        }
        TaskOrchestration orchestration = ctx -> {
            Object output = orchestratorFunc.apply(ctx);
            ctx.complete(output);
        };
        return OrchestrationRunner.loadAndRun(orchestratorRequestBytes, orchestration);
    }

    public static String loadAndRun(String base64EncodedOrchestratorRequest, TaskOrchestration orchestration) {
        byte[] decodedBytes = Base64.getDecoder().decode(base64EncodedOrchestratorRequest);
        byte[] resultBytes = OrchestrationRunner.loadAndRun(decodedBytes, orchestration);
        return Base64.getEncoder().encodeToString(resultBytes);
    }

    public static byte[] loadAndRun(byte[] orchestratorRequestBytes, final TaskOrchestration orchestration) {
        OrchestratorService.OrchestratorRequest orchestratorRequest;
        if (orchestratorRequestBytes == null || orchestratorRequestBytes.length == 0) {
            throw new IllegalArgumentException("triggerStateProtoBytes must not be null or empty");
        }
        if (orchestration == null) {
            throw new IllegalArgumentException("orchestration must not be null");
        }
        try {
            orchestratorRequest = OrchestratorService.OrchestratorRequest.parseFrom(orchestratorRequestBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("triggerStateProtoBytes was not valid protobuf", e);
        }
        HashMap<String, TaskOrchestrationFactory> orchestrationFactories = new HashMap<String, TaskOrchestrationFactory>();
        orchestrationFactories.put("*", new TaskOrchestrationFactory(){

            @Override
            public String getName() {
                return "*";
            }

            @Override
            public TaskOrchestration create() {
                return orchestration;
            }
        });
        TaskOrchestrationExecutor taskOrchestrationExecutor = new TaskOrchestrationExecutor(orchestrationFactories, new JacksonDataConverter(), DEFAULT_MAXIMUM_TIMER_INTERVAL, logger);
        TaskOrchestratorResult taskOrchestratorResult = taskOrchestrationExecutor.execute(orchestratorRequest.getPastEventsList(), orchestratorRequest.getNewEventsList());
        OrchestratorService.OrchestratorResponse response = OrchestratorService.OrchestratorResponse.newBuilder().setInstanceId(orchestratorRequest.getInstanceId()).addAllActions(taskOrchestratorResult.getActions()).setCustomStatus(StringValue.of((String)taskOrchestratorResult.getCustomStatus())).build();
        return response.toByteArray();
    }
}

