/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.durabletask;

import io.dapr.durabletask.Task;
import io.dapr.durabletask.TaskCanceledException;
import io.dapr.durabletask.TaskOptions;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;

public interface TaskOrchestrationContext {
    public String getName();

    public <V> V getInput(Class<V> var1);

    public String getInstanceId();

    public Instant getCurrentInstant();

    public boolean getIsReplaying();

    public <V> Task<List<V>> allOf(List<Task<V>> var1);

    default public <V> Task<List<V>> allOf(Task<V> ... tasks) {
        return this.allOf(Arrays.asList(tasks));
    }

    public Task<Task<?>> anyOf(List<Task<?>> var1);

    default public Task<Task<?>> anyOf(Task<?> ... tasks) {
        return this.anyOf(Arrays.asList(tasks));
    }

    public Task<Void> createTimer(Duration var1);

    default public Task<Void> createTimer(ZonedDateTime zonedDateTime) {
        throw new UnsupportedOperationException("This method is not implemented. Please use an orchestration context class that has an implementation for this method.");
    }

    public void complete(Object var1);

    public <V> Task<V> callActivity(String var1, Object var2, TaskOptions var3, Class<V> var4);

    default public Task<Void> callActivity(String name) {
        return this.callActivity(name, Void.class);
    }

    default public Task<Void> callActivity(String name, Object input) {
        return this.callActivity(name, input, null, Void.class);
    }

    default public <V> Task<V> callActivity(String name, Class<V> returnType) {
        return this.callActivity(name, null, null, returnType);
    }

    default public <V> Task<V> callActivity(String name, Object input, Class<V> returnType) {
        return this.callActivity(name, input, null, returnType);
    }

    default public Task<Void> callActivity(String name, Object input, TaskOptions options) {
        return this.callActivity(name, input, options, Void.class);
    }

    default public void continueAsNew(Object input) {
        this.continueAsNew(input, true);
    }

    default public UUID newUUID() {
        throw new RuntimeException("No implementation found.");
    }

    public void continueAsNew(Object var1, boolean var2);

    default public void sendEvent(String instanceID, String eventName) {
        this.sendEvent(instanceID, eventName, null);
    }

    public void sendEvent(String var1, String var2, Object var3);

    default public Task<Void> callSubOrchestrator(String name) {
        return this.callSubOrchestrator(name, null);
    }

    default public Task<Void> callSubOrchestrator(String name, Object input) {
        return this.callSubOrchestrator(name, input, null);
    }

    default public <V> Task<V> callSubOrchestrator(String name, Object input, Class<V> returnType) {
        return this.callSubOrchestrator(name, input, null, returnType);
    }

    default public <V> Task<V> callSubOrchestrator(String name, Object input, String instanceID, Class<V> returnType) {
        return this.callSubOrchestrator(name, input, instanceID, null, returnType);
    }

    default public Task<Void> callSubOrchestrator(String name, Object input, String instanceID, TaskOptions options) {
        return this.callSubOrchestrator(name, input, instanceID, options, Void.class);
    }

    public <V> Task<V> callSubOrchestrator(String var1, @Nullable Object var2, @Nullable String var3, @Nullable TaskOptions var4, Class<V> var5);

    public <V> Task<V> waitForExternalEvent(String var1, Duration var2, Class<V> var3) throws TaskCanceledException;

    default public Task<Void> waitForExternalEvent(String name, Duration timeout) throws TaskCanceledException {
        return this.waitForExternalEvent(name, timeout, Void.class);
    }

    default public Task<Void> waitForExternalEvent(String name) {
        return this.waitForExternalEvent(name, Void.class);
    }

    default public <V> Task<V> waitForExternalEvent(String name, Class<V> dataType) {
        try {
            return this.waitForExternalEvent(name, null, dataType);
        }
        catch (TaskCanceledException e) {
            throw new RuntimeException("An unexpected exception was throw while waiting for an external event.", e);
        }
    }

    public void setCustomStatus(Object var1);

    public void clearCustomStatus();
}

