/*
 * Decompiled with CFR 0.152.
 */
package io.dataease.plugins.template;

import io.dataease.exception.DEException;
import io.dataease.license.utils.JsonUtil;
import io.dataease.plugins.vo.DataEasePluginVO;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public interface DataEasePlugin {
    default public String readPluginInfo() throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL[] urls = ((URLClassLoader)classLoader).getURLs();
        String jarPath = urls[0].getPath();
        JarFile jarFile = new JarFile(jarPath);
        Enumeration<JarEntry> entries = jarFile.entries();
        boolean pluginInfoMatch = false;
        String pluginIconName = null;
        String resultJson = null;
        Map map = null;
        while (entries.hasMoreElements()) {
            Object moduleName;
            String regex;
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            boolean isPluginJson = name.matches(regex = "^plugin/extensions.*\\.json$");
            if (!isPluginJson) continue;
            pluginInfoMatch = true;
            resultJson = new String(classLoader.getResourceAsStream(name).readAllBytes(), StandardCharsets.UTF_8);
            map = JsonUtil.parseObject(resultJson, Map.class);
            if (ObjectUtils.isEmpty((Object)map)) {
                DEException.throwException("\u63d2\u4ef6\u63cf\u8ff0\u6587\u4ef6[extensions-*.json]\u5185\u5bb9\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty(moduleName = map.get("moduleName")) || StringUtils.isBlank((CharSequence)moduleName.toString())) {
                DEException.throwException("\u63d2\u4ef6\u63cf\u8ff0\u6587\u4ef6[extensions-*.json]\u4e2d\u7f3a\u5931moduleName\u63cf\u8ff0");
            }
            pluginIconName = moduleName.toString();
            break;
        }
        if (!pluginInfoMatch) {
            DEException.throwException("\u63d2\u4ef6\u7f3a\u5931\u63cf\u8ff0\u6587\u4ef6[extensions-*.json]");
        }
        String iconPath = String.format("plugin/%s.svg", pluginIconName);
        InputStream resourceAsStream = classLoader.getResourceAsStream(iconPath);
        if (!1.$assertionsDisabled && resourceAsStream == null) {
            throw new AssertionError();
        }
        byte[] bytes = resourceAsStream.readAllBytes();
        String iconContent = new String(bytes, StandardCharsets.UTF_8);
        map.put("icon", iconContent);
        map.put("config", JsonUtil.toJSONString(map.get("config")));
        return JsonUtil.toJSONString(map).toString();
    }

    default public DataEasePluginVO getPluginInfo() throws Exception {
        String s = this.readPluginInfo();
        return JsonUtil.parseObject(s, DataEasePluginVO.class);
    }

    default public InputStream getStaticInfo(String moduleName) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResourceAsStream("static/de2api/" + moduleName + ".js");
    }

    public void loadPlugin();

    public void unloadPlugin();

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

