/*
 * Decompiled with CFR 0.152.
 */
package io.dataease.plugins.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class PluginSpringContextUtil
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public static DefaultListableBeanFactory getBeanFactory() {
        return (DefaultListableBeanFactory)PluginSpringContextUtil.getApplicationContext().getAutowireCapableBeanFactory();
    }

    public static List<Map<String, Object>> getAllBean() {
        String[] beans;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (String beanName : beans = PluginSpringContextUtil.getApplicationContext().getBeanDefinitionNames()) {
            Class beanType = PluginSpringContextUtil.getApplicationContext().getType(beanName);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("BeanName", beanName);
            map.put("beanType", beanType);
            map.put("package", beanType.getPackage());
            list.add(map);
        }
        return list;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        PluginSpringContextUtil.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Object getBean(String name) {
        return PluginSpringContextUtil.getApplicationContext().getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)PluginSpringContextUtil.getApplicationContext().getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)PluginSpringContextUtil.getApplicationContext().getBean(name, clazz);
    }
}

