/*
 * Decompiled with CFR 0.152.
 */
package io.dataease.plugins.common.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.IdUtil;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
public class GlobalFileUtil {
    private static String root;
    private static final String SPLITOR = "-de-";

    @Value(value="${dataease.busiFilePath:/opt/dataease/data/business/}")
    public void setRoot(String root) {
        GlobalFileUtil.root = root;
    }

    public static String upload(byte[] bytes, String suffix) {
        String dateStr = DateUtil.formatDate((Date)new Date());
        String formatRoot = GlobalFileUtil.formatRoot();
        String dirPath = formatRoot + dateStr;
        if (!FileUtil.exist((String)dirPath)) {
            FileUtil.mkdir((String)dirPath);
        }
        String fileId = GlobalFileUtil.fileIdByDate(dateStr);
        String filePath = formatRoot + dateStr + "/" + fileId + "." + suffix;
        FileUtil.writeBytes((byte[])bytes, (String)filePath);
        return fileId;
    }

    public static ResponseEntity<byte[]> showPicture(String fileId) {
        String filePath = GlobalFileUtil.filePathById(fileId, null);
        byte[] bytes = FileUtil.readBytes((String)filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.IMAGE_PNG);
        return new ResponseEntity((Object)bytes, (MultiValueMap)headers, HttpStatus.OK);
    }

    public static ResponseEntity<ByteArrayResource> down(String fileId, String fileName) throws Exception {
        String suffix = FileUtil.getSuffix((String)fileName);
        String filePath = GlobalFileUtil.filePathById(fileId, suffix);
        byte[] bytes = FileUtil.readBytes((String)filePath);
        ByteArrayResource bar = new ByteArrayResource(bytes);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        ContentDisposition contentDisposition = ContentDisposition.parse((String)("attachment; filename=" + URLEncoder.encode(fileName, "UTF-8")));
        headers.setContentDisposition(contentDisposition);
        return new ResponseEntity((Object)bar, (MultiValueMap)headers, HttpStatus.OK);
    }

    private static String formatRoot() {
        if (!StringUtils.endsWith((CharSequence)root, (CharSequence)"/")) {
            return root + "/";
        }
        return root;
    }

    private static String dateByFileId(String fileId) {
        return fileId.substring(0, 10);
    }

    private static String fileIdByDate(String dateStr) {
        dateStr = StringUtils.isBlank((CharSequence)dateStr) ? DateUtil.formatDate((Date)new Date()) : dateStr;
        String uuid = IdUtil.fastUUID();
        return dateStr + SPLITOR + uuid;
    }

    public static String filePathById(String fileId, String suffix) {
        String dateStr = GlobalFileUtil.dateByFileId(fileId);
        String dirPath = GlobalFileUtil.formatRoot() + dateStr;
        if (!FileUtil.exist((String)dirPath)) {
            throw new RuntimeException("dir path is not exist [" + dirPath + "]");
        }
        if (StringUtils.isNotBlank((CharSequence)suffix)) {
            String filePath = dirPath + "/" + fileId + "." + suffix;
            if (!FileUtil.exist((String)filePath)) {
                throw new RuntimeException("file path is not exist [" + filePath + "]");
            }
            return filePath;
        }
        List fileNames = FileUtil.listFileNames((String)dirPath);
        for (int i = 0; i < fileNames.size(); ++i) {
            String fileName = (String)fileNames.get(i);
            String prefix = FileUtil.getPrefix((String)fileName);
            if (!StringUtils.equals((CharSequence)fileId, (CharSequence)prefix)) continue;
            return dirPath + "/" + fileName;
        }
        return null;
    }
}

