/*
 * Decompiled with CFR 0.152.
 */
package io.dataease.plugins.common.util;

import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.springframework.util.StringUtils;

public class CodingUtil {
    private static final String UTF_8 = "UTF-8";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String md5(String src) {
        return CodingUtil.md5(src, UTF_8);
    }

    public static String md5(String src, String charset) {
        try {
            byte[] strTemp = StringUtils.isEmpty((Object)charset) ? src.getBytes() : src.getBytes(charset);
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(strTemp);
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (byte byte0 : md) {
                str[k++] = HEX_DIGITS[byte0 >>> 4 & 0xF];
                str[k++] = HEX_DIGITS[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            throw new RuntimeException("MD5 encrypt error:", e);
        }
    }

    public static String base64Decoding(String src) {
        String result = null;
        if (src != null) {
            try {
                byte[] b = Base64.decodeBase64((String)src);
                result = new String(b, UTF_8);
            }
            catch (Exception e) {
                throw new RuntimeException("BASE64 decoding error:", e);
            }
        }
        return result;
    }

    public static String base64Encoding(String src) {
        String result = null;
        if (src != null) {
            try {
                result = Base64.encodeBase64String((byte[])src.getBytes(UTF_8));
            }
            catch (Exception e) {
                throw new RuntimeException("BASE64 encoding error:", e);
            }
        }
        return result;
    }

    public static String aesEncrypt(String src, String secretKey, String iv) {
        if (StringUtils.isEmpty((Object)secretKey)) {
            throw new RuntimeException("secretKey is empty");
        }
        try {
            byte[] raw = secretKey.getBytes(UTF_8);
            SecretKeySpec secretKeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            IvParameterSpec iv1 = new IvParameterSpec(iv.getBytes());
            cipher.init(1, (Key)secretKeySpec, iv1);
            byte[] encrypted = cipher.doFinal(src.getBytes(UTF_8));
            return Base64.encodeBase64String((byte[])encrypted);
        }
        catch (Exception e) {
            throw new RuntimeException("AES encrypt error:", e);
        }
    }

    public static String aesDecrypt(String src, String secretKey, String iv) {
        if (StringUtils.isEmpty((Object)secretKey)) {
            throw new RuntimeException("secretKey is empty");
        }
        try {
            byte[] raw = secretKey.getBytes(UTF_8);
            SecretKeySpec secretKeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            IvParameterSpec iv1 = new IvParameterSpec(iv.getBytes());
            cipher.init(2, (Key)secretKeySpec, iv1);
            byte[] encrypted1 = Base64.decodeBase64((String)src);
            byte[] original = cipher.doFinal(encrypted1);
            return new String(original, UTF_8);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            return src;
        }
        catch (Exception e) {
            throw new RuntimeException("decrypt error\uff0cplease check parameters", e);
        }
    }

    public static String secretKey() {
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(128);
            SecretKey secretKey = keyGen.generateKey();
            return Base64.encodeBase64String((byte[])secretKey.getEncoded());
        }
        catch (Exception e) {
            throw new RuntimeException("generate secretKey error", e);
        }
    }
}

