/*
 * Decompiled with CFR 0.152.
 */
package io.dataease.plugins.datasource.provider;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;

public class ExtendedJdbcClassLoader
extends URLClassLoader {
    private String driver;

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public ExtendedJdbcClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            try {
                c = this.findClass(name);
                if (c != null) {
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    return c;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                if (this.getParent() != null && (c = super.loadClass(name, resolve)) != null) {
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    return c;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                c = this.findSystemClass(name);
                if (c != null) {
                    if (resolve) {
                        this.resolveClass(c);
                    }
                    return c;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            throw new ClassNotFoundException(name);
        }
    }

    public void addFile(String s) throws IOException {
        File f = new File(s);
        this.addFile(f);
    }

    public void addFile(File f) throws IOException {
        this.addFile(f.toURI().toURL());
    }

    public void addFile(URL u) throws IOException {
        try {
            this.addURL(u);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }
}

