/*
 * Decompiled with CFR 0.152.
 */
package io.dataease.plugins.datasource.provider;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.wall.WallFilter;
import com.google.gson.Gson;
import io.dataease.plugins.common.base.domain.Datasource;
import io.dataease.plugins.common.base.domain.DeDriver;
import io.dataease.plugins.common.constants.DatasourceTypes;
import io.dataease.plugins.common.dto.datasource.TableDesc;
import io.dataease.plugins.common.dto.datasource.TableField;
import io.dataease.plugins.common.exception.DataEaseException;
import io.dataease.plugins.common.request.datasource.DatasourceRequest;
import io.dataease.plugins.datasource.entity.JdbcConfiguration;
import io.dataease.plugins.datasource.provider.ExtendedJdbcClassLoader;
import io.dataease.plugins.datasource.provider.Provider;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;

public abstract class DefaultJdbcProvider
extends Provider {
    protected Map<String, DruidDataSource> jdbcConnection = new HashMap<String, DruidDataSource>();
    protected ExtendedJdbcClassLoader extendedJdbcClassLoader;
    private Map<String, ExtendedJdbcClassLoader> customJdbcClassLoaders = new HashMap<String, ExtendedJdbcClassLoader>();
    private static final String FILE_PATH = "/opt/dataease/drivers";
    private static final String THIRDPART_PATH = "/opt/dataease/plugins/thirdpart";
    private static final String DEFAULT_PATH = "/opt/dataease/plugins/default";
    private static final String CUSTOM_PATH = "/opt/dataease/custom-drivers/";

    public abstract boolean isUseDatasourcePool();

    @PostConstruct
    public void init() throws Exception {
        List<String> builtinPlugins = Arrays.asList("maxcompute", "presto", "dm", "mongobi", "kylin", "kingbase");
        Object jarPath = FILE_PATH;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (!this.getType().equalsIgnoreCase("built-in")) {
            jarPath = builtinPlugins.contains(this.getType()) ? "/opt/dataease/plugins/default/" + this.getType() + "Driver" : "/opt/dataease/plugins/thirdpart/" + this.getType() + "Driver";
            while (classLoader.getParent() != null && !(classLoader = classLoader.getParent()).toString().contains("ExtClassLoader")) {
            }
        }
        this.extendedJdbcClassLoader = new ExtendedJdbcClassLoader(new URL[]{new File((String)jarPath).toURI().toURL()}, classLoader);
        File file = new File((String)jarPath);
        File[] array = file.listFiles();
        Optional.ofNullable(array).ifPresent(files -> {
            for (File tmp : array) {
                if (!tmp.getName().endsWith(".jar")) continue;
                try {
                    this.extendedJdbcClassLoader.addFile(tmp);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public abstract String getType();

    @Override
    public List<String[]> getData(DatasourceRequest dsr) throws Exception {
        List<String[]> list = new LinkedList<String[]>();
        JdbcConfiguration jdbcConfiguration = (JdbcConfiguration)new Gson().fromJson(dsr.getDatasource().getConfiguration(), JdbcConfiguration.class);
        int queryTimeout = jdbcConfiguration.getQueryTimeout() > 0 ? jdbcConfiguration.getQueryTimeout() : 0;
        try (Connection connection = this.getConnectionFromPool(dsr);
             Statement stat = this.getStatement(connection, queryTimeout);
             ResultSet rs = stat.executeQuery(dsr.getQuery());){
            list = this.getDataResult(rs);
            if (dsr.isPageable() && (dsr.getDatasource().getType().equalsIgnoreCase(DatasourceTypes.sqlServer.name()) || dsr.getDatasource().getType().equalsIgnoreCase(DatasourceTypes.db2.name()))) {
                Integer realSize = dsr.getPage() * dsr.getPageSize() < list.size() ? dsr.getPage() * dsr.getPageSize() : list.size();
                list = list.subList((dsr.getPage() - 1) * dsr.getPageSize(), realSize);
            }
        }
        catch (SQLException e) {
            DataEaseException.throwException((String)("SQL ERROR" + e.getMessage()));
        }
        catch (Exception e) {
            DataEaseException.throwException((String)("Data source connection exception: " + e.getMessage()));
        }
        return list;
    }

    public Statement getStatement(Connection connection, int queryTimeout) throws Exception {
        if (connection == null) {
            throw new Exception("Failed to get connection!");
        }
        Statement stat = connection.createStatement();
        try {
            stat.setQueryTimeout(queryTimeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stat;
    }

    public void exec(DatasourceRequest datasourceRequest) throws Exception {
        try (Connection connection = this.getConnectionFromPool(datasourceRequest);
             Statement stat = connection.createStatement();){
            Boolean bl = stat.execute(datasourceRequest.getQuery());
        }
        catch (SQLException e) {
            DataEaseException.throwException((Throwable)e);
        }
        catch (Exception e) {
            DataEaseException.throwException((Throwable)e);
        }
    }

    @Override
    public List<TableDesc> getTables(DatasourceRequest datasourceRequest) throws Exception {
        ArrayList<TableDesc> tables = new ArrayList<TableDesc>();
        String queryStr = this.getTablesSql(datasourceRequest);
        JdbcConfiguration jdbcConfiguration = (JdbcConfiguration)new Gson().fromJson(datasourceRequest.getDatasource().getConfiguration(), JdbcConfiguration.class);
        int queryTimeout = jdbcConfiguration.getQueryTimeout() > 0 ? jdbcConfiguration.getQueryTimeout() : 0;
        try (Connection con = this.getConnectionFromPool(datasourceRequest);
             Statement statement = this.getStatement(con, queryTimeout);
             ResultSet resultSet = statement.executeQuery(queryStr);){
            while (resultSet.next()) {
                tables.add(this.getTableDesc(datasourceRequest, resultSet));
            }
        }
        catch (Exception e) {
            DataEaseException.throwException((Throwable)e);
        }
        String queryView = this.getViewSql(datasourceRequest);
        if (queryView != null) {
            try (Connection con = this.getConnectionFromPool(datasourceRequest);
                 Statement statement = this.getStatement(con, queryTimeout);
                 ResultSet resultSet = statement.executeQuery(queryView);){
                while (resultSet.next()) {
                    tables.add(this.getTableDesc(datasourceRequest, resultSet));
                }
            }
            catch (Exception e) {
                DataEaseException.throwException((Throwable)e);
            }
        }
        return tables;
    }

    @Override
    public String checkStatus(DatasourceRequest datasourceRequest) throws Exception {
        String queryStr = this.getTablesSql(datasourceRequest);
        JdbcConfiguration jdbcConfiguration = (JdbcConfiguration)new Gson().fromJson(datasourceRequest.getDatasource().getConfiguration(), JdbcConfiguration.class);
        int queryTimeout = jdbcConfiguration.getQueryTimeout() > 0 ? jdbcConfiguration.getQueryTimeout() : 0;
        try (Connection con = this.getConnection(datasourceRequest);
             Statement statement = this.getStatement(con, queryTimeout);){
            ResultSet resultSet = statement.executeQuery(queryStr);
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception e) {
            DataEaseException.throwException((String)e.getMessage());
        }
        return "Success";
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String[]> fetchResult(DatasourceRequest datasourceRequest) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<TableField> fetchResultField(DatasourceRequest datasourceRequest) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<String, List> fetchResultAndField(DatasourceRequest datasourceRequest) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void handleDatasource(DatasourceRequest datasourceRequest, String type) throws Exception {
        if (!this.isUseDatasourcePool()) {
            return;
        }
        DruidDataSource dataSource = null;
        switch (type) {
            case "add": {
                this.checkStatus(datasourceRequest);
                dataSource = this.jdbcConnection.get(datasourceRequest.getDatasource().getId());
                if (dataSource != null) break;
                this.addToPool(datasourceRequest);
                break;
            }
            case "edit": {
                dataSource = this.jdbcConnection.get(datasourceRequest.getDatasource().getId());
                if (dataSource != null) {
                    dataSource.close();
                    this.jdbcConnection.remove(datasourceRequest.getDatasource().getId());
                }
                this.checkStatus(datasourceRequest);
                this.addToPool(datasourceRequest);
                break;
            }
            case "delete": {
                dataSource = this.jdbcConnection.get(datasourceRequest.getDatasource().getId());
                if (dataSource == null) break;
                dataSource.close();
                this.jdbcConnection.remove(datasourceRequest.getDatasource().getId());
                break;
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> getSchema(DatasourceRequest datasourceRequest) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<TableField> getTableFields(DatasourceRequest datasourceRequest) throws Exception {
        LinkedList<TableField> list = new LinkedList<TableField>();
        try (Connection connection = this.getConnectionFromPool(datasourceRequest);){
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getColumns(null, "%", datasourceRequest.getTable(), "%");
            while (resultSet.next()) {
                TableField tableField;
                String tableName = resultSet.getString("TABLE_NAME");
                String database = datasourceRequest.getDatasource().getType().equalsIgnoreCase(DatasourceTypes.ck.name()) || datasourceRequest.getDatasource().getType().equalsIgnoreCase(DatasourceTypes.impala.name()) ? resultSet.getString("TABLE_SCHEM") : resultSet.getString("TABLE_CAT");
                if (database != null) {
                    if (!tableName.equals(datasourceRequest.getTable()) || !database.equalsIgnoreCase(this.getDatabase(datasourceRequest))) continue;
                    tableField = this.getTableFiled(resultSet, datasourceRequest);
                    list.add(tableField);
                    continue;
                }
                if (!tableName.equals(datasourceRequest.getTable())) continue;
                tableField = this.getTableFiled(resultSet, datasourceRequest);
                list.add(tableField);
            }
            resultSet.close();
        }
        catch (SQLException e) {
            DataEaseException.throwException((Throwable)e);
        }
        catch (Exception e) {
            if (datasourceRequest.getDatasource().getType().equalsIgnoreCase("ds_doris")) {
                datasourceRequest.setQuery("select * from " + datasourceRequest.getTable());
                return this.fetchResultField(datasourceRequest);
            }
            DataEaseException.throwException((String)("Data source connection exception: " + e.getMessage()));
        }
        return list;
    }

    @Override
    public String getTablesSql(DatasourceRequest datasourceRequest) throws Exception {
        return "show tables;";
    }

    @Override
    public String getViewSql(DatasourceRequest datasourceRequest) throws Exception {
        return null;
    }

    @Override
    public String getSchemaSql(DatasourceRequest datasourceRequest) {
        return null;
    }

    @Override
    public Connection getConnectionFromPool(DatasourceRequest datasourceRequest) throws Exception {
        if (!this.isUseDatasourcePool()) {
            return this.getConnection(datasourceRequest);
        }
        if (datasourceRequest.getDatasource().getType().equalsIgnoreCase(DatasourceTypes.mongo.name()) || datasourceRequest.getDatasource().getType().equalsIgnoreCase(DatasourceTypes.impala.name()) || datasourceRequest.getDatasource().getType().equalsIgnoreCase(DatasourceTypes.hive.name())) {
            return this.getConnection(datasourceRequest);
        }
        DruidDataSource dataSource = this.jdbcConnection.get(datasourceRequest.getDatasource().getId());
        if (dataSource == null) {
            this.handleDatasource(datasourceRequest, "add");
        }
        dataSource = this.jdbcConnection.get(datasourceRequest.getDatasource().getId());
        DruidPooledConnection co = dataSource.getConnection();
        return co;
    }

    @Override
    public void addToPool(DatasourceRequest datasourceRequest) throws Exception {
        if (!this.isUseDatasourcePool()) {
            return;
        }
        DruidDataSource druidDataSource = new DruidDataSource();
        JdbcConfiguration jdbcConfiguration = this.setCredential(datasourceRequest, druidDataSource);
        druidDataSource.setInitialSize(jdbcConfiguration.getInitialPoolSize());
        druidDataSource.setMinIdle(jdbcConfiguration.getMinPoolSize());
        druidDataSource.setMaxActive(jdbcConfiguration.getMaxPoolSize());
        if (datasourceRequest.getDatasource().getType().equals(DatasourceTypes.mongo.name()) || datasourceRequest.getDatasource().getType().equals(DatasourceTypes.hive.name()) || datasourceRequest.getDatasource().getType().equals(DatasourceTypes.impala.name())) {
            WallFilter wallFilter = new WallFilter();
            wallFilter.setDbType(DatasourceTypes.mysql.name());
            druidDataSource.setProxyFilters(Arrays.asList(wallFilter));
        }
        druidDataSource.init();
        this.jdbcConnection.put(datasourceRequest.getDatasource().getId(), druidDataSource);
    }

    @Override
    public JdbcConfiguration setCredential(DatasourceRequest datasourceRequest, DruidDataSource dataSource) throws Exception {
        return null;
    }

    public void reloadCustomJdbcClassLoader(DeDriver deDriver) throws Exception {
        if (this.customJdbcClassLoaders.get(deDriver.getId()) != null) {
            this.customJdbcClassLoaders.remove(deDriver.getId());
        }
        this.addCustomJdbcClassLoader(deDriver);
    }

    private TableField getTableFiled(ResultSet resultSet, DatasourceRequest datasourceRequest) throws SQLException {
        String size;
        TableField tableField = new TableField();
        String colName = resultSet.getString("COLUMN_NAME");
        tableField.setFieldName(colName);
        String remarks = resultSet.getString("REMARKS");
        if (remarks == null || remarks.equals("")) {
            remarks = colName;
        }
        tableField.setRemarks(remarks);
        String dbType = resultSet.getString("TYPE_NAME").toUpperCase();
        tableField.setFieldType(dbType);
        if (dbType.equalsIgnoreCase("LONG")) {
            tableField.setFieldSize(65533);
        }
        if (StringUtils.isNotEmpty((CharSequence)dbType) && dbType.toLowerCase().contains("date") && tableField.getFieldSize() < 50) {
            tableField.setFieldSize(50);
        }
        if ((size = resultSet.getString("COLUMN_SIZE")) == null) {
            tableField.setFieldSize(1);
        } else {
            tableField.setFieldSize(Integer.valueOf(size).intValue());
        }
        return tableField;
    }

    private List<TableField> fetchResultField(ResultSet rs, DatasourceRequest datasourceRequest) throws Exception {
        ArrayList<TableField> fieldList = new ArrayList<TableField>();
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        for (int j = 0; j < columnCount; ++j) {
            String f = metaData.getColumnName(j + 1);
            String l = StringUtils.isNotEmpty((CharSequence)metaData.getColumnLabel(j + 1)) ? metaData.getColumnLabel(j + 1) : f;
            String t = metaData.getColumnTypeName(j + 1);
            if (datasourceRequest.getDatasource().getType().equalsIgnoreCase(DatasourceTypes.hive.name()) && l.contains(".")) {
                l = l.split("\\.")[1];
            }
            TableField field = new TableField();
            field.setFieldName(l);
            field.setRemarks(l);
            field.setFieldType(t);
            field.setFieldSize(metaData.getColumnDisplaySize(j + 1));
            if (t.equalsIgnoreCase("LONG")) {
                field.setFieldSize(65533);
            }
            if (StringUtils.isNotEmpty((CharSequence)t) && t.toLowerCase().contains("date") && field.getFieldSize() < 50) {
                field.setFieldSize(50);
            }
            fieldList.add(field);
        }
        return fieldList;
    }

    private String getDatabase(DatasourceRequest datasourceRequest) {
        JdbcConfiguration jdbcConfiguration = (JdbcConfiguration)new Gson().fromJson(datasourceRequest.getDatasource().getConfiguration(), JdbcConfiguration.class);
        return jdbcConfiguration.getDataBase();
    }

    private List<String[]> getDataResult(ResultSet rs) throws Exception {
        LinkedList<String[]> list = new LinkedList<String[]>();
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        while (rs.next()) {
            String[] row = new String[columnCount];
            block5: for (int j = 0; j < columnCount; ++j) {
                int columnType = metaData.getColumnType(j + 1);
                switch (columnType) {
                    case 91: {
                        if (rs.getDate(j + 1) == null) continue block5;
                        row[j] = rs.getDate(j + 1).toString();
                        continue block5;
                    }
                    case 16: {
                        row[j] = rs.getBoolean(j + 1) ? "1" : "0";
                        continue block5;
                    }
                    default: {
                        row[j] = rs.getString(j + 1);
                    }
                }
            }
            list.add(row);
        }
        return list;
    }

    private TableDesc getTableDesc(DatasourceRequest datasourceRequest, ResultSet resultSet) throws SQLException {
        TableDesc tableDesc = new TableDesc();
        DatasourceTypes datasourceType = DatasourceTypes.valueOf((String)datasourceRequest.getDatasource().getType());
        if (datasourceType == DatasourceTypes.oracle) {
            tableDesc.setRemark(resultSet.getString(3));
        }
        if (datasourceType == DatasourceTypes.mysql) {
            tableDesc.setRemark(resultSet.getString(2));
        }
        tableDesc.setName(resultSet.getString(1));
        return tableDesc;
    }

    protected ExtendedJdbcClassLoader getCustomJdbcClassLoader(DeDriver deDriver) throws Exception {
        if (deDriver == null) {
            throw new Exception("Can not found custom Driver");
        }
        ExtendedJdbcClassLoader customJdbcClassLoader = this.customJdbcClassLoaders.get(deDriver.getId());
        if (customJdbcClassLoader == null) {
            return this.addCustomJdbcClassLoader(deDriver);
        }
        if (StringUtils.isNotEmpty((CharSequence)customJdbcClassLoader.getDriver()) && customJdbcClassLoader.getDriver().equalsIgnoreCase(deDriver.getDriverClass())) {
            return customJdbcClassLoader;
        }
        this.customJdbcClassLoaders.remove(deDriver.getId());
        return this.addCustomJdbcClassLoader(deDriver);
    }

    private synchronized ExtendedJdbcClassLoader addCustomJdbcClassLoader(DeDriver deDriver) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        while (classLoader.getParent() != null && !(classLoader = classLoader.getParent()).toString().contains("ExtClassLoader")) {
        }
        ExtendedJdbcClassLoader customJdbcClassLoader = new ExtendedJdbcClassLoader(new URL[]{new File(CUSTOM_PATH + deDriver.getId()).toURI().toURL()}, classLoader);
        customJdbcClassLoader.setDriver(deDriver.getDriverClass());
        File file = new File(CUSTOM_PATH + deDriver.getId());
        File[] array = file.listFiles();
        Optional.ofNullable(array).ifPresent(files -> {
            for (File tmp : array) {
                if (!tmp.getName().endsWith(".jar")) continue;
                try {
                    customJdbcClassLoader.addFile(tmp);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.customJdbcClassLoaders.put(deDriver.getId(), customJdbcClassLoader);
        return customJdbcClassLoader;
    }

    protected boolean isDefaultClassLoader(String customDriver) {
        return StringUtils.isEmpty((CharSequence)customDriver) || customDriver.equalsIgnoreCase("default");
    }

    @Override
    public void checkConfiguration(Datasource datasource) throws Exception {
        if (StringUtils.isEmpty((CharSequence)datasource.getConfiguration())) {
            throw new Exception("Datasource configuration is empty");
        }
        try {
            JdbcConfiguration jdbcConfiguration = (JdbcConfiguration)new Gson().fromJson(datasource.getConfiguration(), JdbcConfiguration.class);
            if (jdbcConfiguration.getQueryTimeout() < 0) {
                throw new Exception("Querytimeout cannot be less than zero.");
            }
        }
        catch (Exception e) {
            throw new Exception("Invalid configuration: " + e.getMessage());
        }
    }

    public String dsVersion(DatasourceRequest datasourceRequest) throws Exception {
        String string;
        block8: {
            JdbcConfiguration jdbcConfiguration = (JdbcConfiguration)new Gson().fromJson(datasourceRequest.getDatasource().getConfiguration(), JdbcConfiguration.class);
            Connection con = this.getConnectionFromPool(datasourceRequest);
            try {
                string = String.valueOf(con.getMetaData().getDatabaseMajorVersion());
                if (con == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    DataEaseException.throwException((String)e.getMessage());
                    return "";
                }
            }
            con.close();
        }
        return string;
    }
}

