/*
 * Decompiled with CFR 0.152.
 */
package io.dataease.plugins.datasource.query;

import com.google.gson.Gson;
import io.dataease.plugins.common.base.domain.ChartViewWithBLOBs;
import io.dataease.plugins.common.base.domain.DatasetTableField;
import io.dataease.plugins.common.base.domain.Datasource;
import io.dataease.plugins.common.constants.datasource.PgConstants;
import io.dataease.plugins.common.dto.chart.ChartFieldCustomFilterDTO;
import io.dataease.plugins.common.dto.chart.ChartViewFieldDTO;
import io.dataease.plugins.common.dto.dataset.SqlVariableDetails;
import io.dataease.plugins.common.dto.datasource.DeSortField;
import io.dataease.plugins.common.dto.sqlObj.SQLObj;
import io.dataease.plugins.common.request.chart.ChartExtFilterRequest;
import io.dataease.plugins.common.request.permission.DataSetRowPermissionsTreeDTO;
import io.dataease.plugins.common.request.permission.DatasetRowPermissionsTreeItem;
import io.dataease.plugins.common.request.permission.DatasetRowPermissionsTreeObj;
import io.dataease.plugins.datasource.entity.Dateformat;
import io.dataease.plugins.datasource.entity.JdbcConfiguration;
import io.dataease.plugins.datasource.entity.PageInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class QueryProvider {
    public abstract Integer transFieldType(String var1);

    public abstract String createSQLPreview(String var1, String var2);

    public abstract String createQuerySQL(String var1, List<DatasetTableField> var2, boolean var3, Datasource var4, List<ChartFieldCustomFilterDTO> var5, List<DataSetRowPermissionsTreeDTO> var6);

    public abstract String createQuerySQLAsTmp(String var1, List<DatasetTableField> var2, boolean var3, List<ChartFieldCustomFilterDTO> var4, List<DataSetRowPermissionsTreeDTO> var5);

    public abstract String createQuerySQL(String var1, List<DatasetTableField> var2, boolean var3, Datasource var4, List<ChartFieldCustomFilterDTO> var5, List<DataSetRowPermissionsTreeDTO> var6, List<DeSortField> var7);

    public abstract String createQuerySQLAsTmp(String var1, List<DatasetTableField> var2, boolean var3, List<ChartFieldCustomFilterDTO> var4, List<DataSetRowPermissionsTreeDTO> var5, List<DeSortField> var6);

    public abstract String createQueryTableWithPage(String var1, List<DatasetTableField> var2, Integer var3, Integer var4, Integer var5, boolean var6, Datasource var7, List<ChartFieldCustomFilterDTO> var8, List<DataSetRowPermissionsTreeDTO> var9);

    public abstract String createQuerySQLWithPage(String var1, List<DatasetTableField> var2, Integer var3, Integer var4, Integer var5, boolean var6, List<ChartFieldCustomFilterDTO> var7, List<DataSetRowPermissionsTreeDTO> var8);

    public abstract String createQueryTableWithLimit(String var1, List<DatasetTableField> var2, Integer var3, boolean var4, Datasource var5, List<ChartFieldCustomFilterDTO> var6, List<DataSetRowPermissionsTreeDTO> var7);

    public abstract String createQuerySqlWithLimit(String var1, List<DatasetTableField> var2, Integer var3, boolean var4, List<ChartFieldCustomFilterDTO> var5, List<DataSetRowPermissionsTreeDTO> var6);

    public abstract String getSQL(String var1, List<ChartViewFieldDTO> var2, List<ChartViewFieldDTO> var3, List<ChartFieldCustomFilterDTO> var4, List<DataSetRowPermissionsTreeDTO> var5, List<ChartExtFilterRequest> var6, Datasource var7, ChartViewWithBLOBs var8);

    public abstract String getSQLAsTmp(String var1, List<ChartViewFieldDTO> var2, List<ChartViewFieldDTO> var3, List<ChartFieldCustomFilterDTO> var4, List<DataSetRowPermissionsTreeDTO> var5, List<ChartExtFilterRequest> var6, ChartViewWithBLOBs var7);

    public abstract String getSQLTableInfo(String var1, List<ChartViewFieldDTO> var2, List<ChartFieldCustomFilterDTO> var3, List<DataSetRowPermissionsTreeDTO> var4, List<ChartExtFilterRequest> var5, Datasource var6, ChartViewWithBLOBs var7);

    public abstract String getSQLAsTmpTableInfo(String var1, List<ChartViewFieldDTO> var2, List<ChartFieldCustomFilterDTO> var3, List<DataSetRowPermissionsTreeDTO> var4, List<ChartExtFilterRequest> var5, Datasource var6, ChartViewWithBLOBs var7);

    public String getSQLWithPage(boolean isTable, String sql, List<ChartViewFieldDTO> xAxis, List<ChartFieldCustomFilterDTO> fieldCustomFilter, List<DataSetRowPermissionsTreeDTO> rowPermissionsTree, List<ChartExtFilterRequest> extFilterRequestList, Datasource ds, ChartViewWithBLOBs view, PageInfo pageInfo) {
        if (isTable) {
            return this.getSQLTableInfo(sql, xAxis, fieldCustomFilter, rowPermissionsTree, extFilterRequestList, ds, view);
        }
        return this.getSQLAsTmpTableInfo(sql, xAxis, fieldCustomFilter, rowPermissionsTree, extFilterRequestList, ds, view);
    }

    public String getResultCount(boolean isTable, String sql, List<ChartViewFieldDTO> xAxis, List<ChartFieldCustomFilterDTO> fieldCustomFilter, List<DataSetRowPermissionsTreeDTO> rowPermissionsTree, List<ChartExtFilterRequest> extFilterRequestList, Datasource ds, ChartViewWithBLOBs view) {
        if (isTable) {
            return "SELECT COUNT(*) from (" + this.getSQLTableInfo(sql, xAxis, fieldCustomFilter, rowPermissionsTree, extFilterRequestList, ds, view) + ") COUNT_TEMP";
        }
        return "SELECT COUNT(*) from (" + this.getSQLAsTmpTableInfo(sql, xAxis, fieldCustomFilter, rowPermissionsTree, extFilterRequestList, ds, view) + ") COUNT_TEMP";
    }

    public abstract String getSQLStack(String var1, List<ChartViewFieldDTO> var2, List<ChartViewFieldDTO> var3, List<ChartFieldCustomFilterDTO> var4, List<DataSetRowPermissionsTreeDTO> var5, List<ChartExtFilterRequest> var6, List<ChartViewFieldDTO> var7, Datasource var8, ChartViewWithBLOBs var9);

    public abstract String getSQLAsTmpStack(String var1, List<ChartViewFieldDTO> var2, List<ChartViewFieldDTO> var3, List<ChartFieldCustomFilterDTO> var4, List<DataSetRowPermissionsTreeDTO> var5, List<ChartExtFilterRequest> var6, List<ChartViewFieldDTO> var7, ChartViewWithBLOBs var8);

    public abstract String getSQLScatter(String var1, List<ChartViewFieldDTO> var2, List<ChartViewFieldDTO> var3, List<ChartFieldCustomFilterDTO> var4, List<DataSetRowPermissionsTreeDTO> var5, List<ChartExtFilterRequest> var6, List<ChartViewFieldDTO> var7, Datasource var8, ChartViewWithBLOBs var9);

    public abstract String getSQLAsTmpScatter(String var1, List<ChartViewFieldDTO> var2, List<ChartViewFieldDTO> var3, List<ChartFieldCustomFilterDTO> var4, List<DataSetRowPermissionsTreeDTO> var5, List<ChartExtFilterRequest> var6, List<ChartViewFieldDTO> var7, ChartViewWithBLOBs var8);

    public abstract String searchTable(String var1);

    public abstract String getSQLSummary(String var1, List<ChartViewFieldDTO> var2, List<ChartFieldCustomFilterDTO> var3, List<DataSetRowPermissionsTreeDTO> var4, List<ChartExtFilterRequest> var5, ChartViewWithBLOBs var6, Datasource var7);

    public Integer transFieldSize(String type) {
        return 50;
    }

    public abstract String getSQLSummaryAsTmp(String var1, List<ChartViewFieldDTO> var2, List<ChartFieldCustomFilterDTO> var3, List<DataSetRowPermissionsTreeDTO> var4, List<ChartExtFilterRequest> var5, ChartViewWithBLOBs var6);

    public abstract String wrapSql(String var1);

    public abstract String createRawQuerySQL(String var1, List<DatasetTableField> var2, Datasource var3);

    public abstract String createRawQuerySQLAsTmp(String var1, List<DatasetTableField> var2);

    public abstract String transTreeItem(SQLObj var1, DatasetRowPermissionsTreeItem var2);

    public void setSchema(SQLObj tableObj, Datasource ds) {
        String schema;
        JdbcConfiguration configuration;
        if (ds != null && !tableObj.getTableName().startsWith("(") && !tableObj.getTableName().endsWith(")") && ObjectUtils.isNotEmpty((Object)(configuration = (JdbcConfiguration)new Gson().fromJson(ds.getConfiguration(), JdbcConfiguration.class))) && StringUtils.isNotBlank((CharSequence)(schema = configuration.getSchema()))) {
            schema = String.format(PgConstants.KEYWORD_TABLE, schema);
            tableObj.setTableName(schema + "." + tableObj.getTableName());
        }
    }

    public String convertTableToSql(String tableName, Datasource ds) {
        return "select * from  TABLE_NAME".replace("TABLE_NAME", tableName);
    }

    public String getLogic(String logic) {
        if (logic != null) {
            switch (logic) {
                case "and": {
                    return "AND";
                }
                case "or": {
                    return "OR";
                }
            }
        }
        return "AND";
    }

    public String transFilter(ChartExtFilterRequest chartExtFilterRequest, SqlVariableDetails sqlVariableDetails) {
        if (chartExtFilterRequest.getOperator().equals("in")) {
            return "('" + String.join((CharSequence)"','", chartExtFilterRequest.getValue()) + "')";
        }
        if (chartExtFilterRequest.getOperator().equals("between")) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sqlVariableDetails.getType().size() > 1 ? (String)sqlVariableDetails.getType().get(1) : "YYYY");
            return simpleDateFormat.format(new Date(Long.parseLong((String)chartExtFilterRequest.getValue().get(0))));
        }
        return (String)chartExtFilterRequest.getValue().get(0);
    }

    public String transFilterTrees(SQLObj tableObj, List<DataSetRowPermissionsTreeDTO> requestList) {
        if (CollectionUtils.isEmpty(requestList)) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        for (DataSetRowPermissionsTreeDTO request : requestList) {
            String treeExp;
            DatasetRowPermissionsTreeObj tree = request.getTree();
            if (ObjectUtils.isEmpty((Object)tree) || !StringUtils.isNotEmpty((CharSequence)(treeExp = this.transTreeToWhere(tableObj, tree)))) continue;
            res.add(treeExp);
        }
        return CollectionUtils.isNotEmpty(res) ? "(" + String.join((CharSequence)" AND ", res) + ")" : null;
    }

    private String transTreeToWhere(SQLObj tableObj, DatasetRowPermissionsTreeObj tree) {
        if (ObjectUtils.isEmpty((Object)tree)) {
            return null;
        }
        String logic = tree.getLogic();
        List items = tree.getItems();
        ArrayList<String> list = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            for (DatasetRowPermissionsTreeItem item : items) {
                String exp = null;
                if (StringUtils.equalsIgnoreCase((CharSequence)item.getType(), (CharSequence)"item")) {
                    exp = this.transTreeItem(tableObj, item);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)item.getType(), (CharSequence)"tree")) {
                    exp = this.transTreeToWhere(tableObj, item.getSubTree());
                }
                if (!StringUtils.isNotEmpty((CharSequence)exp)) continue;
                list.add(exp);
            }
        }
        return CollectionUtils.isNotEmpty(list) ? "(" + String.join((CharSequence)(" " + logic + " "), list) + ")" : null;
    }

    public String sqlForPreview(String table, Datasource ds) {
        return "SELECT * FROM " + table;
    }

    public List<Dateformat> dateformat() {
        return new ArrayList<Dateformat>();
    }

    public String getTotalCount(boolean isTable, String sql, Datasource ds) {
        return null;
    }
}

