/*
 * Decompiled with CFR 0.152.
 */
package io.dataease.plugins.view.handler.impl;

import io.dataease.plugins.common.util.ConstantsUtil;
import io.dataease.plugins.view.entity.PluginSingleField;
import io.dataease.plugins.view.entity.PluginViewField;
import io.dataease.plugins.view.entity.PluginViewParam;
import io.dataease.plugins.view.entity.PluginViewSQL;
import io.dataease.plugins.view.entity.PluginViewSet;
import io.dataease.plugins.view.handler.PluginViewStatHandler;
import io.dataease.plugins.view.service.ViewPluginBaseService;
import io.dataease.plugins.view.service.ViewPluginService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupFile;

public class DefaultViewStatHandler
implements PluginViewStatHandler {
    @Override
    public String build(PluginViewParam pluginViewParam, ViewPluginService viewPluginService) {
        ViewPluginBaseService baseService = viewPluginService.getBaseService();
        PluginViewSet pluginViewSet = pluginViewParam.getPluginViewSet();
        String dsType = pluginViewSet.getDsType();
        PluginViewSQL tableObj = baseService.getTableObj(pluginViewSet);
        HashMap<String, List> fieldSQLMap = new HashMap<String, List>();
        for (int i = 0; i < pluginViewParam.getPluginViewFields().size(); ++i) {
            PluginViewField pluginViewField = pluginViewParam.getPluginViewFields().get(i);
            String typeKey = pluginViewField.getTypeField();
            PluginSingleField pluginSingleField = baseService.buildField(dsType, pluginViewField, tableObj, i);
            List lists = fieldSQLMap.getOrDefault(typeKey, new ArrayList());
            lists.add(pluginSingleField);
            fieldSQLMap.put(typeKey, lists);
        }
        List xFields = ((List)fieldSQLMap.get("xAxis")).stream().filter(singleField -> ObjectUtils.isNotEmpty((Object)singleField.getField())).map(singleField -> singleField.getField()).collect(Collectors.toList());
        List xOrders = ((List)fieldSQLMap.get("xAxis")).stream().filter(singleField -> ObjectUtils.isNotEmpty((Object)singleField.getSort())).map(singleField -> singleField.getSort()).collect(Collectors.toList());
        List yFields = ((List)fieldSQLMap.get("yAxis")).stream().filter(singleField -> ObjectUtils.isNotEmpty((Object)singleField.getField())).map(singleField -> singleField.getField()).collect(Collectors.toList());
        List yOrders = ((List)fieldSQLMap.get("yAxis")).stream().filter(singleField -> ObjectUtils.isNotEmpty((Object)singleField.getSort())).map(singleField -> singleField.getSort()).collect(Collectors.toList());
        List yWheres = ((List)fieldSQLMap.get("yAxis")).stream().filter(singleField -> ObjectUtils.isNotEmpty((Object)singleField.getWhere())).map(singleField -> singleField.getWhere()).collect(Collectors.toList());
        String customWheres = baseService.customWhere(dsType, pluginViewParam.getPluginChartFieldCustomFilters(), tableObj);
        String panelWheres = baseService.panelWhere(dsType, pluginViewParam.getPluginChartExtFilters(), tableObj);
        ArrayList<String> wheres = new ArrayList<String>();
        if (customWheres != null) {
            wheres.add(customWheres);
        }
        if (panelWheres != null) {
            wheres.add(panelWheres);
        }
        ArrayList groups = new ArrayList();
        groups.addAll(xFields);
        ArrayList orders = new ArrayList();
        orders.addAll(xOrders);
        orders.addAll(yOrders);
        ArrayList aggWheres = new ArrayList();
        aggWheres.addAll(yWheres.stream().filter(ObjectUtils::isNotEmpty).collect(Collectors.toList()));
        STGroupFile stg = new STGroupFile("pluginSqltemplate.stg");
        ST st_sql = stg.getInstanceOf("querySql");
        if (CollectionUtils.isNotEmpty(xFields)) {
            st_sql.add("groups", xFields);
        }
        if (CollectionUtils.isNotEmpty(yFields)) {
            st_sql.add("aggregators", yFields);
        }
        if (CollectionUtils.isNotEmpty(wheres)) {
            st_sql.add("filters", wheres);
        }
        if (ObjectUtils.isNotEmpty((Object)tableObj)) {
            st_sql.add("table", (Object)tableObj);
        }
        String sql = st_sql.render();
        String brackets = ConstantsUtil.constantsValue((String)dsType, (String)"BRACKETS");
        String table_alias_prefix = ConstantsUtil.constantsValue((String)dsType, (String)"TABLE_ALIAS_PREFIX");
        ST st = stg.getInstanceOf("querySql");
        PluginViewSQL tableSQL = PluginViewSQL.builder().tableName(String.format(brackets, sql)).tableAlias(String.format(table_alias_prefix, 1)).build();
        if (CollectionUtils.isNotEmpty(aggWheres)) {
            st.add("filters", aggWheres);
        }
        if (CollectionUtils.isNotEmpty(orders)) {
            st.add("orders", orders);
        }
        if (ObjectUtils.isNotEmpty((Object)tableSQL)) {
            st.add("table", (Object)tableSQL);
        }
        return baseService.sqlLimit(dsType, st.render(), pluginViewParam.getPluginViewLimit());
    }
}

