/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.core;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DataFXUtils {
    public static boolean canAccess(Class<?> controllerClass, String resourceName) {
        try {
            URL url = controllerClass.getResource(resourceName);
            return url != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void setPrivileged(final Field field, final Object bean, final Object value) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                boolean wasAccessible = field.isAccessible();
                try {
                    field.setAccessible(true);
                    field.set(bean, value);
                    Void void_ = null;
                    return void_;
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    throw new IllegalStateException("Cannot set field: " + field, ex);
                }
                finally {
                    field.setAccessible(wasAccessible);
                }
            }
        });
    }

    public static <T> T getPrivileged(final Field field, final Object bean) {
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                boolean wasAccessible = field.isAccessible();
                try {
                    field.setAccessible(true);
                    Object object = field.get(bean);
                    return object;
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    throw new IllegalStateException("Cannot access field: " + field, ex);
                }
                finally {
                    field.setAccessible(wasAccessible);
                }
            }
        });
    }

    public static <T> T callPrivileged(final Method method, final Object bean, final Object ... args) {
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                boolean wasAccessible = method.isAccessible();
                try {
                    method.setAccessible(true);
                    Object object = method.invoke(bean, args);
                    return object;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    throw new IllegalStateException("Cannot call Method: " + method, ex);
                }
                finally {
                    method.setAccessible(wasAccessible);
                }
            }
        });
    }

    public static List<Field> getInheritedDeclaredFields(Class<?> type) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> i = type; i != null && i != Object.class; i = i.getSuperclass()) {
            result.addAll(Arrays.asList(i.getDeclaredFields()));
        }
        return result;
    }

    public static List<Method> getInheritedDeclaredMethods(Class<?> type) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> i = type; i != null && i != Object.class; i = i.getSuperclass()) {
            result.addAll(Arrays.asList(i.getDeclaredMethods()));
        }
        return result;
    }
}

