/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.core.concurrent;

import io.datafx.core.concurrent.ConcurrentUtils;
import io.datafx.core.concurrent.TaskStateHandler;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.concurrent.Task;

public abstract class DataFxTask<V>
extends Task<V>
implements TaskStateHandler {
    private BooleanProperty cancelable = new SimpleBooleanProperty(true);

    public DataFxTask() {
        this.updateTitle("Unknown task");
    }

    @Override
    public void updateTaskTitle(String title) {
        this.updateTitle(title);
    }

    @Override
    public void updateTaskMessage(String message) {
        this.updateMessage(message);
    }

    @Override
    public void updateTaskProgress(double workDone, double max) {
        this.updateProgress(workDone, max);
    }

    @Override
    public void updateTaskProgress(long workDone, long max) {
        this.updateProgress(workDone, max);
    }

    public BooleanProperty cancelableProperty() {
        return this.cancelable;
    }

    public boolean isCancelable() {
        return this.cancelable.get();
    }

    @Override
    public void setCancelable(boolean cancelable) {
        this.cancelable.set(cancelable);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.cancelable.get()) {
            return super.cancel(mayInterruptIfRunning);
        }
        throw new RuntimeException("Task is not cancelable!");
    }

    public void then(Consumer<V> consumer) {
        ConcurrentUtils.then(this, consumer);
    }
}

