/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.controller.context;

import io.datafx.controller.ViewConfiguration;
import io.datafx.controller.context.AbstractContext;
import io.datafx.controller.context.ApplicationContext;
import io.datafx.controller.context.ContextResolver;
import io.datafx.controller.context.ViewMetadata;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javafx.scene.Node;
import javax.annotation.PreDestroy;

public class ViewContext<U>
extends AbstractContext {
    private Node rootNode;
    private U controller;
    private ContextResolver<U> resolver;
    private ViewConfiguration configuration;
    private ViewMetadata metadata;

    public ViewContext(Node rootNode, U controller, ViewMetadata metadata, ViewConfiguration configuration, Object ... resources) {
        this.rootNode = rootNode;
        this.controller = controller;
        this.configuration = configuration;
        this.metadata = metadata;
        if (resources != null) {
            for (Object resource : resources) {
                this.register(resource);
            }
        }
    }

    public ContextResolver<U> getResolver() {
        if (this.resolver == null) {
            this.resolver = new ContextResolver(this);
        }
        return this.resolver;
    }

    public U getController() {
        return this.controller;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public ApplicationContext getApplicationContext() {
        return ApplicationContext.getInstance();
    }

    public void destroy() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (this.controller != null) {
            for (Method method : this.getController().getClass().getDeclaredMethods()) {
                if (!method.isAnnotationPresent(PreDestroy.class)) continue;
                method.invoke(this.getController(), new Object[0]);
            }
        }
    }

    public ViewConfiguration getConfiguration() {
        return this.configuration;
    }

    public ViewMetadata getMetadata() {
        return this.metadata;
    }
}

