/*
 * Decompiled with CFR 0.152.
 */
package io.datafx.controller.flow.context;

import io.datafx.controller.flow.FlowException;
import io.datafx.controller.flow.FlowHandler;
import io.datafx.controller.flow.action.FlowAction;
import io.datafx.controller.flow.action.FlowLink;
import io.datafx.controller.flow.action.FlowTaskAction;
import io.datafx.controller.util.VetoException;
import io.datafx.core.ExceptionHandler;
import java.util.UUID;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;

public class FlowActionHandler {
    private FlowHandler handler;

    public FlowActionHandler(FlowHandler handler) {
        this.handler = handler;
    }

    public void handle(String actionId) throws VetoException, FlowException {
        this.handler.handle(actionId);
    }

    public void handleTask(Class<Runnable> task) throws VetoException, FlowException {
        this.handleAction(new FlowTaskAction(task));
    }

    public <T> void navigate(Class<T> controllerClass) throws VetoException, FlowException {
        this.handleAction(new FlowLink<T>(controllerClass));
    }

    public <T> void navigateBack() throws VetoException, FlowException {
        this.handler.navigateBack();
    }

    private void handleAction(FlowAction action) throws VetoException, FlowException {
        this.handler.handle(action, UUID.randomUUID().toString());
    }

    public ExceptionHandler getExceptionHandler() {
        return this.handler.getExceptionHandler();
    }

    public void attachEventHandler(Node node, String actionId) {
        this.handler.attachEventHandler(node, actionId);
    }

    public void attachLinkEventHandler(MenuItem menuItem, Class<?> controllerClass) {
        this.handler.attachAction(menuItem, () -> {
            try {
                this.navigate(controllerClass);
            }
            catch (Exception e) {
                this.getExceptionHandler().setException((Throwable)e);
            }
        });
    }

    public void attachLinkEventHandler(Node node, Class<?> controllerClass) {
        this.handler.attachAction(node, () -> {
            try {
                this.navigate(controllerClass);
            }
            catch (Exception e) {
                this.getExceptionHandler().setException((Throwable)e);
            }
        });
    }

    public void attachBackEventHandler(MenuItem menuItem) {
        this.handler.attachBackEventHandler(menuItem);
    }

    public void attachBackEventHandler(Node node) {
        this.handler.attachBackEventHandler(node);
    }

    public void attachEventHandler(MenuItem menuItem, String actionId) {
        this.handler.attachEventHandler(menuItem, actionId);
    }
}

